/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAllQueryParam;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvAsmProcessService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDDO;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDO;
import com.elitesland.yst.production.inv.domain.entity.QInvAsmDO;
import com.elitesland.yst.production.inv.domain.service.InvAsmDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvAsmDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.repo.InvAsmDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvAsmRepo;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InvAsmProcessServiceImpl
implements InvAsmProcessService {
    private final InvAsmRepo invAsmRepo;
    private final InvAsmDRepo invAsmDRepo;
    private final InvStkOptBizService invStkOptBizService;
    private final SystemService systemService;
    private final JPAQueryFactory jpaQueryFactory;
    private final InvAsmDomainService invAsmDomainService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(Long id, ProcInstStatus procInstStatus) {
        Optional optionalInvAsmDO = this.invAsmRepo.findById(id);
        if (optionalInvAsmDO.isEmpty()) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QInvAsmDO qInvAsmDO = QInvAsmDO.invAsmDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qInvAsmDO).set(qInvAsmDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{qInvAsmDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: 
            case INTERRUPT: {
                jpaUpdateClause.set((Path)qInvAsmDO.docStatus, (Object)UdcEnum.INV_ASM_STATUS_DR.getValueCode());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)qInvAsmDO.docStatus, (Object)UdcEnum.INV_ASM_STATUS_RJ.getValueCode());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)qInvAsmDO.docStatus, (Object)UdcEnum.INV_ASM_STATUS_CL.getValueCode());
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)qInvAsmDO.docStatus, (Object)UdcEnum.INV_ASM_STATUS_APPING.getValueCode());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)qInvAsmDO.docStatus, (Object)UdcEnum.INV_ASM_STATUS_APPED.getValueCode()).set(qInvAsmDO.approvedTime, (Object)LocalDateTime.now()).set(qInvAsmDO.apprUserId, (Object)SecurityContextUtil.currentUserId()).set((Path)qInvAsmDO.apprUserName, (Object)SecurityContextUtil.currentUserName());
                break;
            }
        }
        jpaUpdateClause.execute();
        if (ProcInstStatus.APPROVED.equals((Object)procInstStatus)) {
            InvAsmAllQueryParam param = new InvAsmAllQueryParam();
            param.setMasId(id);
            List<InvAsmDDO> invAsmDDOS = this.invAsmDRepo.findByMasId(id);
            List<InvAsmDDO> invAsmDDOList = invAsmDDOS.stream().filter(v -> UdcEnum.COM_IO_O.getValueCode().equals(v.getLineType())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(invAsmDDOList)) {
                InvStkCommonOperateDTO stkCommonOperateDTO = this.getInvStkCommonOperateDTO(invAsmDDOList, (InvAsmDO)optionalInvAsmDO.get(), "ASM001");
                this.invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
            }
        }
    }

    @Override
    public ArrayList<String> taskAssignee(Long id, String customParams) {
        List<Long> userIds = this.systemService.findUserIdsByFlowRoles(id, customParams);
        ArrayList<String> userStrIds = new ArrayList<String>();
        if (!org.springframework.util.CollectionUtils.isEmpty(userIds)) {
            userIds.stream().forEach(i -> {
                String userStrId = String.valueOf(i);
                userStrIds.add(userStrId);
            });
            return userStrIds;
        }
        return null;
    }

    @Override
    public Long getAsmOuId(String businessKey, String customParams) {
        Optional<InvAsmDTO> invAsmDTOOptional = this.invAsmDomainService.findIdOne(Long.parseLong(businessKey));
        Long ouId = null;
        if (invAsmDTOOptional.isPresent()) {
            InvAsmDTO invAsmDTO = invAsmDTOOptional.get();
            ouId = invAsmDTO.getOuId();
        }
        return ouId;
    }

    private InvStkCommonOperateDTO getInvStkCommonOperateDTO(List<InvAsmDDO> invAsmDDOS, InvAsmDO invAsmDO, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-", ""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<InvStkCommonOperateBodyDTO>();
        invAsmDDOS.stream().forEach(invAsmDDO -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invAsmDO.getWhId());
            operateBodyDTO.setItemId(invAsmDDO.getItemId());
            operateBodyDTO.setDeter2(invAsmDO.getDeter2());
            operateBodyDTO.setSrcDocId(invAsmDO.getId());
            operateBodyDTO.setDocNo(invAsmDO.getDocNo());
            operateBodyDTO.setSrcDocDid(invAsmDDO.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
            operateBodyDTO.setLineNo(invAsmDDO.getLineNo());
            operateBodyDTO.setCreateUserId(invAsmDO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invAsmDDO.getUom());
            operateBodyDTO.setQty(invAsmDDO.getQty());
            operateBodyDTO.setLotNo(invAsmDDO.getLotNo());
            operateBodyDTO.setOuId(invAsmDO.getOuId());
            operateBodyDTO.setVariId(invAsmDDO.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        operateDTO.setSourceBodyList(operateBodyDTOS);
        return operateDTO;
    }

    public InvAsmProcessServiceImpl(InvAsmRepo invAsmRepo, InvAsmDRepo invAsmDRepo, InvStkOptBizService invStkOptBizService, SystemService systemService, JPAQueryFactory jpaQueryFactory, InvAsmDomainService invAsmDomainService) {
        this.invAsmRepo = invAsmRepo;
        this.invAsmDRepo = invAsmDRepo;
        this.invStkOptBizService = invStkOptBizService;
        this.systemService = systemService;
        this.jpaQueryFactory = jpaQueryFactory;
        this.invAsmDomainService = invAsmDomainService;
    }
}

