/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvCkProcessService;
import com.elitesland.yst.production.inv.domain.entity.ck.QInvCkDO;
import com.elitesland.yst.production.inv.domain.service.InvCkDomainService;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDTO;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvCkProcessServiceImpl
implements InvCkProcessService {
    private final JPAQueryFactory jpaQueryFactory;
    private final SystemService systemService;
    private final InvCkDomainService invCkDomainService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        Optional<InvCkDTO> invCkDTOOptional = this.invCkDomainService.findById(id);
        if (!invCkDTOOptional.isPresent()) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QInvCkDO qInvCkDO = QInvCkDO.invCkDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qInvCkDO).set(qInvCkDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{qInvCkDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: 
            case INTERRUPT: {
                jpaUpdateClause.set((Path)qInvCkDO.docStatus, (Object)UdcEnum.INV_CK_STATUS_DR.getValueCode());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)qInvCkDO.docStatus, (Object)UdcEnum.INV_CK_STATUS_RJ.getValueCode());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)qInvCkDO.docStatus, (Object)UdcEnum.INV_CK_STATUS_CL.getValueCode());
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)qInvCkDO.docStatus, (Object)UdcEnum.INV_CK_STATUS_APPING.getValueCode());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)qInvCkDO.docStatus, (Object)UdcEnum.INV_CK_STATUS_APPED.getValueCode()).set(qInvCkDO.approvedTime, (Object)LocalDateTime.now()).set(qInvCkDO.apprUserId, (Object)SecurityContextUtil.currentUserId()).set((Path)qInvCkDO.apprUserName, (Object)SecurityContextUtil.currentUserName());
                break;
            }
        }
        jpaUpdateClause.execute();
    }

    @Override
    public ArrayList<String> taskAssignee(Long id, String customParams) {
        List<Long> userIds = this.systemService.findUserIdsByFlowRoles(id, customParams);
        ArrayList<String> userStrIds = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds.stream().forEach(i -> {
                String newString = String.valueOf(i);
                userStrIds.add(newString);
            });
            return userStrIds;
        }
        return null;
    }

    public InvCkProcessServiceImpl(JPAQueryFactory jpaQueryFactory, SystemService systemService, InvCkDomainService invCkDomainService) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.systemService = systemService;
        this.invCkDomainService = invCkDomainService;
    }
}

