/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCommon21InVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotSaveVO;
import com.elitesland.yst.production.inv.application.service.InvLotCommonService;
import com.elitesland.yst.production.inv.domain.convert.InvLotConvert;
import com.elitesland.yst.production.inv.dto.invlot.param.InvLotCommon21RpcParam;
import com.elitesland.yst.production.inv.dto.invlot.param.InvLotSaveRpcParam;
import com.elitesland.yst.production.inv.dto.invlot.resp.InvLotRpcDTO;
import com.elitesland.yst.production.inv.provider.InvLotProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/invLot"})
public class InvLotProviderImpl
implements InvLotProvider {
    private final InvLotCommonService invLotCommonService;

    public ApiResult createInvLotInfo(List<InvLotSaveRpcParam> source) {
        List<InvLotSaveVO> invLotSaveVOS = InvLotConvert.INSTANCE.paramToVoList(source);
        return this.invLotCommonService.createInvLotInfo(invLotSaveVOS);
    }

    public Map<Integer, List<InvLotRpcDTO>> getInvLotVOList(List<InvLotCommon21RpcParam> inList) {
        List<InvLotCommon21InVO> inVOList = InvLotConvert.INSTANCE.queryParamToVoList(inList);
        Map<Integer, List<InvLotRespVO>> invLotVOList = this.invLotCommonService.getInvLotVOList(inVOList);
        HashMap<Integer, List<InvLotRpcDTO>> result = new HashMap<Integer, List<InvLotRpcDTO>>();
        for (Integer key : invLotVOList.keySet()) {
            List<InvLotRespVO> invLotRespVOS = invLotVOList.get(key);
            List<InvLotRpcDTO> invLotRpcDTOS = InvLotConvert.INSTANCE.voToRpcList(invLotRespVOS);
            result.put(key, invLotRpcDTOS);
        }
        return result;
    }

    public InvLotProviderImpl(InvLotCommonService invLotCommonService) {
        this.invLotCommonService = invLotCommonService;
    }
}

