/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkRespDVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotAllRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCombineParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvStkDParam;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.PurDubbleService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvLotService;
import com.elitesland.yst.production.inv.domain.convert.InvLotConvert;
import com.elitesland.yst.production.inv.domain.entity.lot.InvLot;
import com.elitesland.yst.production.inv.domain.entity.lot.InvLotDO;
import com.elitesland.yst.production.inv.domain.service.InvLotDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvLotDTO;
import com.elitesland.yst.production.inv.infr.dto.InvLotStkDTO;
import com.elitesland.yst.production.inv.infr.repo.lot.InvLotRepo;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="invLotService")
public class InvLotServiceImpl
implements InvLotService {
    private final InvLotDomainService invLotDomainService;
    private final InvLotRepo invLotRepo;
    private final InvWhDomainService invWhDomainService;
    private final InvWhAreaDomainService invWhAreaDomainService;
    private final SystemService systemService;
    private final ItmOutService itmOutService;
    private final OrgOutService outouService;
    private final PurDubbleService purDubbleService;

    @Override
    @SysCodeProc
    public PagingVO<InvLotRespVO> search(InvLotParam param) {
        PagingVO<InvLotDTO> pagingVo = this.invLotDomainService.invLotSearch(param);
        if (CollectionUtils.isEmpty((Collection)pagingVo.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List vos = pagingVo.getRecords();
        List invLotRespVOList = vos.stream().map(InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return PagingVO.builder().total(pagingVo.getTotal()).records(invLotRespVOList).build();
    }

    @Override
    public List<String> findLotNoByManuLot(String manuLot) {
        List<String> lotNos = this.invLotRepo.findByMenuLotNo(manuLot);
        return lotNos;
    }

    @Override
    @SysCodeProc
    public ApiResult<InvLotRespVO> findLotById(Long id) {
        Optional<InvLotRespVO> invLotDTOOptional = this.findIdOne(id);
        if (invLotDTOOptional.isEmpty()) {
            return ApiResult.fail((String)"\u6279\u6b21\u4fe1\u606f\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return ApiResult.ok((Object)invLotDTOOptional.get());
    }

    @Override
    @SysCodeProc
    public Optional<InvLotRespVO> findIdOne(Long id) {
        Optional<InvLotDTO> invLotDTOOptional = this.invLotDomainService.findById(id);
        if (invLotDTOOptional.isEmpty()) {
            return Optional.empty();
        }
        InvLotDTO invLotDTO = invLotDTOOptional.get();
        InvLotRespVO invLotRespVO = InvLotConvert.INSTANCE.dtoToRespVo(invLotDTO);
        this.fillUpNameList(List.of(invLotRespVO));
        return Optional.of(invLotRespVO);
    }

    @Override
    @SysCodeProc
    public List<InvLotRespVO> findIdBatch(List<Long> idList) {
        List<InvLotDTO> invLotDTOList = this.invLotDomainService.findIdBatch(idList);
        List<InvLotRespVO> invLotRespVOList = invLotDTOList.stream().map(InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return invLotRespVOList;
    }

    @Override
    @SysCodeProc
    public List<InvLotRespVO> findByAndItemIdAndLotNo(List<String> itmIdNo) {
        ArrayList<InvLotDTO> invLotDTOS = new ArrayList<InvLotDTO>();
        for (String itmid : itmIdNo) {
            List<InvLotDTO> invLotDTOList;
            String[] split = itmid.split("_");
            if (split.length == 0) {
                throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u9519\u8bef,\u5546\u54c1\u4e0d\u5b58\u5728");
            }
            if (split.length != 2 || (invLotDTOList = this.invLotDomainService.findAllByItemIdAndLotNo(Long.valueOf(split[0]), split[1])) == null || invLotDTOList.size() != 1) continue;
            invLotDTOS.add(invLotDTOList.get(0));
        }
        return invLotDTOS.stream().map(InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public List<InvLotRespVO> findListByAndItemIdAndLotNo(List<String> itmIdNo) {
        ArrayList<InvLotDTO> invLotDTOS = new ArrayList<InvLotDTO>();
        if (CollectionUtils.isEmpty(itmIdNo)) {
            return Lists.newArrayList();
        }
        for (String itmid : itmIdNo) {
            String[] split = itmid.split("_");
            if (split.length != 2) {
                throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u9519\u8bef");
            }
            List<InvLotDTO> invLotDTOList = this.invLotDomainService.findAllByItemIdAndLotNo(Long.valueOf(split[0]), split[1]);
            if (CollectionUtils.isEmpty(invLotDTOList)) continue;
            invLotDTOS.add(invLotDTOList.get(0));
        }
        return invLotDTOS.stream().map(InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public List<InvLotRespVO> findByAndItemIdAndLotNo2(List<String> itmIdNo) {
        ArrayList<InvLotDTO> invLotDTOS = new ArrayList<InvLotDTO>();
        for (String itmid : itmIdNo) {
            String[] split = itmid.split("_");
            List<InvLotDTO> invLotDTOList = this.invLotDomainService.findAllByItemIdAndLotNo(Long.valueOf(split[0]), split[1]);
            if (invLotDTOList == null || invLotDTOList.size() != 1) continue;
            invLotDTOS.add(invLotDTOList.get(0));
        }
        return invLotDTOS.stream().map(InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public List<InvLotRespVO> findByAndItemIdAndLotNoList(List<String> itmIdNo) {
        ArrayList<InvLotRespVO> invLotRespVOList = new ArrayList<InvLotRespVO>();
        for (String itmid : itmIdNo) {
            List<InvLotDTO> invLotDTOList;
            String[] split = itmid.split("_");
            InvLotParam param = new InvLotParam();
            if (split.length != 3) continue;
            if (!"null".equals(split[0])) {
                param.setItemId(Long.valueOf(split[0]));
            }
            if (!"null".equals(split[1])) {
                param.setVariId(Long.valueOf(split[1]));
            }
            if (!"null".equals(split[2])) {
                param.setLotNo(split[2]);
            }
            if ((invLotDTOList = this.invLotDomainService.findAllByItemIdAndLotNoAndVariId(param)) == null || invLotDTOList.size() <= 0) continue;
            InvLotRespVO invLotRespVO = InvLotConvert.INSTANCE.dtoToRespVo(invLotDTOList.get(0));
            invLotRespVOList.add(invLotRespVO);
        }
        return invLotRespVOList;
    }

    @Override
    @Transactional
    public Long createOne(InvLotSaveVO invLotSaveVO) {
        InvLot invLot = InvLotConvert.INSTANCE.saveVoToEn(invLotSaveVO);
        return this.invLotDomainService.createOne(invLot);
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<InvLotSaveVO> list) {
        List<InvLot> invLots = list.stream().map(InvLotConvert.INSTANCE::saveVoToEn).collect(Collectors.toList());
        return this.invLotDomainService.createBatch(invLots);
    }

    @Override
    @Transactional
    public void update(InvLotSaveVO saveVO) {
        Optional<InvLotDTO> optional = this.invLotDomainService.findById(saveVO.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + saveVO.getId());
        }
        InvLot invLot = InvLotConvert.INSTANCE.saveVoToEn(saveVO);
        this.invLotDomainService.createOne(invLot);
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        Optional<InvLotDTO> optional = this.invLotDomainService.findById(id);
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        this.invLotDomainService.updateDeleteFlagById(1, id);
    }

    @Override
    public List<InvLotRespVO> findByQueryParam(List<String> queryParam) {
        List<InvLotDO> invLotDTOS = this.invLotDomainService.findByQueryParam(queryParam);
        return invLotDTOS.stream().map(InvLotConvert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void deleteOne(Long id) {
        Optional<InvLotDTO> optional = this.invLotDomainService.findById(id);
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        this.invLotDomainService.deleteById(id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.invLotDomainService.deleteById((Long)id));
    }

    @Override
    public Optional<InvLotAllRespVO> findInvLotAllOne(Long id) {
        Optional<InvLotRespVO> invLotDTOOptional = this.findIdOne(id);
        if (invLotDTOOptional.isEmpty()) {
            return Optional.empty();
        }
        InvLotRespVO invLotRespVO = invLotDTOOptional.get();
        this.fillUpNameList(List.of(invLotRespVO));
        InvLotAllRespVO invLotAllRespVO = InvLotConvert.INSTANCE.voToAllVo(invLotRespVO);
        return Optional.of(invLotAllRespVO);
    }

    @Override
    @SysCodeProc
    public PagingVO<InvLotRespVO> findCombine(InvLotCombineParam param) {
        PagingVO<InvLotDTO> pagingVo = this.invLotDomainService.findCombine(param);
        if (CollectionUtils.isEmpty((Collection)pagingVo.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List<InvLotRespVO> records = pagingVo.getRecords().stream().map(InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        this.fillUpNameList(records);
        return PagingVO.builder().total(pagingVo.getTotal()).records(records).build();
    }

    @Override
    public List<InvLotRespVO> findByParams(InvLotParam queryParam) {
        List<InvLotDTO> invLotDTOList = this.invLotDomainService.findByParam(queryParam);
        List<InvLotRespVO> invLotRespVOList = invLotDTOList.stream().map(InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return invLotRespVOList;
    }

    @Override
    public void addSinQty(String lotNo, Long itemId, Double sinQty, String sinStatus, String sinNo) {
        this.invLotDomainService.addSinQty(lotNo, itemId, sinQty, sinStatus, sinNo);
    }

    @Override
    @SysCodeProc
    public PagingVO<InvStkRespDVO> searchD(InvStkDParam param) {
        PagingVO<InvLotStkDTO> pagingVO = this.invLotDomainService.useSelectD(param);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List vos = pagingVO.getRecords();
        List invStkDResults = vos.stream().map(InvLotConvert.INSTANCE::lsDtoToRespVo).collect(Collectors.toList());
        List<InvWhRespVO> orgWhResults = this.invWhDomainService.findIdBatch(invStkDResults.stream().map(InvStkRespDVO::getWhId).collect(Collectors.toList()));
        List itemIds = invStkDResults.stream().map(InvStkRespDVO::getItemId).collect(Collectors.toList());
        ItmItemRpcDtoParam itmParam = new ItmItemRpcDtoParam();
        itmParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemDTOS = this.itmOutService.findItemRpcDtoByParam(itmParam);
        List<OrgOuRpcDTO> orgOuResults = this.outouService.findOuByIds(orgWhResults.stream().map(InvWhRespVO::getOuId).filter(Objects::nonNull).collect(Collectors.toList()));
        invStkDResults.stream().forEach(i -> {
            InvWhAreaRespVO orgWhAreaVo;
            orgWhResults.stream().filter(v -> v.getId().equals(i.getWhId())).findAny().ifPresent(m -> {
                i.setWhName(m.getWhName());
                i.setWhCode(m.getWhCode());
            });
            if (!CollectionUtils.isEmpty((Collection)itmItemDTOS)) {
                itmItemDTOS.stream().filter(v -> v.getItemCode().equals(i.getItemCode())).findAny().ifPresent(m -> {
                    i.setItemCode(m.getItemCode());
                    i.setItemName(m.getItemName());
                    i.setBrand(m.getBrand());
                    i.setPackageSpec(m.getPackageSpec());
                    i.setStoreExpireDays(m.getGuaranteeDays());
                    i.setBrandName(m.getBrandName());
                    i.setVolume(m.getVolume() == null ? null : Double.valueOf(m.getVolume().doubleValue()));
                    i.setGrossWeight(m.getGrossWeight() == null ? null : Double.valueOf(m.getGrossWeight().doubleValue()));
                    i.setNetWeight(m.getNetWeight() == null ? null : Double.valueOf(m.getNetWeight().doubleValue()));
                    i.setTVolume(i.getOhQty() == null || m.getVolume() == null ? null : Double.valueOf(i.getOhQty().doubleValue() * m.getVolume().doubleValue()));
                    i.setTGrossWeight(i.getOhQty() == null || m.getGrossWeight() == null ? null : Double.valueOf(i.getOhQty().doubleValue() * m.getGrossWeight().doubleValue()));
                    i.setTNetWeight(i.getOhQty() == null || m.getNetWeight() == null ? null : Double.valueOf(i.getOhQty().doubleValue() * m.getNetWeight().doubleValue()));
                });
            }
            if (!CollectionUtils.isEmpty((Collection)orgOuResults)) {
                orgOuResults.stream().filter(o -> o.getId().equals(i.getOuId())).findAny().ifPresent(m -> {
                    i.setOuCode(m.getOuCode());
                    i.setOuName(m.getOuName());
                });
            }
            if ((orgWhAreaVo = this.invWhAreaDomainService.findByWhIdAndWhArea(i.getWhId(), i.getWhArea())) != null) {
                i.setOuterCode(orgWhAreaVo.getOuterCode());
            }
        });
        invStkDResults.stream().forEach(i -> {
            if (i.getManuDate() == null) {
                i.setManuDate(LocalDateTime.now());
            }
        });
        invStkDResults = invStkDResults.stream().sorted(Comparator.comparing(InvStkRespDVO::getManuDate)).collect(Collectors.toList());
        return PagingVO.builder().total(pagingVO.getTotal()).records(invStkDResults).build();
    }

    public void fillUpNameList(List<InvLotRespVO> vos) {
        List itemIds = vos.stream().map(InvLotRespVO::getItemId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> suppIds = vos.stream().map(InvLotRespVO::getSuppId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> ouIds = vos.stream().map(InvLotRespVO::getOuId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, String> docClsMap = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_DOC_CLS_STKAJ.getModel(), UdcEnum.COM_DOC_CLS_STKAJ.getCode());
        List<OrgOuRpcDTO> orgOuVOS = this.outouService.findOuByIds(ouIds);
        ItmItemRpcDtoParam itmParam = new ItmItemRpcDtoParam();
        itmParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itemPartDTOS = this.itmOutService.findItemRpcDtoByParam(itmParam);
        List<PurSuppBaseRpcDTO> purSuppBaseRpcDTOS = this.purDubbleService.findSuppByIdBatch(suppIds);
        vos.forEach(vo -> {
            Optional<ItmItemRpcDTO> itmItemVO;
            Optional<PurSuppBaseRpcDTO> suppOptional;
            Optional<OrgOuRpcDTO> orgOuVO;
            if (!docClsMap.isEmpty() && docClsMap.containsKey(vo.getSrcDocCls())) {
                vo.setSrcDocClsName((String)docClsMap.get(vo.getSrcDocCls()));
            }
            if (!CollectionUtils.isEmpty((Collection)orgOuVOS) && (orgOuVO = orgOuVOS.stream().filter(v -> v.getId().equals(vo.getOuId())).findFirst()).isPresent()) {
                OrgOuRpcDTO ouVO = orgOuVO.get();
                vo.setOuName(ouVO.getOuName());
                vo.setOuCode(ouVO.getOuCode());
            }
            if (!CollectionUtils.isEmpty((Collection)purSuppBaseRpcDTOS) && (suppOptional = purSuppBaseRpcDTOS.stream().filter(v -> v.getId().equals(vo.getSuppId())).findFirst()).isPresent()) {
                PurSuppBaseRpcDTO suppBaseRpcDTO = suppOptional.get();
                vo.setSuppCode(suppBaseRpcDTO.getSuppCode());
                vo.setSuppName(suppBaseRpcDTO.getSuppName());
            }
            if (!CollectionUtils.isEmpty((Collection)itemPartDTOS) && (itmItemVO = itemPartDTOS.stream().filter(v -> v.getId().equals(vo.getItemId())).findFirst()).isPresent()) {
                ItmItemRpcDTO itemVO = itmItemVO.get();
                vo.setItemCode(itemVO.getItemCode());
                vo.setItemName(itemVO.getItemName());
            }
        });
    }

    public InvLotServiceImpl(InvLotDomainService invLotDomainService, InvLotRepo invLotRepo, InvWhDomainService invWhDomainService, InvWhAreaDomainService invWhAreaDomainService, SystemService systemService, ItmOutService itmOutService, OrgOutService outouService, PurDubbleService purDubbleService) {
        this.invLotDomainService = invLotDomainService;
        this.invLotRepo = invLotRepo;
        this.invWhDomainService = invWhDomainService;
        this.invWhAreaDomainService = invWhAreaDomainService;
        this.systemService = systemService;
        this.itmOutService = itmOutService;
        this.outouService = outouService;
        this.purDubbleService = purDubbleService;
    }
}

