/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvStkCommon37InSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAllQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAndTrnDDownloadRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAndTrnRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvStkCommonService;
import com.elitesland.yst.production.inv.application.service.InvTrnDService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.convert.InvTrnConvert;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvCommonConvert;
import com.elitesland.yst.production.inv.domain.entity.invtrn.InvTrn;
import com.elitesland.yst.production.inv.domain.service.InvTrnDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvTrnDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnAndTrnDTO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnDTO;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitesland.yst.production.inv.utils.InvStk28Enum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvTrnDServiceImpl
implements InvTrnDService {
    private static final Logger log = LoggerFactory.getLogger(InvTrnDServiceImpl.class);
    private final InvTrnDDomainService invTrnDDomainService;
    private final InvTrnDomainService invTrnDomainService;
    private final InvStkCommonService invStkCommonService;
    private final SystemService systemService;
    private final ItmOutService itmOutService;
    private final OrgOutService orgOutService;
    private final InvWhDomainService invWhDomainService;
    private final InvStkOptBizService invStkOptBizService;
    private final InvWhAreaDomainService whAreaDomainService;

    @Override
    public PagingVO<InvTrnAndTrnRespVO> search(InvTrnAllQueryParamVO param) {
        PagingVO<InvTrnAndTrnDTO> pagingVO = this.invTrnDDomainService.search(param);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List trnAndTrnDTOS = pagingVO.getRecords();
        List<InvTrnAndTrnRespVO> trnAndTrnRespVOS = trnAndTrnDTOS.stream().map(d -> {
            InvTrnAndTrnRespVO invTrnAndTrnRespVO = InvTrnConvert.INSTANCE.dtoTorespVO((InvTrnAndTrnDTO)d);
            return invTrnAndTrnRespVO;
        }).collect(Collectors.toList());
        this.fillupNameList(trnAndTrnRespVOS);
        return PagingVO.builder().records(trnAndTrnRespVOS).total(pagingVO.getTotal()).build();
    }

    @Override
    public List<InvTrnAndTrnDDownloadRespVO> findInvTrnAndTrnDDownloadVOList(InvTrnAllQueryParamVO param) {
        param.setSize(20000);
        PagingVO<InvTrnAndTrnRespVO> ret = this.search(param);
        List list = ret.getRecords();
        List<InvTrnAndTrnDDownloadRespVO> invTrnAndTrnDDownloadRespVOList = list.stream().map(i -> {
            String outerNo;
            InvTrnAndTrnDDownloadRespVO downloadVO = new InvTrnAndTrnDDownloadRespVO();
            BeanUtils.copyProperties((Object)i, (Object)downloadVO);
            downloadVO.setOwhName(i.getOWhName());
            downloadVO.setIwhName(i.getIWhName());
            downloadVO.setOdeter2Name(i.getODeter2Name());
            downloadVO.setIdeter2Name(i.getIDeter2Name());
            String outerType = StringUtils.isEmpty((Object)downloadVO.getOuterType()) ? "" : downloadVO.getOuterType();
            String string = outerNo = StringUtils.isEmpty((Object)downloadVO.getOuterNo()) ? "" : downloadVO.getOuterNo();
            if (!StringUtils.isEmpty((Object)outerType) && !StringUtils.isEmpty((Object)outerNo)) {
                downloadVO.setOuterNo(outerType + outerNo);
            }
            return downloadVO;
        }).collect(Collectors.toList());
        return invTrnAndTrnDDownloadRespVOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void confirm(Long masId) {
        InvTrnDTO invTrnDTO = this.invTrnDomainService.findIdOne(masId).get();
        if (Objects.isNull(invTrnDTO)) {
            throw new BusinessException(ApiCode.FAIL, "\u5e93\u5b58\u8f6c\u79fb\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        if (!UdcEnum.INV_TRN_STATUS_APPED.getValueCode().equals(invTrnDTO.getDocStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u8bf7\u9009\u62e9<\u8f6c\u79fb\u5355\u72b6\u6001>\u4e3a\u3010\u5df2\u5ba1\u6279\u3011\u7684\u5355\u636e\uff01");
        }
        InvTrnAllQueryParamVO param = new InvTrnAllQueryParamVO();
        param.setMasId(masId);
        List<InvTrnAndTrnDTO> invTrnAndTrnDVoList = this.invTrnDDomainService.findAll(param);
        InvStkCommonOperateDTO stkCommonOperateDTO = this.getOInvStkCommonOperateDTO(invTrnAndTrnDVoList, "TRN003");
        this.invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
        this.invTrnDomainService.updateDocStatusByIds(List.of(masId), UdcEnum.INV_TRN_STATUS_CF.getValueCode());
    }

    private InvStkCommonOperateDTO getOInvStkCommonOperateDTO(List<InvTrnAndTrnDTO> invTrnDRespVOS, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-", ""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList operateBodyDTOS = new ArrayList();
        ArrayList<InvStkCommonOperateBodyDTO> sourceBodyList = this.getSourceBodyList(invTrnDRespVOS);
        operateDTO.setSourceBodyList(sourceBodyList);
        return operateDTO;
    }

    private InvStkCommonOperateDTO getIInvStkCommonOperateDTO(List<InvTrnAndTrnDTO> invTrnDRespVOS, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-", ""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> sourceBodyList = this.getSourceBodyList(invTrnDRespVOS);
        ArrayList<InvStkCommonOperateBodyDTO> targetBodyList = this.getTargetBodyList(invTrnDRespVOS);
        operateDTO.setSourceBodyList(sourceBodyList);
        operateDTO.setTargetBodyList(targetBodyList);
        return operateDTO;
    }

    private ArrayList<InvStkCommonOperateBodyDTO> getTargetBodyList(List<InvTrnAndTrnDTO> invTrnDRespVOS) {
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<InvStkCommonOperateBodyDTO>();
        invTrnDRespVOS.stream().forEach(invTrnDRespVo -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invTrnDRespVo.getIWhId());
            operateBodyDTO.setItemId(invTrnDRespVo.getItemId());
            operateBodyDTO.setDeter2(invTrnDRespVo.getIDeter2());
            operateBodyDTO.setSrcDocId(invTrnDRespVo.getId());
            operateBodyDTO.setDocNo(invTrnDRespVo.getDocNo());
            operateBodyDTO.setSrcDocDid(invTrnDRespVo.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            operateBodyDTO.setLineNo(invTrnDRespVo.getLineNo());
            operateBodyDTO.setCreateUserId(invTrnDRespVo.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invTrnDRespVo.getUom());
            operateBodyDTO.setQty(invTrnDRespVo.getQty());
            operateBodyDTO.setLotNo(invTrnDRespVo.getLotNo());
            operateBodyDTO.setPCode(invTrnDRespVo.getIPCode());
            operateBodyDTO.setPType(invTrnDRespVo.getIPType());
            operateBodyDTO.setOuId(invTrnDRespVo.getOuId());
            operateBodyDTO.setVariId(invTrnDRespVo.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        return operateBodyDTOS;
    }

    private ArrayList<InvStkCommonOperateBodyDTO> getSourceBodyList(List<InvTrnAndTrnDTO> invTrnDRespVOS) {
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<InvStkCommonOperateBodyDTO>();
        invTrnDRespVOS.stream().forEach(invTrnDRespVo -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invTrnDRespVo.getOWhId());
            operateBodyDTO.setItemId(invTrnDRespVo.getItemId());
            operateBodyDTO.setDeter2(invTrnDRespVo.getODeter2());
            operateBodyDTO.setSrcDocId(invTrnDRespVo.getId());
            operateBodyDTO.setDocNo(invTrnDRespVo.getDocNo());
            operateBodyDTO.setSrcDocDid(invTrnDRespVo.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            operateBodyDTO.setLineNo(invTrnDRespVo.getLineNo());
            operateBodyDTO.setCreateUserId(invTrnDRespVo.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invTrnDRespVo.getUom());
            operateBodyDTO.setQty(invTrnDRespVo.getQty());
            operateBodyDTO.setLotNo(invTrnDRespVo.getLotNo());
            operateBodyDTO.setPCode(invTrnDRespVo.getOPCode());
            operateBodyDTO.setPType(invTrnDRespVo.getOPType());
            operateBodyDTO.setOuId(invTrnDRespVo.getOuId());
            operateBodyDTO.setVariId(invTrnDRespVo.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        return operateBodyDTOS;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void recevieConfirm(Long masId, boolean isAuto) {
        InvTrnDTO invTrnDTO = this.invTrnDomainService.findIdOne(masId).orElse(null);
        if (Objects.isNull(invTrnDTO)) {
            throw new BusinessException(ApiCode.FAIL, "\u5e93\u5b58\u8f6c\u79fb\u5355\u672a\u627e\u5230");
        }
        if (!UdcEnum.INV_TRN_STATUS_CF.getValueCode().equals(invTrnDTO.getDocStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u8bf7\u9009\u62e9<\u8f6c\u79fb\u5355\u72b6\u6001>\u4e3a\u3010\u6536\u8d27\u6570\u91cf\u5f02\u5e38\u3011\u6216\u3010\u5df2\u786e\u8ba4\u3011\u7684\u5355\u636e\uff01");
        }
        InvTrnAllQueryParamVO param = new InvTrnAllQueryParamVO();
        param.setMasId(masId);
        List<InvTrnAndTrnDTO> invTrnAndTrnDVoList = this.invTrnDDomainService.findAll(param);
        InvStkCommonOperateDTO stkCommonOperateDTO = this.getIInvStkCommonOperateDTO(invTrnAndTrnDVoList, "TRN004");
        this.invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
        this.invTrnDomainService.updateDocStatusByIds(List.of(masId), UdcEnum.INV_TRN_STATUS_RE.getValueCode());
    }

    @Override
    @Transactional
    public void check(Long masId) {
        Optional<InvTrnDTO> invTrnDTOOptional = this.invTrnDomainService.findIdOne(masId);
        if (!invTrnDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + masId);
        }
        invTrnDTOOptional.get().setDocStatus(UdcEnum.INV_TRN_STATUS_APPED.getValueCode());
        InvTrn invTrn = InvTrnConvert.INSTANCE.dtoToInvTrn(invTrnDTOOptional.get());
        this.invTrnDomainService.create(invTrn);
    }

    @Override
    @Transactional
    public void refuse(Long masId) {
        Optional<InvTrnDTO> invTrnDTOOptional = this.invTrnDomainService.findIdOne(masId);
        if (!invTrnDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + masId);
        }
        invTrnDTOOptional.get().setDocStatus(UdcEnum.INV_TRN_STATUS_RJ.getValueCode());
        InvTrn invTrn = InvTrnConvert.INSTANCE.dtoToInvTrn(invTrnDTOOptional.get());
        this.invTrnDomainService.create(invTrn);
    }

    public void releasLockQty(Long masId, List<InvTrnAndTrnDTO> invTrnAndTrnDVOList) {
        InvTrnAllQueryParamVO param = new InvTrnAllQueryParamVO();
        param.setMasId(masId);
        if (CollectionUtils.isEmpty(invTrnAndTrnDVOList)) {
            invTrnAndTrnDVOList = this.invTrnDDomainService.findAll(param);
        }
        List<InvStkCommon37InSaveVO> common37InvoList = invTrnAndTrnDVOList.stream().map(v -> {
            InvStkCommon37InSaveVO tmp = InvCommonConvert.INSTANCE.InvTrnAndTrnDRespVOToInvStkCommon37InVO((InvTrnAndTrnDTO)v);
            tmp.setInvStk28Enum1(InvStk28Enum.T_TYPE_25);
            tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            tmp.setOpDate(LocalDateTime.now());
            tmp.setReasonCode(v.getReasonCode());
            return tmp;
        }).collect(Collectors.toList());
        this.invStkCommonService.invStkCommon37(common37InvoList);
    }

    public void releasTranLockQty(Long masId, List<InvTrnAndTrnDTO> invTrnAndTrnDVOList) {
        InvTrnAllQueryParamVO param = new InvTrnAllQueryParamVO();
        param.setMasId(masId);
        if (CollectionUtils.isEmpty(invTrnAndTrnDVOList)) {
            invTrnAndTrnDVOList = this.invTrnDDomainService.findAll(param);
        }
        List<InvStkCommon37InSaveVO> common37InvoList = invTrnAndTrnDVOList.stream().map(v -> {
            v.setTranDeter2(UdcEnum.INV_FUNC_TYPE_9.getValueCode());
            InvStkCommon37InSaveVO tmp = InvCommonConvert.INSTANCE.InvTrnAndTrnDRespVOToInvStkCommon37InTranVO((InvTrnAndTrnDTO)v);
            tmp.setInvStk28Enum1(InvStk28Enum.T_TYPE_25);
            tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            tmp.setOpDate(LocalDateTime.now());
            tmp.setReasonCode(v.getReasonCode());
            return tmp;
        }).collect(Collectors.toList());
        this.invStkCommonService.invStkCommon37(common37InvoList);
    }

    public List<InvTrnAndTrnRespVO> fillupNameList(List<InvTrnAndTrnRespVO> items) {
        Map<String, String> trnStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_TRN_STATUS_DR.getModel(), UdcEnum.INV_TRN_STATUS_DR.getCode());
        Map<String, String> reasonMap = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode());
        List odeter2s = items.stream().filter(i -> i.getODeter2() != null).map(InvTrnAndTrnRespVO::getODeter2).distinct().collect(Collectors.toList());
        List<String> ideter2s = items.stream().filter(i -> i.getIDeter2() != null).map(InvTrnAndTrnRespVO::getIDeter2).distinct().collect(Collectors.toList());
        ideter2s.addAll(odeter2s);
        Map<String, String> uomMap = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        List<Long> ouIdList = items.stream().filter(f -> f.getOuId() != null).map(InvTrnAndTrnRespVO::getOuId).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> orgOuVOS = this.orgOutService.findOuByIds(ouIdList);
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        List itemIds = items.stream().filter(f -> f.getItemId() != null).map(InvTrnAndTrnRespVO::getItemId).distinct().collect(Collectors.toList());
        itmItemPartParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemPartDTOS = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        List<Long> iwhIdList = items.stream().filter(f -> f.getIWhId() != null).map(InvTrnAndTrnRespVO::getIWhId).distinct().collect(Collectors.toList());
        List owhIdList = items.stream().filter(f -> f.getIWhId() != null).map(InvTrnAndTrnRespVO::getOWhId).distinct().collect(Collectors.toList());
        iwhIdList.addAll(owhIdList);
        List<InvWhRespVO> invWhRespVOS = this.invWhDomainService.findIdBatch(iwhIdList);
        List<Long> userIds = items.stream().filter(Objects::nonNull).map(BaseModelVO::getCreateUserId).collect(Collectors.toList());
        List<SysUserVO> empsByIdIn = this.systemService.findAllEmpsByIdIn(userIds);
        InvWhAreaParamVO paramVO = new InvWhAreaParamVO();
        paramVO.setDeter2s(ideter2s);
        paramVO.setWhIds(iwhIdList);
        List<InvWhAreaRespVO> whAreaRespVOS = this.whAreaDomainService.findWhAreasByParam(paramVO);
        items.forEach(i -> {
            if (!CollectionUtils.isEmpty((Collection)itmItemPartDTOS)) {
                itmItemPartDTOS.stream().filter(f -> f.getId().equals(i.getItemId())).findFirst().ifPresent(e -> {
                    i.setItemCode(e.getItemCode());
                    i.setItemName(e.getItemName());
                    i.setBrand(e.getBrand());
                    i.setBrandName(e.getBrandName());
                });
            }
            if (!CollectionUtils.isEmpty((Collection)empsByIdIn)) {
                empsByIdIn.stream().filter(u -> u.getId().equals(i.getCreateUserId())).findFirst().ifPresent(v -> i.setCreateUserName(v.getUsername()));
            }
            if (!CollectionUtils.isEmpty((Collection)invWhRespVOS)) {
                invWhRespVOS.stream().filter(f -> f.getId().equals(i.getIWhId())).findFirst().ifPresent(w -> {
                    i.setIWhCode(w.getWhCode());
                    i.setIWhName(w.getWhName());
                });
                invWhRespVOS.stream().filter(f -> f.getId().equals(i.getOWhId())).findFirst().ifPresent(w -> {
                    i.setOWhCode(w.getWhCode());
                    i.setOWhName(w.getWhName());
                });
            }
            if (!CollectionUtils.isEmpty((Collection)orgOuVOS)) {
                orgOuVOS.stream().filter(f -> f.getId().equals(i.getOuId())).findFirst().ifPresent(o -> {
                    i.setOuName(o.getOuName());
                    i.setOuCode(o.getOuCode());
                });
            }
            if (!CollectionUtils.isEmpty((Map)trnStatusMap) && trnStatusMap.containsKey(i.getDocStatus())) {
                i.setDocStatusName((String)trnStatusMap.get(i.getDocStatus()));
            }
            if (!CollectionUtils.isEmpty((Map)reasonMap) && reasonMap.containsKey(i.getReasonCode())) {
                i.setReasonCodeName((String)reasonMap.get(i.getReasonCode()));
            }
            if (!CollectionUtils.isEmpty((Collection)whAreaRespVOS)) {
                whAreaRespVOS.stream().filter(wharea -> wharea.getDeter2().equals(i.getODeter2()) && wharea.getWhId().equals(i.getOWhId())).findAny().ifPresent(m -> i.setODeter2Name(m.getDeter2Name()));
                whAreaRespVOS.stream().filter(wharea -> wharea.getDeter2().equals(i.getIDeter2()) && wharea.getWhId().equals(i.getIWhId())).findAny().ifPresent(m -> i.setIDeter2Name(m.getDeter2Name()));
            }
            if (!CollectionUtils.isEmpty((Map)uomMap) && uomMap.containsKey(i.getUom())) {
                i.setUomName((String)uomMap.get(i.getUom()));
            }
        });
        return items;
    }

    public InvTrnDServiceImpl(InvTrnDDomainService invTrnDDomainService, InvTrnDomainService invTrnDomainService, InvStkCommonService invStkCommonService, SystemService systemService, ItmOutService itmOutService, OrgOutService orgOutService, InvWhDomainService invWhDomainService, InvStkOptBizService invStkOptBizService, InvWhAreaDomainService whAreaDomainService) {
        this.invTrnDDomainService = invTrnDDomainService;
        this.invTrnDomainService = invTrnDomainService;
        this.invStkCommonService = invStkCommonService;
        this.systemService = systemService;
        this.itmOutService = itmOutService;
        this.orgOutService = orgOutService;
        this.invWhDomainService = invWhDomainService;
        this.invStkOptBizService = invStkOptBizService;
        this.whAreaDomainService = whAreaDomainService;
    }
}

