/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.yst.production.inv.domain.convert.InvAsmConvert;
import com.elitesland.yst.production.inv.domain.entity.InvAsm;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDO;
import com.elitesland.yst.production.inv.domain.service.InvAsmDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvAsmDTO;
import com.elitesland.yst.production.inv.infr.repo.InvAsmRepo;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;

@Service(value="invAsmDomainService")
public class InvAsmDomainServiceImpl
implements InvAsmDomainService {
    private final InvAsmRepo invAsmRepo;

    @Override
    public Optional<InvAsmDTO> findIdOne(Long id) {
        Optional<InvAsmDTO> asmDOOptional = this.invAsmRepo.findById(id).map(invAsmDO -> {
            InvAsmDTO invAsmDTO = InvAsmConvert.INSTANCE.doToDto((InvAsmDO)invAsmDO);
            return invAsmDTO;
        });
        return asmDOOptional;
    }

    @Override
    @org.springframework.transaction.annotation.Transactional(rollbackFor={Exception.class})
    public Long create(InvAsm invAsm) {
        return ((InvAsmDO)this.invAsmRepo.save(InvAsmConvert.INSTANCE.asmToDo(invAsm))).getId();
    }

    @Override
    public List<Long> updateStatusInBatch(List<Long> ids, String status) {
        return null;
    }

    @Override
    public Long submit(Long id) {
        return null;
    }

    @Override
    @Transactional
    public void check(Long masId) {
        Optional invAsmDOOptional = this.invAsmRepo.findById(masId);
        if (invAsmDOOptional.isPresent()) {
            if (((InvAsmDO)invAsmDOOptional.get()).getProcInstId() != null) {
                throw new BusinessException(ApiCode.FAIL, "\u8be5\u5355\u636e\u5df2\u5f00\u542f\u5de5\u4f5c\u6d41\u5ba1\u6279");
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + masId);
        }
        ((InvAsmDO)invAsmDOOptional.get()).setDocStatus(UdcEnum.INV_ASM_STATUS_APPED.getValueCode());
        this.invAsmRepo.save((InvAsmDO)invAsmDOOptional.get());
    }

    public InvAsmDomainServiceImpl(InvAsmRepo invAsmRepo) {
        this.invAsmRepo = invAsmRepo;
    }
}

