/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.yst.production.inv.domain.convert.InvTrnConvert;
import com.elitesland.yst.production.inv.domain.entity.invtrn.InvTrn;
import com.elitesland.yst.production.inv.domain.service.InvTrnDomainService;
import com.elitesland.yst.production.inv.entity.InvTrnDO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnDTO;
import com.elitesland.yst.production.inv.infr.repo.InvTrnRepo;
import com.elitesland.yst.production.inv.infr.repo.InvTrnRepoProc;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InvTrnDomainServiceImpl
implements InvTrnDomainService {
    private static final Logger log = LoggerFactory.getLogger(InvTrnDomainServiceImpl.class);
    private final InvTrnRepo invTrnRepo;
    private final InvTrnRepoProc invTrnRepoProc;

    @Override
    public Optional<InvTrnDTO> findIdOne(Long id) {
        Optional<InvTrnDTO> invTrnDTO = this.invTrnRepo.findById(id).map(invTrnDO -> InvTrnConvert.INSTANCE.doToDTO((InvTrnDO)invTrnDO));
        return invTrnDTO;
    }

    @Override
    @Transactional
    public Long create(InvTrn invTrn) {
        InvTrnDO invTrnDO = InvTrnConvert.INSTANCE.trnToDO(invTrn);
        Long id = ((InvTrnDO)this.invTrnRepo.save(invTrnDO)).getId();
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long submit(Long id) {
        Optional invTrnVOOptional = this.invTrnRepo.findById(id);
        if (!invTrnVOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDocStatusByIds(List<Long> ids, String docStatus) {
        this.invTrnRepoProc.updateDocStatusByIds(ids, docStatus);
    }

    public InvTrnDomainServiceImpl(InvTrnRepo invTrnRepo, InvTrnRepoProc invTrnRepoProc) {
        this.invTrnRepo = invTrnRepo;
        this.invTrnRepoProc = invTrnRepoProc;
    }
}

