/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhPTypeRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.dto.invwh.InvWhDeliveryRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhDeliveryRpcDtoParam;
import com.elitesland.yst.production.inv.dto.invwh.InvWhDetailRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhRepo;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhRepoProc;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="InvWhDomainService")
public class InvWhDomainServiceImpl
implements InvWhDomainService {
    private static final Logger log = LoggerFactory.getLogger(InvWhDomainServiceImpl.class);
    private final InvWhRepo invWhRepo;
    private final InvWhRepoProc invWhRepoProc;

    @Override
    @SysCodeProc
    public Optional<InvWhRespVO> findIdOne(Long id) {
        JPAQuery<InvWhRespVO> jpaQuery = this.invWhRepoProc.select(null);
        QInvWhDO jpaQDo = QInvWhDO.invWhDO;
        jpaQuery.where((Predicate)jpaQDo.id.eq((Object)id));
        InvWhRespVO vo = (InvWhRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> findByCodes(List<String> codes) {
        QInvWhDO jpaQDo = QInvWhDO.invWhDO;
        List whRespVOList = ((JPAQuery)this.invWhRepoProc.select(null).where((Predicate)jpaQDo.whCode.in(codes))).fetch();
        return whRespVOList;
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> findIdBatch(List<Long> ids) {
        List idList = ids.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        QInvWhDO jpaQDo = QInvWhDO.invWhDO;
        List invWhRespVOS = ((JPAQuery)this.invWhRepoProc.select(null).where((Predicate)jpaQDo.id.in(idList))).fetch();
        return invWhRespVOS;
    }

    @Override
    @SysCodeProc
    public Optional<InvWhDO> findById(Long id) {
        return this.invWhRepo.findById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public InvWhDO saveInvWh(InvWhDO invWhDO) {
        return (InvWhDO)this.invWhRepo.save(invWhDO);
    }

    @Override
    @SysCodeProc
    public Optional<InvWhRespVO> findById(long id) {
        JPAQuery<InvWhRespVO> jpaQuery = this.invWhRepoProc.select(null);
        QInvWhDO jpaQDo = QInvWhDO.invWhDO;
        jpaQuery.where((Predicate)jpaQDo.id.eq((Object)id));
        InvWhRespVO vo = (InvWhRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.invWhRepo.deleteById(id));
    }

    @Override
    @SysCodeProc
    public PagingVO<InvWhRespVO> searchWh(InvWhParamVO param) {
        JPAQuery invWhs = (JPAQuery)this.invWhRepoProc.select(null).where(this.invWhRepoProc.searchWhere(param));
        long dataCount = invWhs.fetchCount();
        List lists = invWhs.fetch();
        this.invWhRepoProc.openOrderAndLimit(invWhs, param, QInvWhDO.invWhDO);
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(dataCount);
        return paging;
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> searchWhByParam(InvWhParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.invWhRepoProc.select(null).where(this.invWhRepoProc.searchWhere(param));
        List respVOS = jpaQuery.fetch();
        return respVOS;
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> findByWhIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        List<InvWhRespVO> whRespVOS = this.invWhRepoProc.selectWhByWhIds(ids);
        return whRespVOS;
    }

    @Override
    @SysCodeProc
    public InvWhRespVO findByWhId(Long id) {
        return this.invWhRepoProc.selectWhByWhId(id);
    }

    @Override
    @SysCodeProc
    public List<InvWhRpcDTO> findWhRpcDTOByIdBatch(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        List<InvWhRpcDTO> results = this.invWhRepoProc.findWhRpcDTOByIdBatch(ids);
        return results;
    }

    @Override
    @SysCodeProc
    public List<InvWhDetailRpcDTO> findWhRpcDTOByParam(InvWhRpcDtoParam param) {
        List<InvWhDetailRpcDTO> rpcDTOS = this.invWhRepoProc.findWhRpcDTOByParam(param);
        return rpcDTOS;
    }

    @Override
    @SysCodeProc
    public List<InvWhRpcDTO> findWhPartRpcDTOByParam(InvWhRpcDtoParam param) {
        List<InvWhRpcDTO> results = this.invWhRepoProc.findWhPartRpcDTOByParam(param);
        return results;
    }

    @Override
    @SysCodeProc
    public List<InvWhDeliveryRpcDTO> findWhRpcDTOByDelivery(InvWhDeliveryRpcDtoParam param) {
        List<InvWhDeliveryRpcDTO> whRpcDTOByDelivery = this.invWhRepoProc.findWhRpcDTOByDelivery(param);
        return whRpcDTOByDelivery;
    }

    @Override
    @SysCodeProc
    public List<InvWhDeliveryRpcDTO> findWhRpcDTOByAllArea(InvWhDeliveryRpcDtoParam param) {
        List<InvWhDeliveryRpcDTO> byAllArea = this.invWhRepoProc.findWhRpcDTOByAllArea(param);
        return byAllArea;
    }

    @Override
    @SysCodeProc
    public List<InvWhPTypeRespVO> findWhPTypeList(String pType) {
        List<InvWhPTypeRespVO> whPTypeList = this.invWhRepoProc.findWhPTypeList(pType);
        return whPTypeList;
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> select(InvWhParamVO param) {
        JPAQuery<InvWhRespVO> jpaQuery = this.invWhRepoProc.select(param);
        return jpaQuery.fetch();
    }

    @Override
    public Boolean enableWhhConfig(Long id, String whStatus) {
        try {
            this.invWhRepoProc.enableWhhConfig(id, whStatus);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a" + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    @SysCodeProc
    public Optional<InvWhDO> findWhDOByWhId(Long id) {
        Optional optional = this.invWhRepo.findById(id);
        return optional;
    }

    public InvWhDomainServiceImpl(InvWhRepo invWhRepo, InvWhRepoProc invWhRepoProc) {
        this.invWhRepo = invWhRepo;
        this.invWhRepoProc = invWhRepoProc;
    }
}

