/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.out;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.SysOrgPageQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysOrgPageRespDTO;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitesland.yst.production.inv.application.out.OrgBuOutService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgBuOutServiceImpl
implements OrgBuOutService {
    private static final Logger log = LoggerFactory.getLogger(OrgBuOutServiceImpl.class);
    private final OrgRpcService orgRpcService;

    @Override
    public List<IdCodeNameParam> findSimpleBuByCodes(Set<String> codes) {
        block5: {
            if (CollectionUtil.isEmpty(codes)) {
                return Collections.EMPTY_LIST;
            }
            try {
                ApiResult apiResult = this.orgRpcService.queryIdAndName(codes);
                if (apiResult.isSuccess()) {
                    List apiResultData = (List)apiResult.getData();
                    if (CollectionUtil.isNotEmpty((Collection)apiResultData)) {
                        return apiResultData;
                    }
                    break block5;
                }
                throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u7cfb\u7edf\u57df(findSimpleBuByCodes)\u67e5\u8be2\u7ec4\u7ec7\u5931\u8d25\uff1a" + apiResult.getErrorMsg());
            }
            catch (Exception e) {
                log.error("findSimpleBuByCodes error:", (Throwable)e);
                throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u7cfb\u7edf\u57dfdubbo\u670d\u52a1\u5f02\u5e38\uff1a" + e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String, IdCodeNameParam> findBuMapByCodes(Set<String> codes) {
        List<IdCodeNameParam> buList = this.findSimpleBuByCodes(codes);
        if (CollectionUtil.isEmpty(buList)) {
            return new HashMap<String, IdCodeNameParam>();
        }
        Map<String, IdCodeNameParam> buMap = buList.stream().collect(Collectors.toMap(IdCodeNameParam::getCode, t -> t, (t1, t2) -> t1));
        return buMap;
    }

    @Override
    public PagingVO<SysOrgPageRespDTO> queryBuPageByParam(SysOrgPageQueryDTO pageQueryDTO) {
        try {
            ApiResult apiResult = this.orgRpcService.queryPage(pageQueryDTO);
            if (apiResult.isSuccess()) {
                PagingVO pagingVO = (PagingVO)apiResult.getData();
                return pagingVO;
            }
            throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u7cfb\u7edf\u57df(queryBuPageByParam)\u67e5\u8be2\u7ec4\u7ec7\u5206\u9875\u5931\u8d25\uff1a" + apiResult.getErrorMsg());
        }
        catch (Exception e) {
            log.error("queryBuPageByParam error:", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u7cfb\u7edf\u57dfdubbo\u670d\u52a1\u5f02\u5e38\uff1a" + e);
        }
    }

    public OrgBuOutServiceImpl(OrgRpcService orgRpcService) {
        this.orgRpcService = orgRpcService;
    }
}

