/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkAndCkDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkAndCkDSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkCreateParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkDSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvAjService;
import com.elitesland.yst.production.inv.application.service.InvCkService;
import com.elitesland.yst.production.inv.domain.convert.ck.InvCkConvert;
import com.elitesland.yst.production.inv.domain.convert.ck.InvCkDConvert;
import com.elitesland.yst.production.inv.domain.entity.ck.InvCk;
import com.elitesland.yst.production.inv.domain.entity.ck.InvCkD;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDO;
import com.elitesland.yst.production.inv.domain.service.InvCkDomainService;
import com.elitesland.yst.production.inv.domain.service.InvCkdDomainService;
import com.elitesland.yst.production.inv.domain.service.InvStkDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.enums.ProcDefKey;
import com.elitesland.yst.production.inv.infr.dto.InvStkDTO;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDDTO;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDTO;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvCkServiceImpl
implements InvCkService {
    private static final Logger log = LoggerFactory.getLogger(InvCkServiceImpl.class);
    private final InvStkDomainService invStkDomainService;
    private final ItmOutService itmOutService;
    private final SystemService systemService;
    private final InvWhDomainService invWhDomainService;
    private final InvWhAreaDomainService invWhAreaDomainService;
    private final OrgOutService outouService;
    private final InvAjService invAjService;
    private final Integer ISAJSTATUSED = 1;
    private final InvCkdDomainService invCkdDomainService;
    private final InvCkDomainService invCkDomainService;
    private final WorkflowService workflowService;
    private final TransactionTemplate transactionTemplate;
    private final RedisUtils redisUtils;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrSubmitInvCkAndCkD(InvCkAndCkDSaveVO invCkAndCkDSaveVO, boolean isSubmit) {
        if (invCkAndCkDSaveVO.getId() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u76d8\u70b9\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Optional<InvCkDTO> invCkDOOptional = this.invCkDomainService.findById(invCkAndCkDSaveVO.getId());
        if (!invCkDOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u76d8\u70b9\u5355\u4e0d\u5b58\u5728\uff01");
        }
        InvCkDTO invCkDTO = invCkDOOptional.get();
        if (!UdcEnum.INV_CK_STATUS_DR.getValueCode().equals(invCkDTO.getDocStatus()) && !UdcEnum.INV_CK_STATUS_RJ.getValueCode().equals(invCkDTO.getDocStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u53ea\u6709\u8349\u7a3f\u3001\u5df2\u62d2\u7edd\u72b6\u6001\u7684\u624d\u80fd\u4fdd\u5b58/\u63d0\u4ea4\uff01");
        }
        try {
            GeneralUserDetails user = SecurityContextUtil.currentUser();
            invCkDTO.setSecBuId(invCkAndCkDSaveVO.getSecBuId() == null ? null : invCkAndCkDSaveVO.getSecBuId());
            invCkDTO.setSecOuId(invCkAndCkDSaveVO.getOuId() == null ? null : invCkAndCkDSaveVO.getOuId());
        }
        catch (Exception e) {
            log.error("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\uff0c\u8bf7\u5148\u767b\u5f55\uff1a{}" + e.getMessage());
        }
        invCkDTO.setRemark(invCkAndCkDSaveVO.getRemark());
        invCkDTO.setOuId(invCkAndCkDSaveVO.getOuId());
        invCkDTO.setDocType(invCkAndCkDSaveVO.getDocType());
        this.transactionTemplate.setPropagationBehavior(3);
        Long invCkId = (Long)this.transactionTemplate.execute(transactionStatus -> {
            try {
                InvCk invCk = InvCkConvert.INSTANCE.dtoToEn(invCkDTO);
                invCk.setIsAjStatus(0);
                Long id = this.invCkDomainService.saveInvCk(invCk);
                List<InvCkDSaveVO> invCkDs = invCkAndCkDSaveVO.getInvCkDs();
                List<InvCkDDTO> invCkDDTOList = this.invCkdDomainService.selectByMasId(id);
                if (!CollectionUtils.isEmpty(invCkDDTOList)) {
                    this.invCkdDomainService.deleteByMasId(id);
                }
                if (!CollectionUtils.isEmpty(invCkDs)) {
                    List<InvCkD> invCkDList = invCkDs.stream().map(e -> {
                        InvCkD invCkD = InvCkDConvert.INSTANCE.saveVoToEn((InvCkDSaveVO)e);
                        invCkD.setMasId(id);
                        try {
                            invCkD.setSecBuId(invCkAndCkDSaveVO.getSecBuId() == null ? null : invCkAndCkDSaveVO.getSecBuId());
                            invCkD.setSecOuId(invCkAndCkDSaveVO.getOuId() == null ? null : invCkAndCkDSaveVO.getOuId());
                        }
                        catch (Exception w) {
                            log.error("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\uff0c\u8bf7\u5148\u767b\u5f55\uff1a{}" + w.getMessage());
                        }
                        return invCkD;
                    }).collect(Collectors.toList());
                    this.invCkdDomainService.saveInvCkDList(invCkDList);
                }
                return id;
            }
            catch (Exception e2) {
                log.error("create invCk error", (Throwable)e2);
                throw new BusinessException(ApiCode.FAIL, e2.getMessage());
            }
        });
        SysUserDTO user = null;
        GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails == null || generalUserDetails.getUser() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
        }
        user = generalUserDetails.getUser();
        InvCkDTO invCkDO1 = this.invCkDomainService.findById(invCkId).get();
        if ((invCkDO1.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(invCkDO1.getProcInstStatus())) && isSubmit) {
            String procInstName = "\u5e93\u5b58\u76d8\u70b9-" + invCkDO1.getDocNo();
            WorkflowResult processInfoWorkflowResult = this.workflowService.startProcess(StartProcessPayload.of((String)ProcDefKey.INV_STOCK_CHECK.name(), (String)procInstName, (String)("" + invCkDO1.getId()), null));
            log.info("\u5e93\u5b58\u76d8\u70b9\u542f\u52a8\u6d41\u7a0b\u8fd4\u56de:" + processInfoWorkflowResult);
            if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
                throw new BusinessException("\u8c03\u7528\u5de5\u4f5c\u6d41\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f:" + processInfoWorkflowResult.getMsg());
            }
            if (Objects.nonNull(processInfoWorkflowResult.getData())) {
                this.invCkDomainService.updateProcInst((ProcessInfo)processInfoWorkflowResult.getData(), invCkDO1.getId(), UdcEnum.INV_CK_STATUS_APPING.getValueCode());
            }
        }
        return invCkAndCkDSaveVO.getId();
    }

    @Override
    public PagingVO<InvCkRespVO> list(InvCkParamVO invCkParamVO) {
        List vos;
        if (StringUtils.hasText((String)invCkParamVO.getDeter2KeyWord())) {
            List<InvCkDDTO> ckDDTOList = this.invCkdDomainService.selectByDeter2KeyWords(invCkParamVO.getDeter2KeyWord());
            if (!CollectionUtils.isEmpty(ckDDTOList)) {
                List<Long> masIds = ckDDTOList.stream().map(InvCkDDTO::getMasId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                invCkParamVO.setMasIds(masIds);
            } else {
                List invCkRespVOS = Collections.emptyList();
                long total = 0L;
                return PagingVO.builder().total(total).records(invCkRespVOS).build();
            }
        }
        PagingVO<InvCkRespVO> pagingVo = this.invCkDomainService.invCkSearch(invCkParamVO);
        List invCkRespVOS = vos = pagingVo.getRecords();
        this.searchAssembly(invCkRespVOS);
        long total = pagingVo.getTotal();
        return PagingVO.builder().total(total).records(invCkRespVOS).build();
    }

    private void searchAssembly(List<InvCkRespVO> invCkRespVOList) {
        List<Long> ouIdList = invCkRespVOList.stream().map(InvCkRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList whAreaRespVOS = new ArrayList();
        List<OrgOuRpcDTO> orgOuVOS = this.outouService.findOuByIds(ouIdList);
        List<Long> createUserIds = invCkRespVOList.stream().map(BaseModelVO::getCreateUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SysUserVO> sysUserVOS = this.systemService.findAllEmpsByIdIn(createUserIds);
        Map<String, String> docStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_CK_STATUS_DR.getCode());
        Map<String, String> docTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_CK_TYPE_DAY.getCode());
        Map<String, String> docMethodMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_CK_METHOD_BLD.getModel(), UdcEnum.INV_CK_METHOD_BLD.getCode());
        invCkRespVOList.forEach(invCkRespVO -> {
            if (!CollectionUtils.isEmpty((Map)docStatusMap) && docStatusMap.containsKey(invCkRespVO.getDocStatus())) {
                invCkRespVO.setDocStatusName((String)docStatusMap.get(invCkRespVO.getDocStatus()));
            }
            if (!CollectionUtils.isEmpty((Map)docTypeMap) && docTypeMap.containsKey(invCkRespVO.getDocType())) {
                invCkRespVO.setDocTypeName((String)docTypeMap.get(invCkRespVO.getDocType()));
            }
            if (!CollectionUtils.isEmpty((Map)docMethodMap) && docMethodMap.containsKey(invCkRespVO.getDocMethod())) {
                invCkRespVO.setDocMethodName((String)docMethodMap.get(invCkRespVO.getDocMethod()));
            }
            if (!CollectionUtils.isEmpty((Collection)sysUserVOS)) {
                sysUserVOS.stream().filter(v -> v.getId().equals(invCkRespVO.getCreateUserId())).findAny().ifPresent(o -> invCkRespVO.setCreator(o.getUsername()));
            }
            if (!CollectionUtils.isEmpty((Collection)orgOuVOS)) {
                orgOuVOS.stream().filter(f -> f.getId().equals(invCkRespVO.getOuId())).findFirst().ifPresent(o -> {
                    invCkRespVO.setOuName(o.getOuName());
                    invCkRespVO.setOuCode(o.getOuCode());
                });
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approval(Long id) {
        Optional<InvCkDTO> invCkDTOOptional = this.invCkDomainService.findById(id);
        if (!invCkDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u5ba1\u6279\u5931\u8d25,\u672a\u67e5\u5230\u5bf9\u5e94\u76d8\u70b9\u5355");
        }
        if (!UdcEnum.INV_CK_STATUS_APPING.getValueCode().equals(invCkDTOOptional.get().getDocStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u76d8\u70b9\u5355\u72b6\u6001\u5f02\u5e38");
        }
        this.invCkDomainService.updateDocStatus(id, UdcEnum.INV_CK_STATUS_APPED.getValueCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncToInvAj(Long id) {
        Optional<InvCkDTO> invCkDTOOptional = this.invCkDomainService.findById(id);
        if (!invCkDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u751f\u6210\u5931\u8d25,\u672a\u67e5\u5230\u5bf9\u5e94\u76d8\u70b9\u5355");
        }
        if (!UdcEnum.INV_CK_STATUS_APPED.getValueCode().equals(invCkDTOOptional.get().getDocStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u76d8\u70b9\u5355\u72b6\u6001\u5f02\u5e38");
        }
        this.saveOneInvAj(invCkDTOOptional, id);
        this.invCkDomainService.updateIsAjStatus(id, this.ISAJSTATUSED);
    }

    private void saveOneInvAj(Optional<InvCkDTO> invCkDOOptional, Long id) {
        ArrayList<InvAjDSaveVO> invAjDSaveVOList;
        InvAjSaveVO invAjSaveVO;
        List<InvCkDDTO> invCkDDTOList1;
        InvCkDTO invCkDTO = invCkDOOptional.orElseThrow(new BusinessException("\u5e93\u5b58\u76d8\u70b9\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!"));
        List<InvCkDDTO> invCkDDTOList = this.invCkdDomainService.selectByMasId(id);
        List invCkDDTOS = invCkDDTOList.stream().filter(c -> c.getFactQty() != null && c.getFactQty().subtract(c.getAccQty()).compareTo(BigDecimal.ZERO) != 0).map(e -> {
            e.setDiffQty(e.getFactQty().subtract(e.getAccQty()));
            return e;
        }).collect(Collectors.toList());
        List invCkDDTOS1 = invCkDDTOS.stream().filter(c -> (c.getDiffQty() == null ? BigDecimal.ZERO : c.getDiffQty()).compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        List invCkDDTOS2 = invCkDDTOS.stream().filter(c -> (c.getDiffQty() == null ? BigDecimal.ZERO : c.getDiffQty()).compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(invCkDDTOS1)) {
            Map<String, List<InvCkDDTO>> invCkDMap1 = invCkDDTOS1.stream().collect(Collectors.groupingBy(d -> d.getDeter2()));
            for (Map.Entry<String, List<InvCkDDTO>> i : invCkDMap1.entrySet()) {
                invCkDDTOList1 = i.getValue();
                invAjSaveVO = this.invCkDOToinvAjSaveVO(invCkDTO, i.getKey(), id, true);
                invAjDSaveVOList = new ArrayList<InvAjDSaveVO>();
                for (InvCkDDTO invCkDDTO : invCkDDTOList1) {
                    invAjDSaveVOList.add(this.invCkDRespVOConvertToinvAjDRespVO(invCkDDTO, invCkDTO, true));
                }
                invAjSaveVO.setInvAjDSaveVOList(invAjDSaveVOList);
                this.invAjService.saveOneInvAj(invAjSaveVO);
            }
        }
        if (!CollectionUtils.isEmpty(invCkDDTOS2)) {
            Map<String, List<InvCkDDTO>> invCkDMap2 = invCkDDTOS2.stream().collect(Collectors.groupingBy(d -> d.getDeter2()));
            for (Map.Entry<String, List<InvCkDDTO>> i : invCkDMap2.entrySet()) {
                invCkDDTOList1 = i.getValue();
                invAjSaveVO = this.invCkDOToinvAjSaveVO(invCkDTO, i.getKey(), id, false);
                invAjDSaveVOList = new ArrayList();
                for (InvCkDDTO invCkDDTO : invCkDDTOList1) {
                    invAjDSaveVOList.add(this.invCkDRespVOConvertToinvAjDRespVO(invCkDDTO, invCkDTO, false));
                }
                invAjSaveVO.setInvAjDSaveVOList(invAjDSaveVOList);
                this.invAjService.saveOneInvAj(invAjSaveVO);
            }
        }
    }

    private InvAjSaveVO invCkDOToinvAjSaveVO(InvCkDTO invCkDTO, String deter2, Long masId, Boolean flag) {
        if (invCkDTO == null) {
            throw new BusinessException("\u5e93\u5b58\u76d8\u70b9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        InvAjSaveVO invAjSaveVO = new InvAjSaveVO();
        invAjSaveVO.setCreateTime(LocalDateTime.now());
        invAjSaveVO.setCreateUserId(invCkDTO.getCreateUserId());
        invAjSaveVO.setCreator(invCkDTO.getCreator());
        invAjSaveVO.setSecBuId(invCkDTO.getSecBuId());
        invAjSaveVO.setSecOuId(invCkDTO.getSecOuId());
        invAjSaveVO.setWhId(invCkDTO.getWhId());
        invAjSaveVO.setDeter2(deter2);
        invAjSaveVO.setOuId(invCkDTO.getOuId());
        OrgOuRpcDTO orgOuRpcDTO = this.outouService.findOuById(invCkDTO.getOuId());
        if (orgOuRpcDTO == null) {
            throw new BusinessException(ApiCode.FAIL, "\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!");
        }
        invAjSaveVO.setOuCode(orgOuRpcDTO.getOuCode());
        invAjSaveVO.setApplyEmpId(invCkDTO.getCreateUserId());
        invAjSaveVO.setBuId(null);
        invAjSaveVO.setRelateDocNo(invCkDTO.getDocNo());
        invAjSaveVO.setRelateDocCls(UdcEnum.COM_DOC_CLS_STKCK.getValueCode());
        invAjSaveVO.setRelateDocId(masId);
        invAjSaveVO.setIoDate(LocalDateTime.now());
        invAjSaveVO.setApplyDate(LocalDateTime.now());
        invAjSaveVO.setDocStatus(UdcEnum.INV_AJ_STATUS_DR.getValueCode());
        invAjSaveVO.setCreateUserId(invCkDTO.getCreateUserId());
        invAjSaveVO.setSecOuId(invCkDTO.getSecOuId());
        invAjSaveVO.setSecBuId(invCkDTO.getSecBuId());
        invAjSaveVO.setSecUserId(invCkDTO.getSecUserId());
        if (flag.booleanValue()) {
            invAjSaveVO.setDocType(UdcEnum.INV_AJ_TYPE_STKIN.getValueCode());
            invAjSaveVO.setReasonCode(UdcEnum.COM_REASON_CODE_107.getValueCode());
        } else {
            invAjSaveVO.setDocType(UdcEnum.INV_AJ_TYPE_STKOUT.getValueCode());
            invAjSaveVO.setReasonCode(UdcEnum.COM_REASON_CODE_108.getValueCode());
        }
        return invAjSaveVO;
    }

    private InvAjDSaveVO invCkDRespVOConvertToinvAjDRespVO(InvCkDDTO invCkDDTO, InvCkDTO invCkDTO, Boolean flag) {
        if (invCkDDTO == null) {
            return null;
        }
        InvAjDSaveVO invAjDSaveVO = new InvAjDSaveVO();
        invAjDSaveVO.setItemCode(invCkDDTO.getItemCode());
        invAjDSaveVO.setItemId(invCkDDTO.getItemId());
        invAjDSaveVO.setQty((invCkDDTO.getDiffQty() == null ? BigDecimal.ZERO : invCkDDTO.getDiffQty()).abs());
        invAjDSaveVO.setUom(invCkDDTO.getUom());
        invAjDSaveVO.setWhId(invCkDTO.getWhId());
        invAjDSaveVO.setDeter2(invCkDDTO.getDeter2());
        invAjDSaveVO.setRelateDocCls(UdcEnum.COM_DOC_CLS_STKCK.getValueCode());
        invAjDSaveVO.setRelateDocDid(invCkDDTO.getId());
        invAjDSaveVO.setRelateDocId(invCkDTO.getId());
        invAjDSaveVO.setRelateDocNo(invCkDTO.getDocNo());
        invAjDSaveVO.setLotNo(invCkDDTO.getLotNo());
        invAjDSaveVO.setToLotNo(invCkDDTO.getLotNo());
        invAjDSaveVO.setPCode(invCkDDTO.getPCode());
        invAjDSaveVO.setPType(invCkDDTO.getPType());
        if (flag.booleanValue()) {
            invAjDSaveVO.setReasonCode(UdcEnum.COM_REASON_CODE_107.getValueCode());
        } else {
            invAjDSaveVO.setToLotNo(null);
            invAjDSaveVO.setReasonCode(UdcEnum.COM_REASON_CODE_108.getValueCode());
        }
        return invAjDSaveVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reject(Long id) {
        Optional<InvCkDTO> invCkDTOOptional = this.invCkDomainService.findById(id);
        if (!invCkDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u5ba1\u6279\u5931\u8d25,\u672a\u67e5\u5230\u5bf9\u5e94\u76d8\u70b9\u5355");
        }
        this.invCkDomainService.updateDocStatus(id, UdcEnum.INV_CK_STATUS_RJ.getValueCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(InvCkCreateParamVO invCkCreateParamVO) {
        List<Long> whIdList = invCkCreateParamVO.getWhIdList();
        List<String> deter2List = invCkCreateParamVO.getDeter2List();
        if (CollectionUtils.isEmpty(whIdList)) {
            throw new BusinessException(ApiCode.FAIL, "\u4ed3\u5e93id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Map<Long, Long> whIdMap = this.createInvCk(whIdList, invCkCreateParamVO);
        Map<Long, List<InvStkDTO>> invCkMap = this.getInvCkMap(whIdMap, invCkCreateParamVO);
        if (CollectionUtils.isEmpty(invCkMap)) {
            throw new BusinessException(ApiCode.FAIL, "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5e93\u5b58\uff01\u8bf7\u68c0\u67e5");
        }
        for (Map.Entry<Long, List<InvStkDTO>> m : invCkMap.entrySet()) {
            List<InvStkDTO> invStkDTOS = m.getValue();
            for (InvStkDTO invStkDTO : invStkDTOS) {
                InvCkD invCkD = new InvCkD();
                invCkD.setMasId(m.getKey());
                invCkD.setItemId(invStkDTO.getItemId());
                invCkD.setLotNo(invStkDTO.getLotNo());
                invCkD.setDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
                invCkD.setDeter2(invStkDTO.getDeter2());
                invCkD.setAccQty(invStkDTO.getOhQty());
                invCkD.setUom(invStkDTO.getUom());
                invCkD.setWhId(invStkDTO.getWhId());
                invCkD.setPCode(invStkDTO.getPCode());
                invCkD.setPType(invStkDTO.getPType());
                try {
                    invCkD.setSecBuId(invStkDTO.getSecBuId() == null ? null : invStkDTO.getSecBuId());
                    invCkD.setSecOuId(invStkDTO.getOuId() == null ? null : invStkDTO.getOuId());
                }
                catch (Exception e) {
                    log.error("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\uff0c\u8bf7\u5148\u767b\u5f55\uff1a{}" + e.getMessage());
                }
                this.invCkdDomainService.saveInvCkD(invCkD);
            }
        }
    }

    @Override
    public InvCkAndCkDRespVO findInvCkAndCkDInfo(Long id) {
        Optional<InvWhDO> invWhRespVOOptional;
        OrgOuRpcDTO orgOuVO;
        Optional<InvCkDTO> invCkDTOOptional = this.invCkDomainService.findById(id);
        if (!invCkDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u76d8\u70b9\u5355\u4e0d\u5b58\u5728");
        }
        InvCkDTO invCkDTO = invCkDTOOptional.get();
        InvCkAndCkDRespVO invCkAndCkDRespVO = InvCkConvert.INSTANCE.dtoToInvCkAndCkDRespVO(invCkDTO);
        String docMethod = invCkDTO.getDocMethod();
        invCkAndCkDRespVO.setDocStatusName(this.getUdcDesc(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_CK_STATUS_DR.getCode(), invCkAndCkDRespVO.getDocStatus()));
        invCkAndCkDRespVO.setDocTypeName(this.getUdcDesc(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_CK_TYPE_DAY.getCode(), invCkAndCkDRespVO.getDocType()));
        invCkAndCkDRespVO.setDocMethodName(this.getUdcDesc(UdcEnum.INV_CK_METHOD_BLD.getModel(), UdcEnum.INV_CK_METHOD_BLD.getCode(), docMethod));
        if (invCkDTO.getOuId() != null && (orgOuVO = this.outouService.findOuById(invCkDTO.getOuId())) != null) {
            invCkAndCkDRespVO.setOuName(orgOuVO.getOuName());
        }
        if ((invWhRespVOOptional = this.invWhDomainService.findById(invCkAndCkDRespVO.getWhId())).isPresent()) {
            InvWhDO invWhRespVO = invWhRespVOOptional.get();
            invCkAndCkDRespVO.setWhCode(invWhRespVO.getWhCode());
            invCkAndCkDRespVO.setWhName(invWhRespVO.getWhName());
        }
        List<InvCkDDTO> invCkDDTOList = this.invCkdDomainService.selectByMasId(id);
        this.fillInvCkDRespVOS(invCkDDTOList);
        if (!CollectionUtils.isEmpty(invCkDDTOList)) {
            List<InvCkDRespVO> invCkDRespVOList = invCkDDTOList.stream().map(InvCkDConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
            invCkAndCkDRespVO.setInvCkDs(invCkDRespVOList);
            List diffInvCkDs = invCkDDTOList.stream().filter(f -> f.getFactQty() != null && f.getFactQty().subtract(f.getAccQty()).compareTo(BigDecimal.ZERO) != 0).map(e -> {
                e.setDiffQty(e.getFactQty().subtract(e.getAccQty()));
                return e;
            }).collect(Collectors.toList());
            List<InvCkDRespVO> diffInvCkdRespVOS = diffInvCkDs.stream().map(InvCkDConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
            invCkAndCkDRespVO.setDiffInvCkDs(diffInvCkdRespVOS);
        }
        return invCkAndCkDRespVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelInvCk(Long id) {
        Optional<InvCkDTO> invCkDTOOptional = this.invCkDomainService.findById(id);
        if (!invCkDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u53d6\u6d88\u5931\u8d25\uff01\u672a\u67e5\u5230\u5bf9\u5e94\u76d8\u70b9\u5355");
        }
        this.invCkDomainService.updateDocStatus(id, UdcEnum.INV_CK_STATUS_CL.getValueCode());
    }

    private Map<Long, List<InvStkDTO>> getInvCkMap(Map<Long, Long> whIdMap, InvCkCreateParamVO invCkCreateParamVO) {
        HashMap resultMap = Maps.newHashMap();
        List<Long> itemIdList = invCkCreateParamVO.getItemIdList();
        for (Map.Entry<Long, Long> m : whIdMap.entrySet()) {
            InvStkQueryParamVO invStkQueryParamVO = new InvStkQueryParamVO();
            invStkQueryParamVO.setOuId(invCkCreateParamVO.getOuId());
            invStkQueryParamVO.setWhId(m.getKey());
            invStkQueryParamVO.setDeter2List(invCkCreateParamVO.getDeter2List());
            invStkQueryParamVO.setItemIdList(itemIdList);
            List<InvStkDTO> invStkDTOS = this.invStkDomainService.findInvStkRespVOs(invStkQueryParamVO);
            if (CollectionUtils.isEmpty(invStkDTOS)) continue;
            resultMap.put(m.getValue(), invStkDTOS);
        }
        return resultMap;
    }

    private Map<Long, Long> createInvCk(List<Long> whIdList, InvCkCreateParamVO invCkCreateParamVO) {
        HashMap whIdMap = Maps.newHashMap();
        for (Long whId : whIdList) {
            InvCk invCk = new InvCk();
            invCk.setDocStatus(UdcEnum.INV_CK_STATUS_DR.getValueCode());
            invCk.setOuId(invCkCreateParamVO.getOuId());
            String docNo = this.systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_CK.getCode(), Arrays.asList(invCkCreateParamVO.getOuCode()));
            invCk.setDocNo(docNo);
            invCk.setDocType(invCkCreateParamVO.getDocType());
            if (CollectionUtils.isEmpty(invCkCreateParamVO.getItemIdList())) {
                invCk.setDocMode(UdcEnum.INV_CK_MODE_ALL.getValueCode());
            } else {
                invCk.setDocMode(UdcEnum.INV_CK_MODE_ITEM.getValueCode());
            }
            invCk.setDocMethod(invCkCreateParamVO.getDocMethod());
            invCk.setRemark(invCkCreateParamVO.getRemark());
            invCk.setWhId(whId);
            try {
                invCk.setSecBuId(invCkCreateParamVO.getSecBuId() == null ? null : invCkCreateParamVO.getSecBuId());
                invCk.setSecOuId(invCkCreateParamVO.getOuId() == null ? null : invCkCreateParamVO.getOuId());
            }
            catch (Exception e) {
                log.error("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\uff0c\u8bf7\u5148\u767b\u5f55\uff1a{}" + e.getMessage());
            }
            invCk.setIsAjStatus(0);
            Long invCkId = this.invCkDomainService.saveInvCk(invCk);
            whIdMap.put(whId, invCkId);
        }
        return whIdMap;
    }

    private String getUdcDesc(String domain, String udcCode, String udcVal) {
        if (StringUtils.isEmpty((Object)udcVal) || StringUtils.isEmpty((Object)domain) || StringUtils.isEmpty((Object)udcCode)) {
            return null;
        }
        Map<String, String> codeMap = this.systemService.sysUdcGetCodeMap(domain, udcCode);
        if (CollectionUtils.isEmpty(codeMap)) {
            return null;
        }
        if (codeMap.containsKey(udcVal)) {
            return codeMap.get(udcVal);
        }
        return null;
    }

    private void fillInvCkDRespVOS(List<InvCkDDTO> invCkDDTOList) {
        if (CollectionUtils.isEmpty(invCkDDTOList)) {
            return;
        }
        Map<String, String> udcUom = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        Map<String, String> pTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_EMP.getModel(), UdcEnum.INV_PARTNER_TYPE_EMP.getCode());
        List<String> deter2s = invCkDDTOList.stream().map(InvCkDDTO::getDeter2).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> whIds = invCkDDTOList.stream().map(InvCkDDTO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Object> whAreasList = new ArrayList();
        if (!CollectionUtils.isEmpty(deter2s) && !CollectionUtils.isEmpty(whIds)) {
            InvWhAreaParamVO invWhAreaParamVO = new InvWhAreaParamVO();
            invWhAreaParamVO.setWhIds(whIds);
            invWhAreaParamVO.setDeter2s(deter2s);
            whAreasList = this.invWhAreaDomainService.findWhAreasByParam(invWhAreaParamVO);
        }
        List itemIds = invCkDDTOList.stream().filter(f -> f.getItemId() != null).map(InvCkDDTO::getItemId).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemPartDTOS = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        List<Object> finalWhAreasList = whAreasList;
        invCkDDTOList.stream().map(e -> {
            if (!CollectionUtils.isEmpty((Collection)finalWhAreasList)) {
                finalWhAreasList.stream().filter(d -> d.getDeter2().equals(e.getDeter2()) && d.getWhId().equals(e.getWhId())).findAny().ifPresent(m -> e.setDeter2Name(m.getDeter2Name()));
            }
            if (!CollectionUtils.isEmpty((Map)udcUom) && udcUom.containsKey(e.getUom())) {
                e.setUomName((String)udcUom.get(e.getUom()));
            }
            if (!StringUtils.isEmpty((Object)e.getPType()) && !StringUtils.isEmpty((Object)e.getPCode())) {
                InvParentParamVO orgQueryParamVO = new InvParentParamVO();
                orgQueryParamVO.setType(e.getPType());
                orgQueryParamVO.setCode(e.getPCode());
                List<OrgRespVO> vos = this.outouService.findcodeAndName(orgQueryParamVO);
                if (!CollectionUtils.isEmpty(vos)) {
                    vos.stream().filter(m -> m.getCode().equals(e.getPCode())).findFirst().ifPresent(n -> e.setPName(n.getName()));
                }
                if (MapUtils.isNotEmpty((Map)pTypeMap)) {
                    e.setPTypeName((String)pTypeMap.get(e.getPType()));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)itmItemPartDTOS)) {
                itmItemPartDTOS.stream().filter(f -> f.getId().equals(e.getItemId())).findFirst().ifPresent(item -> {
                    e.setItemCode(item.getItemCode());
                    e.setItemName(item.getItemName());
                    e.setBrand(item.getBrand());
                    e.setBrandName(item.getBrandName());
                    e.setLotFlag(item.getLotFlag());
                    e.setSpec(item.getSpec());
                });
            }
            return e;
        }).collect(Collectors.toList());
    }

    public InvCkServiceImpl(InvStkDomainService invStkDomainService, ItmOutService itmOutService, SystemService systemService, InvWhDomainService invWhDomainService, InvWhAreaDomainService invWhAreaDomainService, OrgOutService outouService, InvAjService invAjService, InvCkdDomainService invCkdDomainService, InvCkDomainService invCkDomainService, WorkflowService workflowService, TransactionTemplate transactionTemplate, RedisUtils redisUtils) {
        this.invStkDomainService = invStkDomainService;
        this.itmOutService = itmOutService;
        this.systemService = systemService;
        this.invWhDomainService = invWhDomainService;
        this.invWhAreaDomainService = invWhAreaDomainService;
        this.outouService = outouService;
        this.invAjService = invAjService;
        this.invCkdDomainService = invCkdDomainService;
        this.invCkDomainService = invCkDomainService;
        this.workflowService = workflowService;
        this.transactionTemplate = transactionTemplate;
        this.redisUtils = redisUtils;
    }
}

