/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitesland.yst.production.inv.application.facade.vo.InvStkCommon28InSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvStkCommon37InSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkGroupRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvIoService;
import com.elitesland.yst.production.inv.application.service.InvStkCommonService;
import com.elitesland.yst.production.inv.application.service.InvStkService;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvCommonConvert;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvStkConvert;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvIoDO;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkDO;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.utils.InvStk28Enum;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.redisson.RedissonRedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="invStkCommonService")
public class InvStkCommonServiceImpl
implements InvStkCommonService {
    private static final Logger log = LoggerFactory.getLogger(InvStkCommonServiceImpl.class);
    private final ItmOutService itmOutService;
    private final InvWhDomainService invWhService;
    private final InvStkService invStkService;
    private final OrgOutService outouService;
    private final RedLockUtils redLockUtils;
    private final SystemService systemService;
    private final InvIoService invIoService;

    @Override
    public InvStkRespVO getInvStk(InvBaseModel queryParam) {
        InvStkRespVO invStk = this.invStkService.getInvStk(queryParam);
        return invStk;
    }

    @Override
    public InvStkRespVO getInvGroupStk(InvBaseModel queryParam) {
        InvStkGroupRespVO results = this.invStkService.getInvStkGroupByParam(queryParam);
        if (results != null) {
            InvStkRespVO respVO = InvStkConvert.INSTANCE.stkGroupRespVOToStkRespVO(results);
            return respVO;
        }
        return null;
    }

    @Override
    @Transactional
    public void invStkCommon28(List<InvStkCommon28InSaveVO> common28InVOList) {
        log.info("\u5171\u901a\u65b9\u6cd528\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", common28InVOList.stream().map(InvStkCommon28InSaveVO::toString).collect(Collectors.toList())));
        this.doProcess(common28InVOList, false);
    }

    @Override
    public void invStkCommon37(List<InvStkCommon37InSaveVO> common37InVOList) {
        log.info("\u5171\u901a\u65b9\u6cd537\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", common37InVOList.stream().map(InvStkCommon37InSaveVO::toString).collect(Collectors.toList())));
        List<InvStkCommon28InSaveVO> common28InVOList = common37InVOList.stream().map(i -> InvCommonConvert.INSTANCE.InvStkCommon37InVOToInvStkCommon28InVO((InvStkCommon37InSaveVO)i)).collect(Collectors.toList());
        this.doProcess(common28InVOList, true);
    }

    public void doProcess(List<InvStkCommon28InSaveVO> common28InVOList, boolean invStkThrowExcFlag) {
        common28InVOList.forEach(inVO -> {
            if (StringUtils.isEmpty((Object)inVO.getSrcDocCls()) || StringUtils.isEmpty((Object)inVO.getDocNo()) || StringUtils.isEmpty((Object)inVO.getSrcDocId()) || StringUtils.isEmpty((Object)inVO.getSrcDocDid())) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u6765\u6e90\u5355\u636e\u7c7b\u522b\u3001\u6765\u6e90\u5355\u636e\u7f16\u53f7\u3001\u6765\u6e90\u5355\u636eID\u3001\u6765\u6e90\u5355\u636e\u660e\u7ec6ID \u5747\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)inVO.getUom())) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        common28InVOList = common28InVOList.stream().filter(inVO -> inVO.getQty() != null && inVO.getQty().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        List<ItmItemRpcDTO> itmItemVOS = this.getItmItemVOList(common28InVOList);
        List<InvWhRespVO> orgWhVOList = this.invWhService.findIdBatch(common28InVOList.stream().map(InvBaseModel::getWhId).distinct().collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(orgWhVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!");
        }
        List<InvLotRespVO> invLotVOList = Collections.synchronizedList(new ArrayList());
        List invLotStringList = common28InVOList.stream().filter(i -> !StringUtils.isEmpty((Object)i.getLotNo())).map(i -> i.getItemId() == null ? "" : i.getItemId() + "_" + (Serializable)(i.getVariId() == null ? "" : i.getVariId()) + "_" + i.getLotNo()).distinct().collect(Collectors.toList());
        this.saveInvStkInfo(common28InVOList, itmItemVOS, orgWhVOList, invStkThrowExcFlag, invLotVOList);
    }

    private List<ItmItemRpcDTO> getItmItemVOList(List<InvStkCommon28InSaveVO> common28InVOList) {
        List itemIdList = common28InVOList.stream().map(InvBaseModel::getItemId).distinct().collect(Collectors.toList());
        log.info("\u5546\u54c1ID\u96c6\u5408\u662f\uff1a{}", itemIdList);
        if (CollectionUtils.isEmpty(itemIdList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIdList);
        List<ItmItemRpcDTO> itmItemDTOS = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        if (CollectionUtils.isEmpty(itmItemDTOS)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u5931\u8d25,\u5546\u54c1\u4e0d\u5b58\u5728!");
        }
        return itmItemDTOS;
    }

    private void saveInvStkInfo(List<InvStkCommon28InSaveVO> common28InVOList, List<ItmItemRpcDTO> itmItemVOS, List<InvWhRespVO> orgWhVOList, boolean invStkThrowExcFlag, List<InvLotRespVO> invLotVOList) {
        log.info("saveInvStkInfo \u5f00\u59cb:common28InVOList:{},itmItemVOS:{},orgWhVOList:{},ioBatchId:{},invStkThrowExcFlag:{}", new Object[]{common28InVOList, itmItemVOS, orgWhVOList, invStkThrowExcFlag});
        List invStkCreateList = Collections.synchronizedList(new ArrayList());
        common28InVOList.stream().forEach(common28InSaveVO -> {
            InvStkRespVO invStkRespVO = this.queryInvStkAsync((InvStkCommon28InSaveVO)common28InSaveVO);
            if (invStkThrowExcFlag && invStkRespVO == null) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u4e0d\u5b58\u5728");
            }
            if (invStkRespVO == null) {
                invStkCreateList.add(common28InSaveVO);
            }
        });
        if (!CollectionUtils.isEmpty(invStkCreateList)) {
            invStkCreateList.stream().forEach(common28InSaveVO -> {
                InvLotRespVO lotRespVO = new InvLotRespVO();
                if (!CollectionUtils.isEmpty((Collection)invLotVOList)) {
                    lotRespVO = invLotVOList.stream().filter(lot -> (lot.getItemId() + "_" + lot.getLotNo() + "_" + lot.getVariId()).equals(common28InSaveVO.getItemId() + "_" + common28InSaveVO.getLotNo() + "_" + common28InSaveVO.getVariId())).findFirst().get();
                }
                String lockName = common28InSaveVO.getWhId() + "-" + common28InSaveVO.getDeter2() + "-" + common28InSaveVO.getItemId() + "-" + common28InSaveVO.getLotNo() + "-" + common28InSaveVO.getPType() + common28InSaveVO.getPCode();
                ItmItemRpcDTO itmItemVO = itmItemVOS.stream().filter(i -> i.getId().equals(common28InSaveVO.getItemId())).findAny().get();
                InvWhRespVO invWhRespVO = orgWhVOList.stream().filter(i -> i.getId().equals(common28InSaveVO.getWhId())).findAny().get();
                RedissonRedLock rLock = this.redLockUtils.getRedLock(lockName);
                try {
                    if (!rLock.tryLock(-1L, 60L, TimeUnit.SECONDS)) {
                        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e93\u5b58\u5e76\u53d1\u8fc7\u5927,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
                    }
                    InvStkRespVO invStkRespVO = this.queryInvStkAsync((InvStkCommon28InSaveVO)common28InSaveVO);
                    if (invStkRespVO == null) {
                        this.createInvStkASync((InvStkCommon28InSaveVO)common28InSaveVO, itmItemVO, invWhRespVO, lotRespVO);
                    }
                    if (!this.redLockUtils.isHeldByThread(lockName, Long.valueOf(Thread.currentThread().getId()))) {
                        log.error("Lock expired after long pause");
                        throw new BusinessException("\u4f1a\u8bdd\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91");
                    }
                }
                catch (InterruptedException e) {
                    log.error("\u5171\u901a\u65b9\u6cd528/37\uff0c\u5e93\u5b58\u64cd\u4f5c\u83b7\u53d6\u4e8b\u52a1\u9501\u5931\u8d25\uff1a" + e.toString());
                    throw new BusinessException("\u5e93\u5b58\u64cd\u4f5c\u83b7\u53d6\u4e8b\u52a1\u9501\u5931\u8d25\uff1a" + e.toString());
                }
                finally {
                    if (this.redLockUtils.isHeldByThread(lockName, Long.valueOf(Thread.currentThread().getId()))) {
                        log.info("\u91ca\u653e\u9501{}\u6210\u529f", (Object)lockName);
                        rLock.unlock();
                        log.info("\u6d4b\u8bd5\u5e76\u53d1-\u91ca\u653e\u9501\u540d\u79f0\u4e3a{}\uff0c\u7ebf\u7a0b\u540d\u79f0\uff1a{}", (Object)lockName, (Object)Thread.currentThread().getName());
                    }
                }
            });
        }
        this.invStkOps(common28InVOList, itmItemVOS, orgWhVOList, invStkThrowExcFlag);
    }

    private InvStkRespVO queryInvStkAsync(InvStkCommon28InSaveVO common28InVO) {
        CompletableFuture<InvStkRespVO> invStkFuture = CompletableFuture.supplyAsync(() -> this.getInvStk(common28InVO));
        try {
            return invStkFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("\u67e5\u8be2\u5e93\u5b58\u6570\u636e\u5931\u8d25:" + common28InVO.toString());
            throw new BusinessException("\u67e5\u8be2\u5e93\u5b58\u6570\u636e\u5931\u8d25");
        }
    }

    private void createInvStkASync(InvStkCommon28InSaveVO common28InVO, ItmItemRpcDTO itmItemVO, InvWhRespVO invWhRespVO, InvLotRespVO invLotRespVO) {
        CompletableFuture<Void> createFuture = CompletableFuture.runAsync(() -> {
            InvStkDO invStkDO = new InvStkDO();
            invStkDO.setItemId(itmItemVO.getId());
            invStkDO.setItemCode(itmItemVO.getItemCode());
            invStkDO.setUom(itmItemVO.getUom());
            invStkDO.setDeleteFlag(0);
            invStkDO.setDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
            invStkDO.setItemName(itmItemVO.getItemName());
            invStkDO.setItemCateCode(itmItemVO.getItemCateCode());
            invStkDO.setBrand(itmItemVO.getBrand());
            invStkDO.setWhId(invWhRespVO.getId());
            invStkDO.setOuId(invWhRespVO.getOuId());
            invStkDO.setSecBuId(invWhRespVO.getSecBuId());
            invStkDO.setSecOuId(invWhRespVO.getSecOuId());
            invStkDO.setVariId(common28InVO.getVariId());
            invStkDO.setDeter1(common28InVO.getDeter1());
            invStkDO.setDeter2(common28InVO.getDeter2());
            invStkDO.setDeter3(common28InVO.getDeter3());
            invStkDO.setLotNo(common28InVO.getLotNo());
            invStkDO.setInDate(common28InVO.getOpDate());
            invStkDO.setPCode(common28InVO.getPCode());
            invStkDO.setPType(common28InVO.getPType());
            invStkDO.setOhQty(BigDecimal.ZERO);
            invStkDO.setOhQty2(BigDecimal.ZERO);
            invStkDO.setRsvQty(BigDecimal.ZERO);
            invStkDO.setRsvQty2(BigDecimal.ZERO);
            invStkDO.setRsvQty3(BigDecimal.ZERO);
            invStkDO.setRsvQty4(BigDecimal.ZERO);
            invStkDO.setLockQty(BigDecimal.ZERO);
            invStkDO.setLockQty2(BigDecimal.ZERO);
            invStkDO.setLockQty3(BigDecimal.ZERO);
            invStkDO.setLockQty4(BigDecimal.ZERO);
            invStkDO.setOwQty(BigDecimal.ZERO);
            invStkDO.setOwQty2(BigDecimal.ZERO);
            invStkDO.setOwQty3(BigDecimal.ZERO);
            invStkDO.setOwQty4(BigDecimal.ZERO);
            invStkDO.setAvalQty(BigDecimal.ZERO);
            invStkDO.setAvalQty2(BigDecimal.ZERO);
            invStkDO.setDeleteFlag(0);
            invStkDO.setSrcDocCls(common28InVO.getSrcDocCls());
            invStkDO.setSrcDocId(common28InVO.getSrcDocId());
            invStkDO.setSrcDocDid(common28InVO.getSrcDocDid());
            invStkDO.setCreateUserId(common28InVO.getCreateUserId());
            invStkDO.setUntilExpireDays(invLotRespVO.getUntilExpireDays());
            invStkDO.setFressType(invLotRespVO.getFressType());
            if (itmItemVO.getVolume() != null) {
                invStkDO.setVolume(itmItemVO.getVolume());
            }
            if (itmItemVO.getNetWeight() != null) {
                invStkDO.setNetWeight(itmItemVO.getNetWeight());
            }
            if (itmItemVO.getGrossWeight() != null) {
                invStkDO.setGrossWeight(itmItemVO.getGrossWeight());
            }
            this.invStkService.createOne(invStkDO);
        });
        try {
            createFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void invStkOps(List<InvStkCommon28InSaveVO> common28InVOS, List<ItmItemRpcDTO> itmItemVOS, List<InvWhRespVO> orgWhVOList, boolean invStkThrowExcFlag) {
        Long ioBatchId = LocalDateTime.now().toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
        common28InVOS.stream().forEach(common28InSaveVO -> {
            InvStkRespVO invStk = this.queryInvStkAsync((InvStkCommon28InSaveVO)common28InSaveVO);
            if (invStkThrowExcFlag) {
                BigDecimal avalQty;
                BigDecimal qty;
                if (invStk == null) {
                    throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u4e0d\u5b58\u5728");
                }
                if (common28InSaveVO.getInvStk28Enum1() != null) {
                    switch (common28InSaveVO.getInvStk28Enum1()) {
                        case T_TYPE_07_01: 
                        case T_TYPE_20: 
                        case T_TYPE_21: 
                        case T_TYPE_22: 
                        case T_TYPE_23: {
                            qty = common28InSaveVO.getQty() == null ? BigDecimal.ZERO : common28InSaveVO.getQty().abs();
                            BigDecimal bigDecimal = avalQty = invStk.getAvalQty() == null ? BigDecimal.ZERO : invStk.getAvalQty();
                            if (avalQty.subtract(qty).compareTo(BigDecimal.ZERO) >= 0) break;
                            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u53ef\u7528\u91cf\u4e0d\u8db3");
                        }
                    }
                }
                if (common28InSaveVO.getInvStk28Enum2() != null) {
                    switch (common28InSaveVO.getInvStk28Enum2()) {
                        case T_TYPE_07_01: 
                        case T_TYPE_20: 
                        case T_TYPE_21: 
                        case T_TYPE_22: 
                        case T_TYPE_23: {
                            qty = common28InSaveVO.getQty() == null ? BigDecimal.ZERO : common28InSaveVO.getQty().abs();
                            BigDecimal bigDecimal = avalQty = invStk.getAvalQty() == null ? BigDecimal.ZERO : invStk.getAvalQty();
                            if (avalQty.subtract(qty).compareTo(BigDecimal.ZERO) >= 0) break;
                            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u53ef\u7528\u91cf\u4e0d\u8db3");
                        }
                    }
                }
            }
            ItmItemRpcDTO itmItemVO = itmItemVOS.stream().filter(i -> i.getId().equals(common28InSaveVO.getItemId())).findAny().get();
            InvWhRespVO invWhRespVO = orgWhVOList.stream().filter(i -> i.getId().equals(common28InSaveVO.getWhId())).findAny().get();
            this.saveOrUpdate((InvStkCommon28InSaveVO)common28InSaveVO, invStk, itmItemVO, invWhRespVO, ioBatchId);
        });
    }

    private void saveOrUpdate(InvStkCommon28InSaveVO common28InVO, InvStkRespVO invStk, ItmItemRpcDTO itmItemVO, InvWhRespVO invWhRespVO, Long ioBatchId) {
        OrgOuRpcDTO orgOuVO = this.outouService.findOuById(invWhRespVO.getOuId());
        if (orgOuVO == null) {
            throw new BusinessException(ApiCode.FAIL, "\u516c\u53f8\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        InvStkDO invStkDO = new InvStkDO();
        invStkDO.setOhQty(BigDecimal.ZERO);
        invStkDO.setOhQty2(BigDecimal.ZERO);
        invStkDO.setRsvQty(BigDecimal.ZERO);
        invStkDO.setRsvQty2(BigDecimal.ZERO);
        invStkDO.setRsvQty3(BigDecimal.ZERO);
        invStkDO.setRsvQty4(BigDecimal.ZERO);
        invStkDO.setLockQty(BigDecimal.ZERO);
        invStkDO.setLockQty2(BigDecimal.ZERO);
        invStkDO.setLockQty3(BigDecimal.ZERO);
        invStkDO.setLockQty4(BigDecimal.ZERO);
        invStkDO.setOwQty(BigDecimal.ZERO);
        invStkDO.setOwQty2(BigDecimal.ZERO);
        invStkDO.setOwQty3(BigDecimal.ZERO);
        invStkDO.setOwQty4(BigDecimal.ZERO);
        invStkDO.setAvalQty(BigDecimal.ZERO);
        invStkDO.setAvalQty2(BigDecimal.ZERO);
        invStkDO.setId(invStk.getId());
        this.setInvStkDOQty(common28InVO.getInvStk28Enum1(), common28InVO.getQty(), invStkDO);
        this.setInvStkDOQty(common28InVO.getInvStk28Enum2(), common28InVO.getQty(), invStkDO);
        int result = this.invStkService.updateStkQty(invStkDO);
        if (result != 1) {
            log.error("\u5171\u901a\u65b9\u6cd528/37\uff0c\u5e93\u5b58\u64cd\u4f5c\u5931\u8d25(\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3)\u3002\u5355\u636e\u4fe1\u606f\uff1a" + common28InVO.toString());
            throw new BusinessException("\u5e93\u5b58\u64cd\u4f5c\u5931\u8d25(\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3)");
        }
        this.saveInvIoLog(common28InVO, common28InVO.getInvStk28Enum1(), itmItemVO, orgOuVO, ioBatchId, 1.0, invWhRespVO);
        this.saveInvIoLog(common28InVO, common28InVO.getInvStk28Enum2(), itmItemVO, orgOuVO, ioBatchId, 2.0, invWhRespVO);
    }

    private void setInvStkDOQty(InvStk28Enum invStk28Enum, BigDecimal qty, InvStkDO invStkDO) {
        if (invStk28Enum == null) {
            return;
        }
        qty = qty == null ? BigDecimal.ZERO : qty.abs();
        switch (invStk28Enum) {
            case O_TYPE_01_01: 
            case O_TYPE_03: 
            case O_TYPE_05: 
            case O_TYPE_14: 
            case O_TYPE_17: 
            case O_TYPE_19: {
                invStkDO.setOhQty(this.setQty(invStkDO.getOhQty()).subtract(qty));
                break;
            }
            case I_TYPE_02: 
            case I_TYPE_19: 
            case I_TYPE_04: 
            case I_TYPE_06: 
            case I_TYPE_15: 
            case I_TYPE_16: 
            case I_TYPE_18: {
                invStkDO.setOhQty(this.setQty(invStkDO.getOhQty()).add(qty));
                break;
            }
            case T_TYPE_07_02: {
                invStkDO.setRsvQty(this.setQty(invStkDO.getRsvQty()).subtract(qty));
                break;
            }
            case T_TYPE_07_01: {
                invStkDO.setRsvQty(this.setQty(invStkDO.getRsvQty()).add(qty));
                break;
            }
            case T_TYPE_20: 
            case T_TYPE_21: 
            case T_TYPE_22: 
            case T_TYPE_23: {
                invStkDO.setLockQty(this.setQty(invStkDO.getLockQty()).add(qty));
                break;
            }
            case T_TYPE_24: 
            case T_TYPE_25: 
            case T_TYPE_26: 
            case T_TYPE_27: {
                invStkDO.setLockQty(this.setQty(invStkDO.getLockQty()).subtract(qty));
            }
        }
    }

    private BigDecimal setQty(BigDecimal qty) {
        return qty == null ? BigDecimal.ZERO : qty;
    }

    private void saveInvIoLog(InvStkCommon28InSaveVO common28InVO, InvStk28Enum invStk28Enum, ItmItemRpcDTO itmItemVO, OrgOuRpcDTO ou, Long ioBatchId, Double lineNo, InvWhRespVO invWhRespVO) {
        log.info("\u5171\u901a\u65b9\u6cd529\uff0c\u65f6\u95f4\uff1a" + LocalDateTime.now() + "\uff0c\u5165\u53c2\uff1aInvStkCommon28InSaveVO:" + (common28InVO == null ? null : common28InVO.toString()) + "InvStk28Enum:" + (invStk28Enum == null ? null : invStk28Enum.getIoCode()) + "ItmItemVO:" + (itmItemVO == null ? null : itmItemVO.toString()) + "OrgOuVO2:" + (ou == null ? null : ou.toString()) + "IoBatchId:" + ioBatchId + "LineNo:" + lineNo);
        if (invStk28Enum == null) {
            return;
        }
        ArrayList<InvIoDO> ioDOList = new ArrayList<InvIoDO>();
        InvIoDO invIoDO1 = InvCommonConvert.INSTANCE.invStkCommon28InVOToInvIoDO(common28InVO);
        invIoDO1.setIoBatchId(ioBatchId);
        invIoDO1.setLineNo(lineNo);
        invIoDO1.setDeleteFlag(0);
        invIoDO1.setIoCode(invStk28Enum.getIoCode());
        invIoDO1.setQty(this.setInvIoQty(invStk28Enum, common28InVO.getQty()));
        invIoDO1.setIoDate(common28InVO.getOpDate());
        invIoDO1.setCreateUserId(common28InVO.getCreateUserId());
        ArrayList<String> runtimeValues = new ArrayList<String>();
        String generateCode = this.systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_MR.getCode(), runtimeValues);
        invIoDO1.setDocNo(generateCode);
        invIoDO1.setUom(itmItemVO.getUom());
        invIoDO1.setOuId(ou.getId());
        invIoDO1.setBuId(ou.getBuId());
        invIoDO1.setItemCode(itmItemVO.getItemCode());
        invIoDO1.setBrand(itmItemVO.getBrand());
        invIoDO1.setHomeCurr(ou.getOuCurr());
        invIoDO1.setIoStatus(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode());
        invIoDO1.setSrcDocNo(common28InVO.getDocNo());
        invIoDO1.setPType(common28InVO.getPType());
        invIoDO1.setPCode(common28InVO.getPCode());
        invIoDO1.setSecBuId(invWhRespVO.getSecBuId());
        invIoDO1.setSecOuId(invWhRespVO.getSecOuId());
        invIoDO1.setCreateTime(LocalDateTime.now());
        ioDOList.add(invIoDO1);
        this.invIoService.createBatch(ioDOList);
        log.info("\u5e10\u5361\u5199\u5165\u6210\u529f\uff0c\u53c2\u6570\u4e3a\uff1a{}", ioDOList);
    }

    private BigDecimal setInvIoQty(InvStk28Enum invStk28Enum, BigDecimal qty) {
        qty = qty == null ? BigDecimal.ZERO : qty.abs();
        switch (invStk28Enum) {
            case O_TYPE_01_01: 
            case O_TYPE_03: 
            case O_TYPE_05: 
            case O_TYPE_14: 
            case O_TYPE_17: 
            case O_TYPE_19: 
            case T_TYPE_07_02: 
            case T_TYPE_24: 
            case T_TYPE_25: 
            case T_TYPE_26: 
            case T_TYPE_27: {
                qty = BigDecimal.ZERO.subtract(qty);
            }
        }
        return qty;
    }

    public InvStkCommonServiceImpl(ItmOutService itmOutService, InvWhDomainService invWhService, InvStkService invStkService, OrgOutService outouService, RedLockUtils redLockUtils, SystemService systemService, InvIoService invIoService) {
        this.itmOutService = itmOutService;
        this.invWhService = invWhService;
        this.invStkService = invStkService;
        this.outouService = outouService;
        this.redLockUtils = redLockUtils;
        this.systemService = systemService;
        this.invIoService = invIoService;
    }
}

