/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvTrnDService;
import com.elitesland.yst.production.inv.application.service.InvTrnProcessService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.service.InvTrnDomainService;
import com.elitesland.yst.production.inv.entity.InvTrnDDO;
import com.elitesland.yst.production.inv.entity.InvTrnDO;
import com.elitesland.yst.production.inv.entity.QInvTrnDO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnDTO;
import com.elitesland.yst.production.inv.infr.repo.InvTrnDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvTrnRepo;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvTrnProcessServiceImpl
implements InvTrnProcessService {
    private final InvTrnDService invTrnDService;
    private final InvTrnRepo invTrnRepo;
    private final InvTrnDRepo invTrnDRepo;
    private final InvStkOptBizService invStkOptBizService;
    private final SystemService systemService;
    private final JPAQueryFactory jpaQueryFactory;
    private final InvTrnDomainService invTrnService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        Optional invTrnVOOptional = this.invTrnRepo.findById(id);
        if (invTrnVOOptional.isEmpty()) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QInvTrnDO qInvTrnDO = QInvTrnDO.invTrnDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qInvTrnDO).set(qInvTrnDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{qInvTrnDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: 
            case INTERRUPT: {
                jpaUpdateClause.set((Path)qInvTrnDO.docStatus, (Object)UdcEnum.INV_TRN_STATUS_DR.getValueCode());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)qInvTrnDO.docStatus, (Object)UdcEnum.INV_TRN_STATUS_RJ.getValueCode());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)qInvTrnDO.docStatus, (Object)UdcEnum.INV_TRN_STATUS_CL.getValueCode());
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)qInvTrnDO.docStatus, (Object)UdcEnum.INV_TRN_STATUS_APPING.getValueCode());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)qInvTrnDO.docStatus, (Object)UdcEnum.INV_TRN_STATUS_APPED.getValueCode()).set(qInvTrnDO.approvedTime, (Object)LocalDateTime.now());
                break;
            }
        }
        jpaUpdateClause.execute();
        if (ProcInstStatus.APPROVED.equals((Object)procInstStatus)) {
            List<InvTrnDDO> invTrnDDOS = this.invTrnDRepo.findByMasId(id);
            InvStkCommonOperateDTO invStkCommonOperateDTO = this.getInvStkCommonOperateDTO(invTrnDDOS, (InvTrnDO)invTrnVOOptional.get(), "TRN001");
            this.invStkOptBizService.invStkCommonOperate(invStkCommonOperateDTO);
        }
    }

    @Override
    public ArrayList<String> taskAssignee(Long id, String customParams) {
        List<Long> userIds = this.systemService.findUserIdsByFlowRoles(id, customParams);
        ArrayList<String> userStrIds = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds.stream().forEach(i -> {
                String userStrId = String.valueOf(i);
                userStrIds.add(userStrId);
            });
            return userStrIds;
        }
        return null;
    }

    @Override
    public Long getTrnOuId(String businessKey, String customParams) {
        Optional<InvTrnDTO> invTrnDTO = this.invTrnService.findIdOne(Long.valueOf(businessKey));
        Long ouId = null;
        if (invTrnDTO.isPresent()) {
            InvTrnDTO invTrnRespVO = invTrnDTO.get();
            ouId = invTrnRespVO.getOuId();
        }
        return ouId;
    }

    private InvStkCommonOperateDTO getInvStkCommonOperateDTO(List<InvTrnDDO> invTrnDRespVOS, InvTrnDO invTrnDO, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-", ""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<InvStkCommonOperateBodyDTO>();
        invTrnDRespVOS.stream().forEach(invTrnDRespVo -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invTrnDRespVo.getOWhId());
            operateBodyDTO.setItemId(invTrnDRespVo.getItemId());
            operateBodyDTO.setDeter2(invTrnDRespVo.getODeter2());
            operateBodyDTO.setSrcDocId(invTrnDO.getId());
            operateBodyDTO.setDocNo(invTrnDO.getDocNo());
            operateBodyDTO.setSrcDocDid(invTrnDRespVo.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            operateBodyDTO.setLineNo(invTrnDRespVo.getLineNo());
            operateBodyDTO.setCreateUserId(invTrnDO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invTrnDRespVo.getUom());
            operateBodyDTO.setQty(invTrnDRespVo.getQty());
            operateBodyDTO.setLotNo(invTrnDRespVo.getLotNo());
            operateBodyDTO.setPCode(invTrnDRespVo.getOPCode());
            operateBodyDTO.setPType(invTrnDRespVo.getOPType());
            operateBodyDTO.setOuId(invTrnDRespVo.getOuId());
            operateBodyDTO.setVariId(invTrnDRespVo.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        operateDTO.setSourceBodyList(operateBodyDTOS);
        return operateDTO;
    }

    public InvTrnProcessServiceImpl(InvTrnDService invTrnDService, InvTrnRepo invTrnRepo, InvTrnDRepo invTrnDRepo, InvStkOptBizService invStkOptBizService, SystemService systemService, JPAQueryFactory jpaQueryFactory, InvTrnDomainService invTrnService) {
        this.invTrnDService = invTrnDService;
        this.invTrnRepo = invTrnRepo;
        this.invTrnDRepo = invTrnDRepo;
        this.invStkOptBizService = invStkOptBizService;
        this.systemService = systemService;
        this.jpaQueryFactory = jpaQueryFactory;
        this.invTrnService = invTrnService;
    }
}

