/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhSaveVO;
import com.elitesland.yst.production.inv.application.out.OrgBuOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.service.InvDespatchConfigService;
import com.elitesland.yst.production.inv.application.service.InvWhTreeService;
import com.elitesland.yst.production.inv.domain.convert.invwh.InvWhConvert;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDO;
import com.elitesland.yst.production.inv.domain.service.InvDespatchConfigDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.dto.invDes.resp.InvDespatchRpcDTO;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhAreaRepoProc;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhRepo;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhRepoProc;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitesland.yst.production.inv.utils.InvStringUtil;
import com.elitesland.yst.production.inv.utils.TreeUtils;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="InvWhTreeService")
public class InvWhTreeServiceImpl
implements InvWhTreeService {
    private final InvDespatchConfigService invDespatchConfigService;
    private final InvDespatchConfigDomainService invDespatchConfigDomainService;
    private final InvWhRepoProc invWhRepoProc;
    private final InvWhRepo invWhRepo;
    private final InvWhDomainService invWhDomainService;
    private final InvWhAreaRepoProc invWhAreaRepoProc;
    private final OrgOutService orgOutService;
    private final OrgBuOutService orgBuOutService;

    @Override
    public List<InvWhRespVO> searchTree() {
        InvWhAreaParamVO invWhAreaParamVO = new InvWhAreaParamVO();
        List whRespVOS = this.invWhRepoProc.searchTree().fetch();
        for (InvWhRespVO invWhRespVO : whRespVOS) {
            List<String> codeStrList = InvStringUtil.transitionStrToCodes(invWhRespVO.getDesCode());
            invWhRespVO.setDesCodeList(codeStrList);
        }
        List<String> desCodeAllList = whRespVOS.stream().flatMap(vo -> vo.getDesCodeList().stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<InvDespatchRpcDTO> orgBuRpcAllDTOS = this.invDespatchConfigDomainService.findByDesCodeBatch(desCodeAllList);
        HashMap ouMap = CollectionUtil.isEmpty(orgBuRpcAllDTOS) ? new HashMap() : orgBuRpcAllDTOS.stream().collect(Collectors.toMap(InvDespatchRpcDTO::getDesCode, t -> t, (t1, t2) -> t1));
        whRespVOS.forEach(vo -> {
            List<String> desCodeList = vo.getDesCodeList();
            ArrayList<String> desCodeNameList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(desCodeList)) {
                for (String desCode : desCodeList) {
                    InvDespatchRpcDTO orgBuRpcDTO = (InvDespatchRpcDTO)ouMap.get(desCode);
                    if (!Objects.nonNull(orgBuRpcDTO)) continue;
                    desCodeNameList.add(orgBuRpcDTO.getDesName());
                }
            }
            String desCodeName = desCodeNameList.stream().map(String::valueOf).collect(Collectors.joining("\u3001"));
            vo.setDesCodeName(desCodeName);
        });
        List<InvWhRespVO> invWhRespVOList = this.desConvertInvWh(whRespVOS);
        invWhAreaParamVO.setWhIds(whRespVOS.stream().map(BaseModelVO::getId).collect(Collectors.toList()));
        List fetch = this.invWhAreaRepoProc.select(invWhAreaParamVO).fetch();
        List<InvWhRespVO> invWhRespVOS = this.invWhareaConvertInvWh(whRespVOS, fetch);
        invWhRespVOS.addAll(whRespVOS);
        invWhRespVOS.addAll(invWhRespVOList);
        return TreeUtils.buildTree(null, true, invWhRespVOS);
    }

    @Override
    public Long createTreeOne(InvWhSaveVO invWhSaveVO) {
        if (invWhSaveVO.getId() == null) {
            if (this.invWhRepo.existsByWhCode(invWhSaveVO.getWhCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4ed3\u5e93\u7f16\u7801\u5df2\u5b58\u5728");
            }
            if (this.invWhRepo.existsByWhCodeAndPid(invWhSaveVO.getWhCode(), invWhSaveVO.getPid())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4ed3\u5e93\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        invWhSaveVO.setWhStatus(invWhSaveVO.getWhStatus() == null ? UdcEnum.OU_STATUS_ACTIVE.getValueCode() : invWhSaveVO.getWhStatus());
        if (!CollectionUtils.isEmpty(invWhSaveVO.getDesCodeList())) {
            String codeString = InvStringUtil.transitionCodesToStr(invWhSaveVO.getDesCodeList());
            invWhSaveVO.setDesCode(codeString);
        }
        InvWhDO invWhDO = InvWhConvert.INSTANCE.respVOToDO(invWhSaveVO);
        boolean isRoot = false;
        if (invWhSaveVO.getPid() == null || invWhSaveVO.getPid() == 0L) {
            invWhDO.setPid(0L);
            invWhDO.setLevel(2);
            isRoot = true;
        }
        InvWhDO result = (InvWhDO)this.invWhRepo.save(invWhDO);
        if (isRoot) {
            result.setCodePath(result.getWhCode());
        } else {
            Optional pCodeOptional = this.invWhRepo.findById(invWhSaveVO.getPid());
            if (pCodeOptional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u4e0a\u7ea7\u54c1\u7c7b");
            }
            InvWhDO pCode = (InvWhDO)pCodeOptional.get();
            result.setCodePath(pCode.getCodePath() + "/" + result.getWhCode());
            result.setLevel(pCode.getLevel() + 1);
        }
        Long id = ((InvWhDO)this.invWhRepo.save(result)).getId();
        return id;
    }

    @Override
    public Optional<InvWhRespVO> findTreeOne(Long id) {
        if (id == null) {
            return Optional.empty();
        }
        InvWhRespVO invWhRespVO = this.invWhRepoProc.findByWhId(id);
        if (Objects.nonNull(invWhRespVO.getDesId())) {
            InvDespatchConfigRespVO despOne = this.invDespatchConfigService.findIdOne(invWhRespVO.getDesId());
            invWhRespVO.setDesName(despOne.getDesName());
        }
        OrgOuRpcDTO ouById = this.orgOutService.findOuById(invWhRespVO.getOuId());
        invWhRespVO.setOuName(ouById.getOuName());
        invWhRespVO.setOuCode(ouById.getOuCode());
        List<String> codeStrList = InvStringUtil.transitionStrToCodes(invWhRespVO.getDesCode());
        invWhRespVO.setDesCodeList(codeStrList);
        List<InvDespatchRpcDTO> orgBuRpcAllDTOS = this.invDespatchConfigDomainService.findByDesCodeBatch(codeStrList);
        HashMap ouMap = CollectionUtil.isEmpty(orgBuRpcAllDTOS) ? new HashMap() : orgBuRpcAllDTOS.stream().collect(Collectors.toMap(InvDespatchRpcDTO::getDesCode, t -> t, (t1, t2) -> t1));
        List<String> desCodeList = invWhRespVO.getDesCodeList();
        ArrayList<String> desCodeNameList = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(desCodeList)) {
            for (String desCode : desCodeList) {
                InvDespatchRpcDTO orgBuRpcDTO = (InvDespatchRpcDTO)ouMap.get(desCode);
                if (!Objects.nonNull(orgBuRpcDTO)) continue;
                desCodeNameList.add(orgBuRpcDTO.getDesName());
            }
        }
        String desCodeName = desCodeNameList.stream().map(String::valueOf).collect(Collectors.joining("\u3001"));
        invWhRespVO.setDesCodeName(desCodeName);
        return Optional.of(invWhRespVO);
    }

    @Override
    public Boolean enableWhhConfig(InvWhSaveVO invWhSaveVO) {
        return this.invWhDomainService.enableWhhConfig(invWhSaveVO.getId(), invWhSaveVO.getWhStatus());
    }

    @Override
    public List<InvWhAreaRespVO> searchArea(InvWhAreaParamVO param) {
        if (param.getWhId() == null) {
            return new ArrayList<InvWhAreaRespVO>();
        }
        List fetch = this.invWhAreaRepoProc.select(param).fetch();
        if (CollectionUtils.isEmpty((Collection)fetch)) {
            return new ArrayList<InvWhAreaRespVO>();
        }
        return fetch;
    }

    public List<InvWhRespVO> invWhareaConvertInvWh(List<InvWhRespVO> whRespVOS, List<InvWhAreaRespVO> fetch) {
        if (CollectionUtils.isEmpty(whRespVOS)) {
            return new ArrayList<InvWhRespVO>();
        }
        ArrayList invWhRespVOList = new ArrayList();
        whRespVOS.stream().forEach(t -> fetch.stream().filter(a -> a.getWhId().equals(t.getId())).forEach(area -> {
            InvWhRespVO invWhRespVO = new InvWhRespVO();
            invWhRespVO.setWhCode(area.getDeter2());
            invWhRespVO.setWhName(area.getDeter2Name());
            invWhRespVO.setPid(t.getId());
            invWhRespVO.setLevel(3);
            invWhRespVO.setId(area.getId());
            invWhRespVO.setDesCode(t.getDesCode());
            invWhRespVO.setDesName(t.getDesName());
            invWhRespVO.setDesId(t.getDesId());
            invWhRespVOList.add(invWhRespVO);
        }));
        return invWhRespVOList.stream().distinct().collect(Collectors.toList());
    }

    public List<InvWhRespVO> desConvertInvWh(List<InvWhRespVO> whRespVOS) {
        ArrayList<InvWhRespVO> invWhRespVOList = new ArrayList<InvWhRespVO>();
        List<InvDespatchConfigPageVO> records = this.invDespatchConfigDomainService.query(new InvDespatchConfigQueryParam());
        if (CollectionUtils.isEmpty(records)) {
            return invWhRespVOList;
        }
        records.stream().forEach(desp -> {
            InvWhRespVO invWhRespVO = new InvWhRespVO();
            invWhRespVO.setWhName(desp.getDesName());
            invWhRespVO.setWhCode(desp.getDesCode());
            invWhRespVO.setPid(0L);
            invWhRespVO.setId(desp.getId());
            invWhRespVO.setLevel(1);
            invWhRespVO.setDesCode(desp.getDesCode());
            invWhRespVO.setDesName(desp.getDesName());
            invWhRespVO.setDesId(desp.getId());
            List collect = whRespVOS.stream().filter(tt -> tt.getDesCode() != null).filter(t -> t.getDesCode().equals(desp.getDesCode()) && t.getPid() == 0L).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                collect.stream().forEach(tt -> tt.setPid(desp.getId()));
            }
            invWhRespVOList.add(invWhRespVO);
        });
        return invWhRespVOList;
    }

    public InvWhTreeServiceImpl(InvDespatchConfigService invDespatchConfigService, InvDespatchConfigDomainService invDespatchConfigDomainService, InvWhRepoProc invWhRepoProc, InvWhRepo invWhRepo, InvWhDomainService invWhDomainService, InvWhAreaRepoProc invWhAreaRepoProc, OrgOutService orgOutService, OrgBuOutService orgBuOutService) {
        this.invDespatchConfigService = invDespatchConfigService;
        this.invDespatchConfigDomainService = invDespatchConfigDomainService;
        this.invWhRepoProc = invWhRepoProc;
        this.invWhRepo = invWhRepo;
        this.invWhDomainService = invWhDomainService;
        this.invWhAreaRepoProc = invWhAreaRepoProc;
        this.orgOutService = orgOutService;
        this.orgBuOutService = orgBuOutService;
    }
}

