/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.provider;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvCommonConvert;
import com.elitesland.yst.production.inv.dto.invstk.InvStkCommonResultRpcDto;
import com.elitesland.yst.production.inv.dto.invstk.param.InvStkCommonOperateRpcParam;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkQtyResultDTO;
import com.elitesland.yst.production.inv.provider.InvStkCommonProvider;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/invStkCommon"})
public class InvStkCommonProviderImpl
implements InvStkCommonProvider {
    private static final Logger log = LoggerFactory.getLogger(InvStkCommonProviderImpl.class);
    private final InvStkOptBizService invStkOptBizService;

    public ApiResult<InvStkCommonResultRpcDto> invStkCommonOperate(InvStkCommonOperateRpcParam param) {
        long begin = System.currentTimeMillis();
        log.info("\u5e93\u5b58\u64cd\u4f5c\u901a\u7528Dubbo\u63a5\u53e3,\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)param));
        try {
            InvStkCommonOperateDTO stkCommonOperateDTO = InvCommonConvert.INSTANCE.invStkCommonOperateRpcParam2DTO(param);
            List<InvStkCommonOperateBodyDTO> sourceBodyList = InvCommonConvert.INSTANCE.invStkCommonOperateRpcBodyParam2DTO(param.getSourceBodyList());
            List<InvStkCommonOperateBodyDTO> targetBodyList = InvCommonConvert.INSTANCE.invStkCommonOperateRpcBodyParam2DTO(param.getTargetBodyList());
            stkCommonOperateDTO.setSourceBodyList(sourceBodyList);
            stkCommonOperateDTO.setTargetBodyList(targetBodyList);
            List<InvStkQtyResultDTO> resultDTOList = this.invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
            InvStkCommonResultRpcDto invStkCommonResultRpcDto = new InvStkCommonResultRpcDto();
            invStkCommonResultRpcDto.setIsSuccessful(Boolean.valueOf(true));
            invStkCommonResultRpcDto.setMessage("\u64cd\u4f5c\u6210\u529f");
            List resultRpcDTOS = resultDTOList.stream().map(InvCommonConvert.INSTANCE::stkQtyResultDTOToStkQtyResultRpcDTO).collect(Collectors.toList());
            invStkCommonResultRpcDto.setResult(resultRpcDTOS);
            log.info("\u5e93\u5b58\u64cd\u4f5c\u901a\u7528Dubbo\u63a5\u53e3,\u8fd4\u56de\u7ed3\u679c\u96c6\uff1a{}", (Object)JSON.toJSONString((Object)invStkCommonResultRpcDto));
            ApiResult apiResult = ApiResult.ok((Object)invStkCommonResultRpcDto);
            return apiResult;
        }
        catch (BusinessException e) {
            log.error("\u5e93\u5b58\u64cd\u4f5c\u901a\u7528Dubbo\u63a5\u53e3,\u4e1a\u52a1\u5f02\u5e38\uff0c\u6d41\u6c34\u53f7\uff1a" + param.getRequestId() + ",\u6765\u6e90\u7cfb\u7edf\uff1a" + param.getSource() + ",\u539f\u56e0\uff1a", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        catch (Exception e) {
            log.error("\u5e93\u5b58\u64cd\u4f5c\u901a\u7528Dubbo\u63a5\u53e3,\u7cfb\u7edf\u5f02\u5e38\uff0c\u6d41\u6c34\u53f7\uff1a" + param.getRequestId() + ",\u6765\u6e90\u7cfb\u7edf\uff1a" + param.getSource() + ",\u539f\u56e0\uff1a", (Throwable)e);
            throw new BusinessException(ApiCode.SYSTEM_EXCEPTION, e.getMessage());
        }
        finally {
            log.info("\u5e93\u5b58\u64cd\u4f5c\u901a\u7528Dubbo\u63a5\u53e3,\u5904\u7406\u8017\u65f6\uff1a[{}ms]", (Object)(System.currentTimeMillis() - begin));
        }
    }

    public InvStkCommonProviderImpl(InvStkOptBizService invStkOptBizService) {
        this.invStkOptBizService = invStkOptBizService;
    }
}

