/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.provider;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRpcDtoParam;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhAreaDO;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaParamRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaSaveDTO;
import com.elitesland.yst.production.inv.provider.InvWhAreaProvider;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="invWhAreaProvide")
@RestController
@RequestMapping(value={"/invWhArea"})
public class InvWhAreaProviderImpl
implements InvWhAreaProvider {
    private static final Logger log = LoggerFactory.getLogger(InvWhAreaProviderImpl.class);
    private final InvWhAreaDomainService invWhAreaDomainService;
    private final OrgOutService orgOutService;
    private final SystemService systemService;
    private final InvWhAreaService invWhAreaService;

    public List<InvWhAreaRpcDTO> findByWhId(Long whId) {
        InvWhAreaRpcDtoParam paramRpcDTO = new InvWhAreaRpcDtoParam();
        paramRpcDTO.setWhId(whId);
        List<InvWhAreaRpcDTO> whAreaRpcDTOS = this.invWhAreaDomainService.selectWhAreaRpcDTOByParam(paramRpcDTO);
        return whAreaRpcDTOS;
    }

    public InvWhAreaRpcDTO findByAreaId(Long id) {
        InvWhAreaRpcDTO invWhAreaRpcDTO = new InvWhAreaRpcDTO();
        Optional<InvWhAreaDO> oneById = this.invWhAreaDomainService.findOneById(id);
        if (oneById.isPresent()) {
            InvWhAreaDO invWhAreaDO = oneById.get();
            BeanUtils.copyProperties((Object)invWhAreaDO, (Object)invWhAreaRpcDTO);
            return invWhAreaRpcDTO;
        }
        return null;
    }

    @SysCodeProc
    public List<InvWhAreaRpcDTO> findByWhIds(List<Long> whIds) {
        InvWhAreaRpcDtoParam paramRpcDTO = new InvWhAreaRpcDtoParam();
        paramRpcDTO.setWhIds(whIds);
        List<InvWhAreaRpcDTO> whAreaRpcDTOS = this.invWhAreaDomainService.selectWhAreaRpcDTOByParam(paramRpcDTO);
        Map<String, String> pTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_EMP.getModel(), UdcEnum.INV_PARTNER_TYPE_EMP.getCode());
        for (InvWhAreaRpcDTO whAreaRpcDTO : whAreaRpcDTOS) {
            if (StringUtils.isEmpty((Object)whAreaRpcDTO.getPType()) || StringUtils.isEmpty((Object)whAreaRpcDTO.getPCode())) continue;
            InvParentParamVO paramVO = new InvParentParamVO();
            paramVO.setType(whAreaRpcDTO.getPType());
            paramVO.setCode(whAreaRpcDTO.getPCode());
            List<OrgRespVO> vos = this.orgOutService.findcodeAndName(paramVO);
            if (!CollectionUtils.isEmpty(vos)) {
                vos.stream().filter(m -> m.getCode().equals(whAreaRpcDTO.getPCode())).findFirst().ifPresent(n -> whAreaRpcDTO.setPName(n.getName()));
            }
            if (MapUtils.isEmpty(pTypeMap)) continue;
            whAreaRpcDTO.setPTypeName(pTypeMap.get(whAreaRpcDTO.getPType()));
        }
        return whAreaRpcDTOS;
    }

    public List<Long> createBatch(List<InvWhAreaSaveDTO> list) {
        log.info("\u4fdd\u5b58\u529f\u80fd\u5e93\u533a\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(list));
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<Long>();
        }
        List<InvWhAreaSaveVO> collect = list.stream().map(t -> (InvWhAreaSaveVO)BeanUtil.copyProperties((Object)t, InvWhAreaSaveVO.class, (String[])new String[0])).collect(Collectors.toList());
        List<Long> batch = this.invWhAreaService.createBatch(collect);
        log.info("\u4fdd\u5b58\u529f\u80fd\u5e93\u533a\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(list));
        return batch;
    }

    public ApiResult deleteByWhId(Long whId) {
        log.info("deleteByWhId\u5220\u9664\u529f\u80fd\u533a\uff1a{}", (Object)JSON.toJSONString((Object)whId));
        if (whId != null) {
            this.invWhAreaDomainService.deleteByWhId(whId);
            return ApiResult.ok();
        }
        return ApiResult.fail();
    }

    public ApiResult deleteByAreaId(List<Long> ids) {
        log.info("deleteByAreaId\u5220\u9664\u529f\u80fd\u533a\uff1a{}", (Object)JSON.toJSONString(ids));
        if (!CollectionUtils.isEmpty(ids)) {
            this.invWhAreaDomainService.deleteBatch(ids);
            return ApiResult.ok();
        }
        return ApiResult.fail();
    }

    public List<InvWhAreaRpcDTO> findDeter2List(InvWhAreaParamRpcDTO param) {
        log.info("findDeter2List\u529f\u80fd\u533a\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString((Object)param));
        if (CollectionUtils.isEmpty((Collection)param.getDeter2s()) || CollectionUtils.isEmpty((Collection)param.getWhIds())) {
            throw new BusinessException("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u4ed3\u5e93\u3001\u529f\u80fd\u533a \u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvWhAreaRpcDtoParam invWhAreaParamVO = new InvWhAreaRpcDtoParam();
        invWhAreaParamVO.setDeter2s(param.getDeter2s());
        invWhAreaParamVO.setWhIds(param.getWhIds());
        invWhAreaParamVO.setDeter2Types(param.getDeter2Types());
        List<InvWhAreaRpcDTO> invWhAreaRespVOS = this.invWhAreaDomainService.selectWhAreaRpcDTOByParam(invWhAreaParamVO);
        return invWhAreaRespVOS;
    }

    public InvWhAreaProviderImpl(InvWhAreaDomainService invWhAreaDomainService, OrgOutService orgOutService, SystemService systemService, InvWhAreaService invWhAreaService) {
        this.invWhAreaDomainService = invWhAreaDomainService;
        this.orgOutService = orgOutService;
        this.systemService = systemService;
        this.invWhAreaService = invWhAreaService;
    }
}

