package com.elitesland.yst.production.inv.application.facade.export.invstk;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author lenovo
 */
@Data
@ExcelIgnoreUnannotated
@HeadRowHeight(35)
public class InvlotDExcelRespVO implements Serializable {
    private static final long serialVersionUID = -4516658956780959279L;

    @ExcelProperty(value = "仓库编码")
    private String whCode;

    @ExcelProperty(value = "仓库名称")
    private String whName;

    @ExcelProperty(value = "商品编码")
    private String itemCode;

    @ExcelProperty(value = "商品名称")
    private String itemName;

    @ExcelProperty(value = "批次号")
    private String lotNo;

    @ExcelProperty(value = "商品条码")
    private String barCode;

    @ExcelProperty(value = "库存数量")
    private BigDecimal ohQty;

    @ExcelProperty(value = "可用数量")
    private BigDecimal avalQty;

    @ExcelProperty("付款订单锁定数量")
    private BigDecimal rsvQty;

    @ExcelProperty("预留单锁定数量")
    private BigDecimal stkQty;

    @ExcelProperty("其他锁定量")
    private BigDecimal otherQty;

    @ExcelProperty(value = "单位")
    private String uomName;

    @ExcelProperty(value = "功能区")
    private String deter2Name;

    @ExcelProperty("入库日期")
    private LocalDateTime inDate;

    @ExcelProperty(value = "生产日期")
    private LocalDateTime manuDate;

    @ExcelProperty("保质期(天)")
    private Integer expireDays;

    @ExcelProperty("供应商")
    private String suppName;

    @ExcelProperty("有效天数")
    private Integer untilExpireDays;

    @ExcelProperty(value = "新鲜度")
    private String fressTypeName;

    @ExcelProperty(value = "品牌编码")
    private String brand;

    @ExcelProperty(value = "品牌名称")
    private String brandName;

    @ExcelProperty(value = "公司编码")
    private String ouCode;

    @ExcelProperty(value = "公司名称")
    private String ouName;

//    @ExcelProperty(value = "商品编码")
//    private String itemCode;
//
//    @ExcelProperty(value = "商品名称")
//    private String itemName;
//
//    @ExcelProperty(value = "商品规格")
//    private String packageSpec;
//
//    @ExcelProperty(value = "库存数量")
//    private Double ohQty;
//
//    @ExcelProperty(value = "承诺量")
//    private Double rsvQty;
//
//    @ExcelProperty("预留量")
//    private Double rsvQty2;
//
//    @ExcelProperty("锁定量")
//    private Double lockQty;
//
//    @ExcelProperty(value = "可供量")
//    private Double avalQty;
//
//    @ExcelProperty(value = "批次号")
//    private String lotNo;
//
//    @ExcelProperty(value = "公司编码")
//    private String ouCode;
//
//    @ExcelProperty(value = "公司名称")
//    private String ouName;
//
//    @ExcelProperty(value = "仓库编码")
//    private String whCode;
//    @ExcelProperty(value = "仓库名称")
//    private String whName;
//
//    @ExcelProperty(value = "温层")
//    private String deter1Name;
//
//    @ExcelProperty(value = "功能库区")
//    private String deter2Name;
//
//    @ExcelProperty(value = "客户号")
//    private String deter3;
//
//    @ExcelProperty(value = "质量状态")
//    private String qcStatusName;
//
//    @ExcelProperty(value = "箱系数")
//    private Float en1;
//
//    @ExcelProperty(value = "库存数量（箱）")
//    private String pohQty;
//
//    @ExcelProperty(value = "库存数量（CT）")
//    private Double tohQty;
//
//    @ExcelProperty(value = "承诺量（箱）")
//    private String prsvQty;
//
//    @ExcelProperty(value = "承诺量（CT）")
//    private Double trsvqty;
//
//    @ExcelProperty(value = "可供量（箱）")
//    private String pavalQty;
//
//    @ExcelProperty(value = "承诺量（CT）")
//    private Double tavalQty;
//
//    @ExcelProperty(value = "单位")
//    private String uomName;
//
//    @ExcelProperty(value = "生产批号")
//    private String manuLotNo;
//
//    @ExcelProperty(value = "库位")
//    private String whLoc;
//
//    @ExcelProperty(value = "生产日期")
//    private LocalDateTime manuDate;
//
//    @ExcelProperty(value = "失效日期")
//    private LocalDateTime expireDate;
//
//    @ExcelProperty(value = "厂家代码")
//    private String agency;
//
//    @ExcelProperty(value = "厂家名称")
//    private String c1Name;
//
//    @ExcelProperty(value = "品牌编码")
//    private String brand;
//
//    @ExcelProperty(value = "品牌代码说明")
//    private String brandName;
//
//    @ExcelProperty(value = "系统保质期")
//    @JsonSerialize(using = ToStringSerializer.class)
//    private Long storeExpireDays;
//
//    @ExcelProperty(value = "批次保质期")
//    private Integer expireDays;
//
//    @ExcelProperty(value = "剩余保质期天数")
//    private Integer untilExpireDays;
//
//    @ExcelProperty(value = "当前日期")
//    private LocalDateTime nowDate;
//
//    @ExcelProperty(value = "新鲜度")
//    private String fressTypeName;
//
//    @ExcelProperty(value = "箱系数（重量KG）")
//    private Float pkgGrossWeight;
//
//    @ExcelProperty(value = "箱系数（高CM）")
//    private Float pkgHeight;
//
//    @ExcelProperty(value = "箱系数（长CM）")
//    private Float pkgLength;
//
//    @ExcelProperty(value = "箱系数（宽CM）")
//    private Float pkgWidth;
//
//    @ExcelProperty(value = "库存总重量（KG）")
//    private Double stkWeight;
//
//    @ExcelProperty(value = "库存总体积（立方米）")
//    private Double stkVolume;
//
//    @ExcelProperty(value = "国内（外）进口代码")
//    private String itemType3;
//
//    @ExcelProperty(value = "国内（外）进口代码说明")
//    private String itemType3Name;

}
