package com.elitesland.yst.production.inv.application.facade.vo;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author lu.wang
 * @date 2020-08-12 08:16
 * Desc: 库内组装单及明细VO
 */
@Data
@ApiModel(value = "INV_ASM_ASMD", description = "库内组装单及明细VO")
public class InvAsmAndAsmDRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 2917363253371374900L;

    // 主表信息
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long ouId;
    String ouName;

    @ApiModelProperty("公司编码")
    String ouCode;

    @ApiModelProperty("单据编号")
    String docNo;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long buId;

    @ApiModelProperty("转移类型 [UDC]INV:TRN_TYPE")
    String docType;

    @ApiModelProperty("转移类型 [UDC]INV:TRN_TYPE")
    String docTypeName;

    @ApiModelProperty("转移单状态 [UDC]INV:TRN_STATUS")
    String docStatus;

    @ApiModelProperty("转移单状态 [UDC]INV:TRN_STATUS")
    String docStatusName;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    String reasonCode;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    String reasonCodeName;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long whId;

    @ApiModelProperty("仓库ID编码")
    String whCode;

    @ApiModelProperty("仓库ID名称")
    String whName;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    String deter1;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    String deter1Name;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    String deter2;

    @ApiModelProperty("功能区名")
    String deter2Name;

    @ApiModelProperty("客户标识")
    String deter3;

    @ApiModelProperty("申请日期")
    LocalDateTime applyDate;

    @ApiModelProperty("交易日期 实际出入库日期")
    LocalDateTime ioDate;

    @ApiModelProperty("流程实例ID")
    String apprProcInstId;

    // 明细表信息
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("行号")
    Float lineNo;

    @ApiModelProperty("行状态")
    String lineStatus;

    @ApiModelProperty("行类型 [UDC]COM:IO")
//    @SysCode(sys = "COM", mod = "IO")
    String lineType;

    @ApiModelProperty("行类型 [UDC]COM:IO")
    String lineTypeName;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long itemId;

    @ApiModelProperty("品项ID编码")
    String itemCode;

    @ApiModelProperty("品项ID名称")
    String itemName;

    @ApiModelProperty("规格")
    String packageSpec;

    @ApiModelProperty("商品规格")
    String itemSpec;

    @ApiModelProperty("品牌编码")
//    @SysCode(sys = "ITM", mod = "ITEM_GROUP")
    String brand;

    @ApiModelProperty("品牌编码名称")
    String brandName;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long variId;

    @ApiModelProperty("批次")
    String lotNo;

    @ApiModelProperty("序列号")
    String snNo;

    @ApiModelProperty("数量")
    BigDecimal qty;

    @ApiModelProperty("单位")
    String uom;

    @ApiModelProperty("单位名称")
    String uomName;

    @ApiModelProperty("数量2")
    BigDecimal qty2;

    @ApiModelProperty("单位2")
    String uom2;

    @ApiModelProperty("单位转换率")
    Float uomRatio;

    @ApiModelProperty("单位转换率2")
    Float uomRatio2;

    @ApiModelProperty("生产日期")
    LocalDateTime manuDate;

    @ApiModelProperty("生产批号")
    String manuLotNo;

    @ApiModelProperty("失效日期")
    LocalDateTime expireDate;

    @ApiModelProperty("税额")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    String homeCurr;

    @ApiModelProperty("交易币种")
    String currCode;

    @ApiModelProperty("交易币种")
    String currCodeName;

    @ApiModelProperty("汇率")
    Float currRate;

    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    BigDecimal currAmt;

    @ApiModelProperty("单位成本")
    BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    BigDecimal costAmt;

    @ApiModelProperty("库存可用量")
    BigDecimal avalQty;

    @ApiModelProperty("外部单据号")
    String outerNo;

    @ApiModelProperty("外部单据行号")
    String outerLineno;

    @ApiModelProperty("外部单据公司")
    String outerOu;

    @ApiModelProperty("外部单据类型")
    String outerType;

    @ApiModelProperty("发起人")
    @JsonSerialize(using = ToStringSerializer.class)
    Long applyEmpId;

    @ApiModelProperty("发起人")
    String applyEmpIdName;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    public String getProcInstStatusName() {
        return procInstStatus != null ? procInstStatus.getDesc() : null;
    }

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    @SysCode(sys = "COM", mod = "APPR_STATUS")
    private String apprStatus;
    @ApiModelProperty("审批状态名称")
    private String apprStatusName;

    @ApiModelProperty("是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty("保质期天数")
    private Integer storeExpireDays;
    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("审批人名")
    private String apprUserName;

    @ApiModelProperty("审批人ID")
    private Long apprUserId;

}
