package com.elitesland.yst.production.inv.application.facade.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Tom.su
 * @program yst-inv
 * @description 库存成本查询实体类
 * @date 2021/07/14 13:25
 */
@Data
@ApiModel(description = "库存成本查询实体类")
public class InvCalCostQueryParam implements Serializable {

    private static final long serialVersionUID = -8384261208464824297L;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("BUID")
    private Long buId;

    @ApiModelProperty("计算日期起")
    private LocalDateTime validFrom;

    @ApiModelProperty("计算日期止")
    private LocalDateTime validTo;

    @ApiModelProperty("商品ID")
    private List<Long> itemIds;

    @ApiModelProperty("业务配置类型")
    private List<InvCostConfigRespVO> configRespVO;

    @ApiModelProperty("成本计算单号")
    private String costCalculateId;

    @ApiModelProperty("当前登录用户ID")
    private Long currentUserId;


}