package com.elitesland.yst.production.inv.application.facade.vo;


import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * Author: Alvy Yin
 */
@Data
@ApiModel(value = "inv_io_lot_trace", description = "批次追溯查询参数")
public class InvIoSearchBatchParam extends AbstractOrderQueryParam {
    @ApiModelProperty("合作伙伴类型")
    String ptype;

    @ApiModelProperty("合作伙伴名称")
    InvIoSearchPNameParam pcode;

    @ApiModelProperty("创建日期")
    List<String> createTime;

    @ApiModelProperty("仓库id")
    List<Long> whIds;

    @ApiModelProperty("温层")
    String deter1;

    @ApiModelProperty("功能区")
    List<String> deter2s;

    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("品牌/子品牌")
    List<String> brands;

    @ApiModelProperty("品项id")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> itemIds;

    @ApiModelProperty("批次")
    String lotNo;
    List<String> lotNos;

    @ApiModelProperty("公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> ouIds;

    @ApiModelProperty("零库存显示")
    Boolean noStk;

    @ApiModelProperty("业务单据类型")
    private String srcDocCls;

    @ApiModelProperty("业务单据类型集合")
    private List<String> srcDocClsList;

    @ApiModelProperty("业务类型")
    private String ioCode;

    @ApiModelProperty("业务类型集合")
    private List<String> ioCodes;

    @ApiModelProperty("交易日期")
    @DateTimeFormat(pattern = "yyyy-MM-DD")
    LocalDateTime ioDate;

    @ApiModelProperty(value = "业务单据编号（暂时使用）")
    String srcCode;

    @ApiModelProperty(value ="单据编号")
    String srcDocNo;

    @ApiModelProperty(value ="单据编号2")
    String srcDocNo2;

    @ApiModelProperty(value ="创建人（暂时使用）")
    Long createUserId;

    @ApiModelProperty("商品类型")
    String itemType;

    @ApiModelProperty("创建时间从")
    private LocalDateTime createTimeFrom;
    @ApiModelProperty(value = "创建时间至")
    private LocalDateTime createTimeTo;

    @ApiModelProperty("功能区关键字")
    private String deter2KeyWord;

    @ApiModelProperty("功能区类型")
    private String deter2Type;
}
