package com.elitesland.yst.production.inv.application.facade.vo.invTrn;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author lu.wang
 * @date 2020-08-07 16:26
 * Desc: 库内转移明细VO
 */
@Data
@ApiModel(value = "INV_TRN_D", description = "库内转移明细")
public class InvTrnDDetailRespVO extends BaseModelVO implements Serializable
{
    private static final long serialVersionUID = -53615427672540319L;
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("行号")
    Float lineNo;

    @ApiModelProperty("行状态")
    String lineStatus;

    @ApiModelProperty("行类型")
    String lineType;

    @ApiModelProperty("从公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long oOuId;

    @ApiModelProperty("从仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long oWhId;

    @ApiModelProperty("从仓库code")
    String oWhCode;

    @ApiModelProperty("到仓库code")
    String iWhCode;

    @ApiModelProperty("从仓库名")
    String oWhName;

    @ApiModelProperty("从温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    String oDeter1;
    String oDeter1Name;

    @ApiModelProperty("从功能区 [UDC]INV:FUNC_TYPE")
    @NotNull
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    String oDeter2;
    String oDeter2Name;

    @ApiModelProperty("在途功能区[UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv",mod = "FUNC_TYPE")
    String tranDeter3;
    String tranDeter3Name;

    @ApiModelProperty("从客户标识")
    String oDeter3;

    @ApiModelProperty("从限定4")
    String oDeter4;

    @ApiModelProperty("从限定5")
    String oDeter5;

    @ApiModelProperty("从限定6")
    String oDeter6;

    @ApiModelProperty("从限定7")
    String oDeter7;

    @ApiModelProperty("从限定8")
    String oDeter8;

    @ApiModelProperty("到公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long iOuId;

    @ApiModelProperty("到仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long iWhId;

    @ApiModelProperty("至仓库名")
    String iWhName;

    @ApiModelProperty("到温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    String iDeter1;
    String iDeter1Name;

    @ApiModelProperty("到功能区 [UDC]INV:FUNC_TYPE")
    @NotNull
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    String iDeter2;
    String iDeter2Name;

    @ApiModelProperty("到客户标识")
    String iDeter3;

    @ApiModelProperty("到限定4")
    String iDeter4;

    @ApiModelProperty("到限定5")
    String iDeter5;

    @ApiModelProperty("到限定6")
    String iDeter6;

    @ApiModelProperty("到限定7")
    String iDeter7;

    @ApiModelProperty("到限定8")
    String iDeter8;

    @ApiModelProperty("品项ID")
    @NotNull
    @JsonSerialize(using = ToStringSerializer.class)
    Long itemId;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long variId;

    @ApiModelProperty("批次")
    String lotNo;

    @ApiModelProperty("序列号")
    String snNo;

    @ApiModelProperty("单位")
    String uom;

    @ApiModelProperty("转移数量2")
    BigDecimal qty2;

    @ApiModelProperty("单位2")
    String uom2;

    @ApiModelProperty("单位转换率")
    Float uomRatio;

    @ApiModelProperty("单位转换率2")
    Float uomRatio2;

    @ApiModelProperty("总数量")
    @NotNull
    BigDecimal qty;

    @ApiModelProperty("数量单位")
    String qtyUom;

    @ApiModelProperty("税额")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    String homeCurr;

    @ApiModelProperty("交易币种")
    String currCode;

    @ApiModelProperty("汇率")
    Float currRate;

    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    BigDecimal currAmt;

    @ApiModelProperty("单位成本")
    BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    BigDecimal costAmt;

    @ApiModelProperty("关联单据类别 如RMA。[UDC]COM:DOC_CLS")
    @SysCode(sys = "COM", mod = "DOC_CLS")
    String relateDocCls;
    String relateDocClsName;

    @ApiModelProperty("关联单据类型")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    String relateDocNo;

    @ApiModelProperty("关联单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateDocDid;

    @ApiModelProperty("关联单据行号")
    Float relateDocLineno;

    @ApiModelProperty("从合作伙伴类型")
    String oPType;

    @ApiModelProperty("从合作伙伴编码")
    String oPCode;
    String oPName;

    @ApiModelProperty("至合作伙伴类型")
    String iPType;

    @ApiModelProperty("至合作伙伴编码")
    String iPCode;
    String iPName;



}
