package com.elitesland.yst.production.inv.application.facade.vo.invstk;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/06/09
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(description = "全量库存查询入参")
public class InvStkFullParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 5457741203867602585L;

    @ApiModelProperty("品牌")
    private List<String> brands;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ouIds;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    @ApiModelProperty("异构ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> variIds;

    @ApiModelProperty("品项编号")
    private String itemCode;
    @ApiModelProperty("品项编号集合")
    private List<String> itemCodes;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> whIds;

    @ApiModelProperty("仓库类型")
    private String whType;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("功能区ID集合")
    private List<String> deter2s;

    @ApiModelProperty("商品ID集合")
    private List<Long> itemIds;

    @ApiModelProperty("商品类型")
    private String itemType;

    @ApiModelProperty("物料类型")
    private String itemType2;

    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty("创建人id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("合作伙伴类型")
    private String pType;

    @ApiModelProperty("合作伙伴code")
    private String pCode;

    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;

}
