package com.elitesland.yst.production.inv.application.facade.vo.invstk;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "inv_stk_io", description = "进销存一览查询参数")
public class InvStkIOParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 5966595898195250272L;

    @ApiModelProperty("仓库id")
    List<Long> whIds;

    @ApiModelProperty("温层")
    String deter1;

    @ApiModelProperty("功能区")
    List<String> deter2s;

    @ApiModelProperty("品牌/子品牌")
    List<String> brands;

    @ApiModelProperty("品项id")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> itemIds;

    @ApiModelProperty("批次")
    String lotNo;
    List<String> lotNos;

    @ApiModelProperty("查询期间 start")
    LocalDateTime timeSlotStart;

    @ApiModelProperty("查询期间 end")
    LocalDateTime timeSlotEnd;

    @ApiModelProperty("零库存")
    Boolean noStk;
}
