package com.elitesland.yst.production.inv.application.facade.vo.invwh;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Alvy.Yin
 */
@Data
@ApiModel(value = "inv_wh_keyword", description = "仓库关键词查询")
public class InvWhKeywordRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 4736607718794779578L;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    @ApiModelProperty("仓库编码")
    private String whCode;
    @ApiModelProperty("仓库名称")
    private String whName;
    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    private String deter1;
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1Name;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2Name;

    @ApiModelProperty("客户标识")
    private String deter3;
    /**
     * E1BP编号
     */
    @ApiModelProperty("E1BP编号")
    private String outerCode;
    /**
     * E1库区编号
     */
    @ApiModelProperty("E1库区编号")
    private String outerCode2;

    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    @SysCode(sys = "yst-inv", mod = "WH_TYPE")
    private String whType;
    private String whTypeName;
}