package com.elitesland.yst.production.inv.application.facade.vo.lot;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 库存批次
 *
 * @author lich.chen
 * @date 2020/08/11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("库存批次")
public class InvLotAllRespVO extends BaseModelVO implements Serializable {
    /**
     * 批次号
     */
    @ApiModelProperty("批次号")
    private String lotNo;

    /**
     * 批次说明
     */
    @ApiModelProperty("批次说明")
    private String lotDesc;

    /**
     * 品项ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("品项ID")
    private Long itemId;

    /**
     * 品项Name
     */
    @ApiModelProperty("品项Name")
    private String itemName;


    /**
     * 首次入库日期
     */
    @ApiModelProperty("首次入库日期")
    LocalDateTime firstInDate;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    /**
     * 供应商Name
     */
    @ApiModelProperty("供应商Name")
    private String suppName;

    /**
     * 生产批次
     */
    @ApiModelProperty("生产批次")
    private String menuLotNo;

    /**
     * 生产日期
     */
    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    /**
     * 失效日期
     */
    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;

    private Integer expireDays;

    /**
     * 采购单号
     */
    @ApiModelProperty("采购单号")
    private String poNo;

    /**
     * 采购单类型
     */
    @ApiModelProperty("采购单类型")
    private String poType;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司Name")
    private String ouName;
    /**
     * 质量状态
     */
    @ApiModelProperty("质量状态")
    private String qcStatus;

    /**
     * 已卫检数量
     */
    @ApiModelProperty("已卫检数量")
    private BigDecimal sinQty;

    /**
     * 卫检状态
     */
    @ApiModelProperty("卫检状态")
    private String sinStatus;

    /**
     * 默认卫检单编号
     */
    @ApiModelProperty("默认卫检单编号")
    private String sinNo;

    /**
     * 锁定原因
     */
    @ApiModelProperty("锁定原因")
    private String lockReason;

    /**
     * 来源单据类别
     */
    @ApiModelProperty("来源单据类别")
    private String srcDocCls;

    /**
     * 来源单据编号
     */
    @ApiModelProperty("来源单据编号")
    private String srcDocNo;

}
