package com.elitesland.yst.production.inv.application.facade.vo.lot;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 批次主档
 * </p>
 *
 * @author ssy
 * @since 2020-07-30 15:08:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "inv_lot", description = "批次主档")
public class InvLotRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 990782382452157648L;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 公司编码
     */
    @ApiModelProperty("公司编码")
    @JsonSerialize(using = ToStringSerializer.class)
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    @JsonSerialize(using = ToStringSerializer.class)
    private String ouName;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;
    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;
    @ApiModelProperty("品项名称")
    private String itemName;
    /**
     * 批次号
     */
    @ApiModelProperty("批次号")
    private String lotNo;
    /**
     * 批次说明
     */
    @ApiModelProperty("批次说明")
    private String lotDesc;
    /**
     * 批次状态 允许的出入库类型，0,可以出，1不可以出
     */
    @ApiModelProperty("批次状态 允许的出入库类型，0,可以出，1不可以出")
    private String lotStatus;

    @ApiModelProperty("批次状态说明")
    private String lotStatusName;

    /**
     * 批次状态2 备用
     */
    @ApiModelProperty("批次状态2 备用")
    private String lotStatus2;
    /**
     * 批次状态3 备用
     */
    @ApiModelProperty("批次状态3 备用")
    private String lotStatus3;
    /**
     * 质量状态
     */
    @SysCode(sys = "yst-inv", mod = "LOT_QC_STATUS")
    @ApiModelProperty("质量状态")
    private String qcStatus;
    private String qcStatusName;

    /**
     * 锁定原因
     */
    @ApiModelProperty("锁定原因")
    @SysCode(sys = "yst-inv", mod = "LOT_LOCK_REASON")
    private String lockReason;
    private String lockReasonName;

    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer expireDays;
    /**
     * 生产日期
     */
    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;
    /**
     * 生产批次
     */
    @ApiModelProperty("生产批次")
    private String menuLotNo;
    /**
     * 整批号
     */
    @ApiModelProperty("整批号")
    private String batchNo;
    /**
     * 失效日期
     */
    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;
    /**
     * 剩余效期天数 每天自动计算
     */
    @ApiModelProperty("剩余效期天数 每天自动计算")
    private Integer untilExpireDays;
    /**
     * 新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE
     */
    @ApiModelProperty("新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE")
    private String fressType;
    /**
     * 首次入库日期
     */
    @ApiModelProperty("首次入库日期")
    private LocalDateTime firstInDate;
    /**
     * 最后出库日期
     */
    @ApiModelProperty("最后出库日期")
    private LocalDateTime lastOutDate;
    /**
     * 销售截止日期
     */
    @ApiModelProperty("销售截止日期")
    private LocalDateTime maxSaleDate;

    /**
     * 原产国
     */
    @ApiModelProperty("原产国")
    private String menuCountry;
    /**
     * 产地描述
     */
    @ApiModelProperty("产地描述")
    private String menuDesc;
    /**
     * 产地证明编号
     */
    @ApiModelProperty("产地证明编号")
    private String menuDocNo;
    /**
     * 制造商ID
     */
    @ApiModelProperty("制造商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long manuerId;
    /**
     * 制造商编号
     */
    @ApiModelProperty("制造商编号")
    private String manuerCode;
    /**
     * 制造商名称
     */
    @ApiModelProperty("制造商名称")
    private String manuerName;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("供应商名称")
    @JsonSerialize(using = ToStringSerializer.class)
    private String suppName;


    @ApiModelProperty("供应商编码")
    @JsonSerialize(using = ToStringSerializer.class)
    private String suppCode;


    /**
     * 货主类型 供应商/客户，DCH不用
     */
    @ApiModelProperty("货主类型 供应商/客户，DCH不用")
    private String ownerType;
    /**
     * 货主ID DCH不用
     */
    @ApiModelProperty("货主ID DCH不用")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ownerId;
    /**
     * 货主编码 DCH不用
     */
    @ApiModelProperty("货主编码 DCH不用")
    private String ownerCode;
    /**
     * 来源单据类别
     */
    @ApiModelProperty("来源单据类别")
    @SysCode(sys = "yst-supp",mod = "DOC_CLS")
    private String srcDocCls;
    private String srcDocClsName;
    /**
     * 来源单据ID
     */
    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;
    /**
     * 来源单据编号
     */
    @ApiModelProperty("来源单据编号")
    private String srcDocNo;
    /**
     * 来源单据明细ID
     */
    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid;
    /**
     * 采购单ID
     */
    @ApiModelProperty("采购单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poId;
    /**
     * 采购单号
     */
    @ApiModelProperty("采购单号")
    private String poNo;
    /**
     * 采购单类型
     */
    @ApiModelProperty("采购单类型")
    private String poType;
    /**
     * 采购单明细ID
     */
    @ApiModelProperty("采购单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poDId;
    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;

    @ApiModelProperty("DATE1")
    private LocalDateTime date1;

    @ApiModelProperty("DATE2")
    private LocalDateTime date2;

    @ApiModelProperty("DATE3")
    private LocalDateTime date3;

    @ApiModelProperty("DATE4")
    private LocalDateTime date4;

    @ApiModelProperty("DATE5")
    private LocalDateTime date5;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;


}
