package com.elitesland.yst.production.inv.application.service;


import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocSaveVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 功能说明:库存操作码
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
public interface InvIocService {

    /**
     * 新增库存操作码数据
     *
     * @param saveVo 新增库存操作码数据
     * @return 新增库存操作码ID
     */
    ApiResult<Long> createOne(InvIocSaveVO saveVo);

    /**
     * 修改库存操作码数据
     *
     * @param saveVo 修改库存操作码对象
     * @return 库存操作码ID
     */
    ApiResult<Long> update(InvIocSaveVO saveVo);

    /**
     * 通过库存操作码ID查询单条数据
     *
     * @param id 库存操作码ID
     * @return 单条库存操作码数据
     */
    ApiResult<InvIocRespVO> findIdOne(Long id);

    /**
     * 通过库存操作码查询单条数据
     *
     * @param code 库存操作码编码
     * @return 单条库存操作码数据
     */
    Optional<InvIocRespVO> findByCode(String code);

    /**
     * 通过库存操作码集合查询数据
     *
     * @param codeList 库存操作码编码集合
     * @return 库存操作码数据集合
     */
    List<InvIocRespVO> findByCodeBatch(List<String> codeList);

    /**
     * 分页查询库存操作码
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条库存操作码数据
     */
    PagingVO<InvIocRespVO> search(InvIocParamVO param);

    /**
     * 根据库存操作码ID批量逻辑删除
     *
     * @param ids 库存操作码ID集合
     * @return 库存操作码ID集合
     */
    ApiResult<String> deleteBatch(List<Long> ids);

    /**
     * 根据入参查询库存操作码
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条库存操作码数据
     */
    List<InvIocRespVO> select(InvIocParamVO param);
}
