package com.elitesland.yst.production.inv.application.service.impl;


import cn.hutool.core.bean.BeanUtil;
import com.elitesland.yst.production.inv.application.facade.vo.*;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvAsmService;
import com.elitesland.yst.production.inv.application.service.InvStkCommonService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.convert.InvAsmConvert;
import com.elitesland.yst.production.inv.domain.convert.InvAsmDConvert;
import com.elitesland.yst.production.inv.domain.entity.*;
import com.elitesland.yst.production.inv.domain.service.InvAsmDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvAsmDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvAsmDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.repo.InvAsmDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvAsmRepo;
import com.elitesland.yst.production.inv.infr.repo.InvAsmRepoProc;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.enums.ProcDefKey;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author jeesie.jiang
 * @date 2022-03-27 17:08
 * Desc:
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class InvAsmServiceImpl implements InvAsmService {

    private final InvAsmRepo invAsmRepo;
    private final InvAsmRepoProc invAsmRepoProc;
    private final InvAsmDRepo invAsmDRepo;
    private final InvWhDomainService invWhService;
    private final SystemService systemService;
    private final OrgOutService outouService;
    //团内结算价格申请单维护，先注释
    private final InvAsmDomainService invAsmDomainService;
    private final InvAsmDDomainService invAsmDDomainService;
    private final WorkflowService workflowService;
    private final InvWhAreaDomainService invWhAreaDomainService;


    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    @Override
    public Optional<InvAsmRespVO> findIdOne(Long id) {
        Optional<InvAsmRespVO> invAsmVo = invAsmRepo.findById(id).map(invAsmDO -> BeanUtil.copyProperties(invAsmDO, InvAsmRespVO.class));
        if (invAsmVo.isPresent()) {
            // 调用仓库接口
            val wh = invWhService.findIdOne(invAsmVo.get().getWhId() != null ? invAsmVo.get().getWhId() : 0L);
            if (wh.isPresent()) {
                invAsmVo.get().setWhName(wh.get().getWhName());
            }
            //调用员工接口
            if (invAsmVo.get().getApplyEmpId() != null) {
                OrgEmpRpcDTO empRpcDTO = outouService.findEmpById(invAsmVo.get().getApplyEmpId());
                if (empRpcDTO != null) {
                    invAsmVo.get().setApplyEmpName(empRpcDTO.getEmpName());
                }
            }
            //调用udc翻译方法
            invAsmVo = udcChange(invAsmVo);
            return invAsmVo;
        }
        return invAsmVo;
    }

    /**
     * 将controller层的代码迁移到service层
     *
     * @param inv
     * @return
     */
    @Override
    @Transactional
    public Long create(InvAsmAndAsmDSaveVO inv) {
        //DeleteFlag设置默认值
        inv.getHeader().setDeleteFlag(0);
        inv.getDetails().stream().forEach(v -> {
            v.setDeleteFlag(0);
        });
        //这里定义常量
        if(inv.getHeader().getId() == null){
            inv.getHeader().setDocStatus(UdcEnum.INV_ASM_STATUS_DR.getValueCode());
            inv.getHeader().setDocType(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
            ArrayList<String> runtimeValues = new ArrayList<>();
            runtimeValues.add(String.valueOf(inv.getHeader().getOuCode()));
            //这里定义常量
            val code = systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_IY.getCode(), runtimeValues);
            inv.getHeader().setDocNo(inv.getHeader().getDocNo() != null ? inv.getHeader().getDocNo() : code);

        }else{
            Optional<InvAsmDTO> invAsmDOOptional = invAsmDomainService.findIdOne(inv.getHeader().getId());
            if(invAsmDOOptional.isPresent()){
                InvAsmDTO invAsmDTO = invAsmDOOptional.get();
                String procInstId = invAsmDTO.getProcInstId();
                inv.getHeader().setProcInstId(procInstId);
                inv.getHeader().setDocNo(invAsmDTO.getDocNo());
                inv.getHeader().setApprComment(invAsmDTO.getApprComment());
                inv.getHeader().setProcInstStatus(invAsmDTO.getProcInstStatus());
                inv.getHeader().setSubmitTime(invAsmDTO.getSubmitTime());
                inv.getHeader().setCreateTime(LocalDateTime.now());
            }
            List<InvAsmDDO> invAsmDDOS = invAsmDDomainService.findByMasId(inv.getHeader().getId());
            List<Long> detailIds = invAsmDDOS .stream().map(InvAsmDDO::getId).collect(Collectors.toList());
            invAsmDDomainService.deleteBatch(detailIds);
        }
        //vo转do
        InvAsm asm = InvAsmConvert.INSTANCE.voToAsm(inv.getHeader());
        //进行库存组装单新增/更新
        Long id = invAsmDomainService.create(asm);
        AtomicDouble linoNo = new AtomicDouble(0);
        if (inv.getDetails().size() > 0) {
            val detailDOs = inv.getDetails().stream().map(d -> {
                d.setCreateTime(LocalDateTime.now());
                d.setMasId(id);
                d.setLineNo(linoNo.addAndGet(1));
              /*  PriGroupParam param = new PriGroupParam();
                param.setItemId(d.getItemId());
                param.setFromOuId(asm.getOuId());
                param.setToOuId(asm.getOuId());
                param.setDocTime(asm.getIoDate());*/
                return d;
            }).collect(Collectors.toList());
            //进行库存组装单明细新增
            List<InvAsmD> invAsmDS = detailDOs.stream().map(InvAsmDConvert.INSTANCE::voToAsmd).collect(Collectors.toList());
            invAsmDDomainService.createBatch(invAsmDS);
        }
         return id;
    }



    @Override
    @Transactional
    public List<Long> updateStatusInBatch(List<Long> ids, String status) {
        val asms = invAsmRepo.findAll(invAsmRepoProc.where(ids));
        List<InvAsmDO> listAsms = Lists.newArrayList(asms);
        if (listAsms.size() > 0) {
            listAsms.stream().forEach(a -> {
                a.setDocStatus(status);
            });
            val ret = updateInBatch(listAsms);
            return ret;
        }
        return ids;
    }

    @Override
    @Transactional
    public Long submit(Long id) {
        SysUserDTO user = systemService.sysUserCurrent();
        if (user == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法到获取当前用户");
        }
        InvAsmDO invAsmDO = invAsmRepo.findById(id).orElseThrow(new BusinessException("修改失败，数据不存在"));
        /**库存锁定增**/
        List<InvAsmDDO> invAsmDDOS = invAsmDRepo.findByMasId(id);
        //开启工作流判断
        if (invAsmDO.getProcInstId() == null
                        || WorkflowConstant.CAN_START_PROC_STATUSES.contains(invAsmDO.getProcInstStatus() )
        ){
            //开启业务工作流
            String procInstName = ProcDefKey.INV_ASM.getDesc()+invAsmDO.getDocNo();
            this.startWorkFlow(ProcDefKey.INV_ASM.name(), procInstName, invAsmDO.getId() + "", user.getId() + "", id);

        }else{
            invAsmDO.setDocStatus(UdcEnum.INV_ASM_STATUS_APPING.getValueCode());
            invAsmDO.setIoDate(LocalDateTime.now());// 交易日期为单据提交日期
            invAsmRepo.save(invAsmDO);
        }
        return id;
    }


    private InvStkCommonOperateDTO getInvStkCommonOperateDTO(List<InvAsmDDO> invAsmDDOS, InvAsmDO invAsmDO, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-",""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<>();
        invAsmDDOS.stream().forEach(invAsmDDO -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invAsmDO.getWhId());
            operateBodyDTO.setItemId(invAsmDDO.getItemId());
            operateBodyDTO.setDeter2(invAsmDO.getDeter2());
            operateBodyDTO.setSrcDocId(invAsmDO.getId());
            operateBodyDTO.setDocNo(invAsmDO.getDocNo());
            operateBodyDTO.setSrcDocDid(invAsmDDO.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
            operateBodyDTO.setLineNo(invAsmDDO.getLineNo());
            operateBodyDTO.setCreateUserId(invAsmDO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invAsmDDO.getUom());
            operateBodyDTO.setQty(invAsmDDO.getQty());
            operateBodyDTO.setLotNo(invAsmDDO.getLotNo());
            operateBodyDTOS.add(operateBodyDTO);
        });
        operateDTO.setSourceBodyList(operateBodyDTOS);
        return operateDTO;
    }


    private void startWorkFlow(String processDefinitionKey,String procInstName, String businessKey,String currentUserId,Long id){
        try {
            WorkflowResult<ProcessInfo> processInfoWorkflowResult = workflowService.startProcess(StartProcessPayload.of(processDefinitionKey, procInstName, businessKey, null));
            log.info("库存转移启动流程返回:" + processInfoWorkflowResult);
            if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
                throw new BusinessException("调用工作流异常，错误信息:" + processInfoWorkflowResult.getMsg());
            }
            QInvAsmDO qInvAsmDO = QInvAsmDO.invAsmDO;
            JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qInvAsmDO)
                    .set(qInvAsmDO.procInstId, processInfoWorkflowResult.getData().getProcInstId())
                    .set(qInvAsmDO.submitTime, LocalDateTime.now())
                    .set(qInvAsmDO.ioDate,LocalDateTime.now())
                    .where(qInvAsmDO.id.eq(id));
            if (!Objects.equals(processInfoWorkflowResult.getData().getProcInstStatus(), ProcInstStatus.APPROVED)) {
                jpaUpdateClause.set(qInvAsmDO.procInstStatus, ProcInstStatus.APPROVING);
                jpaUpdateClause.set(qInvAsmDO.docStatus, UdcEnum.INV_TRN_STATUS_APPING.getValueCode());
            }
            jpaUpdateClause.execute();
        } catch (Exception e){
            throw new BusinessException(ApiCode.FAIL,"开启工作流服务失败:"+e.getMessage());
        }



    }

    public List<Long> updateInBatch(List<InvAsmDO> list) {
        return invAsmRepo.saveAll(list).stream().map(InvAsmDO::getId).collect(Collectors.toList());
    }

    /**
     * UDC转换
     *
     * @param invAsmVo
     */
    public Optional<InvAsmRespVO> udcChange(Optional<InvAsmRespVO> invAsmVo) {
        //进行UDC转换(udcEnum只使用model，code)
        Map<String, String> udcDocType = systemService.sysUdcGetCodeMap(UdcEnum.INV_ASM_TYPE_DEF.getModel(), UdcEnum.INV_ASM_TYPE_DEF.getCode()); //组装类型
        Map<String, String> udcDocStatus = systemService.sysUdcGetCodeMap(UdcEnum.INV_ASM_STATUS_DR.getModel(), UdcEnum.INV_ASM_STATUS_DR.getCode());//组装单状态
        Map<String, String> udcApprStatus = systemService.sysUdcGetCodeMap(UdcEnum.COM_APPR_STATUS_APPROVING.getModel(), UdcEnum.COM_APPR_STATUS_APPROVING.getCode());//审批状态
        Map<String, String> udcDeter1 = systemService.sysUdcGetCodeMap(UdcEnum.INV_TEMP_TYPE_RT.getModel(), UdcEnum.INV_TEMP_TYPE_RT.getCode());//温层
        InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
        areaParamVO.setDeter2(invAsmVo.get().getDeter2());
        areaParamVO.setWhId(invAsmVo.get().getWhId());
        List<InvWhAreaRespVO> whAreasByParam = invWhAreaDomainService.findWhAreasByParam(areaParamVO);
        Map<String, String> udcReasonCode = systemService.sysUdcGetCodeMap(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode());//原因码
        Map<String, String> udcRelateDocCls = systemService.sysUdcGetCodeMap(UdcEnum.COM_DOC_CLS_SPA.getModel(), UdcEnum.COM_DOC_CLS_SPA.getCode());//关联单据类别
        invAsmVo.stream().forEach(Asm -> {
            if (StringUtils.isNotBlank(Asm.getDocType()) && !MapUtils.isEmpty(udcDocType)) {
                Asm.setDocTypeName(udcDocType.get(Asm.getDocType()));
            }
            if (StringUtils.isNotBlank(Asm.getDocStatus()) && !MapUtils.isEmpty(udcDocStatus)) {
                Asm.setDocStatusName(udcDocStatus.get(Asm.getDocStatus()));
            }
            if (StringUtils.isNotBlank(Asm.getApprStatus()) && !MapUtils.isEmpty(udcApprStatus)) {
                Asm.setApprStatusName(udcApprStatus.get(Asm.getApprStatus()));
            }
            if (StringUtils.isNotBlank(Asm.getDeter1()) && !MapUtils.isEmpty(udcDeter1)) {
                Asm.setDeter1Name(udcDeter1.get(Asm.getDeter1()));
            }
            if(!CollectionUtils.isEmpty(whAreasByParam)){
                whAreasByParam.stream().filter(i -> i.getWhId().equals(Asm.getWhId()) &&
                        i.getDeter2().equals(Asm.getDeter2())).findAny().ifPresent(m ->{
                    Asm.setDeter2Name(m.getDeter2Name());
                });
            }
            if (StringUtils.isNotBlank(Asm.getReasonCode()) && !MapUtils.isEmpty(udcReasonCode)) {
                Asm.setReasonCodeName(udcReasonCode.get(Asm.getReasonCode()));
            }
            if (StringUtils.isNotBlank(Asm.getRelateDocCls()) && !MapUtils.isEmpty(udcRelateDocCls)) {
                Asm.setRelateDocClsName(udcRelateDocCls.get(Asm.getRelateDocCls()));
            }
        });
        return invAsmVo;
    }


//    @Override
//    public List<InvAsmParamVO> findByIntfFlagAndRelate2No(Integer i, String relate2No) {
//        return invAsmRepo.findByIntfFlagAndRelate2No(i, relate2No).stream().map(v -> BeanUtil.copyProperties(v, InvAsmParamVO.class)).collect(Collectors.toList());
//    }

//    @Override
//    public List<InvAsmDO> findByDocNos(List<String> docNos) {
//        QInvAsmDO invAsmDO = QInvAsmDO.invAsmDO;
//        Iterable<InvAsmDO> all = invAsmRepo.findAll((invAsmDO.deleteFlag.eq(0).or(invAsmDO.deleteFlag.isNull()))
//                .and(invAsmDO.docNo.in(docNos)));
//        return Lists.newArrayList(all);
//    }
//
//    private void startWorkflow(InvAsmDO invAsmDO) {
//
//        HashMap<String, Object> variables = new HashMap<>();
//        variables.put("money", new BigDecimal(1000));
//
//        Optional<SysUserDTO> user = sysUserService.current();
//        if (!user.isPresent()) {
//            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取到当前用户");
//        }
//        Long userId = user.get().getId();
//
//        // TODO-LU.WANG: 2020-10-20 10:26:03 需要添加流程变量判断启动库存组装(采购公司) or 库存组装(销售公司)
//        String processKey = "INV_ASSEMBLE_PURC";
//        String processName = "库存组装(采购公司)流程";
//        String processInstanceId = workflowService.startProcess(StartProcessPayload.of(processKey, processName, invAsmDO.getId() + "", variables, "1", userId + "");
//        System.out.println("-----------------库存组装(采购公司)流程启动---------");
//        invAsmDO.setApprProcInstId(processInstanceId);
//        invAsmDO.setDocStatus("APPING");
//        invAsmDO.setApprStatus(ProcInstStatus.APPROVING.name());
//        invAsmDO.setApprTime(LocalDateTime.now());
//        invAsmDO.setApprCreateUserId(userId);
//        invAsmRepo.save(invAsmDO);
//    }


}
