package com.elitesland.yst.production.inv.application.service.impl;

import com.elitesland.yst.production.inv.application.facade.vo.InvStkCommon28InSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvStkCommon37InSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAllQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAndTrnDDownloadRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAndTrnRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvStkCommonService;
import com.elitesland.yst.production.inv.application.service.InvTrnDService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaSettingService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.convert.InvTrnConvert;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvCommonConvert;
import com.elitesland.yst.production.inv.domain.entity.invtrn.InvTrn;
import com.elitesland.yst.production.inv.domain.entity.whAreaSetting.InvWhAreaSetting;
import com.elitesland.yst.production.inv.domain.service.InvTrnDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvTrnDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.entity.InvTrnDDO;
import com.elitesland.yst.production.inv.entity.InvTrnDO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnAndTrnDTO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnDTO;
import com.elitesland.yst.production.inv.infr.repo.InvTrnDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvTrnRepo;
import com.elitesland.yst.production.inv.utils.InvStk28Enum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author jeesie
 */
@Slf4j
@Service
@AllArgsConstructor
public class InvTrnDServiceImpl implements InvTrnDService {

    private final InvTrnDDomainService invTrnDDomainService;

    private final InvTrnDomainService invTrnDomainService;

    private final InvStkCommonService invStkCommonService;

    private final SystemService systemService;

    private final ItmOutService itmOutService;

    private final OrgOutService orgOutService;

    private final InvWhDomainService invWhDomainService;

    private final InvStkOptBizService invStkOptBizService;

    private final InvWhAreaDomainService whAreaDomainService;




    @Override
    public PagingVO<InvTrnAndTrnRespVO> search(InvTrnAllQueryParamVO param) {
        PagingVO<InvTrnAndTrnDTO> pagingVO = invTrnDDomainService.search(param);
        if (CollectionUtils.isEmpty(pagingVO.getRecords())) {
            return PagingVO.<InvTrnAndTrnRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List<InvTrnAndTrnDTO> trnAndTrnDTOS = pagingVO.getRecords();
        List<InvTrnAndTrnRespVO> trnAndTrnRespVOS = trnAndTrnDTOS.stream().map(d -> {
            InvTrnAndTrnRespVO invTrnAndTrnRespVO = InvTrnConvert.INSTANCE.dtoTorespVO(d);
            return invTrnAndTrnRespVO;

        }).collect(Collectors.toList());
        fillupNameList(trnAndTrnRespVOS);
        return PagingVO.<InvTrnAndTrnRespVO>builder()
                .records(trnAndTrnRespVOS)
                .total(pagingVO.getTotal()).build();
    }


    @Override
    public List<InvTrnAndTrnDDownloadRespVO> findInvTrnAndTrnDDownloadVOList(InvTrnAllQueryParamVO param) {
        param.setSize(20000);
        val ret = search(param);
        List<InvTrnAndTrnRespVO> list = ret.getRecords();

        List<InvTrnAndTrnDDownloadRespVO> invTrnAndTrnDDownloadRespVOList = list.stream().map(i -> {
            InvTrnAndTrnDDownloadRespVO downloadVO = new InvTrnAndTrnDDownloadRespVO();
            BeanUtils.copyProperties(i, downloadVO);
            downloadVO.setOwhName(i.getOWhName());
            downloadVO.setIwhName(i.getIWhName());
            downloadVO.setOdeter2Name(i.getODeter2Name());
            downloadVO.setIdeter2Name(i.getIDeter2Name());
            String outerType = StringUtils.isEmpty(downloadVO.getOuterType()) ? "" : downloadVO.getOuterType();
            String outerNo = StringUtils.isEmpty(downloadVO.getOuterNo()) ? "" : downloadVO.getOuterNo();
            if (!StringUtils.isEmpty(outerType) && !StringUtils.isEmpty(outerNo)) {
                downloadVO.setOuterNo(outerType + outerNo);
            }
            return downloadVO;
        }).collect(Collectors.toList());
        return invTrnAndTrnDDownloadRespVOList;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public void confirm(Long masId) {
        InvTrnDTO invTrnDTO = invTrnDomainService.findIdOne(masId).get();
        if (Objects.isNull(invTrnDTO)) {
            throw new BusinessException(ApiCode.FAIL,"库存转移单不存在，请检查");

        }
        if(!UdcEnum.INV_TRN_STATUS_APPED.getValueCode().equals(invTrnDTO.getDocStatus())){
            throw new BusinessException(ApiCode.FAIL,"请选择<转移单状态>为【已审批】的单据！");
        }
        val param = new InvTrnAllQueryParamVO();
        param.setMasId(masId);
        val invTrnAndTrnDVoList = invTrnDDomainService.findAll(param);
        InvStkCommonOperateDTO stkCommonOperateDTO = getOInvStkCommonOperateDTO(invTrnAndTrnDVoList, "TRN003");
        invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
        //修改单据状态为已确认
        invTrnDomainService.updateDocStatusByIds(List.of(masId), UdcEnum.INV_TRN_STATUS_CF.getValueCode());

    }

    private InvStkCommonOperateDTO getOInvStkCommonOperateDTO(List<InvTrnAndTrnDTO> invTrnDRespVOS, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-",""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<>();
        ArrayList<InvStkCommonOperateBodyDTO> sourceBodyList = getSourceBodyList(invTrnDRespVOS);
        operateDTO.setSourceBodyList(sourceBodyList);
        return operateDTO;
    }

    private InvStkCommonOperateDTO getIInvStkCommonOperateDTO(List<InvTrnAndTrnDTO> invTrnDRespVOS, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-",""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> sourceBodyList = getSourceBodyList(invTrnDRespVOS);
        ArrayList<InvStkCommonOperateBodyDTO> targetBodyList = getTargetBodyList(invTrnDRespVOS);
        operateDTO.setSourceBodyList(sourceBodyList);
        operateDTO.setTargetBodyList(targetBodyList);
        return operateDTO;
    }


    private ArrayList<InvStkCommonOperateBodyDTO> getTargetBodyList(List<InvTrnAndTrnDTO> invTrnDRespVOS){
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<>();
        invTrnDRespVOS.stream().forEach(invTrnDRespVo -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invTrnDRespVo.getIWhId());
            operateBodyDTO.setItemId(invTrnDRespVo.getItemId());
            operateBodyDTO.setDeter2(invTrnDRespVo.getIDeter2());
            operateBodyDTO.setSrcDocId(invTrnDRespVo.getId());
            operateBodyDTO.setDocNo(invTrnDRespVo.getDocNo());
            operateBodyDTO.setSrcDocDid(invTrnDRespVo.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            operateBodyDTO.setLineNo(invTrnDRespVo.getLineNo());
            operateBodyDTO.setCreateUserId(invTrnDRespVo.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invTrnDRespVo.getUom());
            operateBodyDTO.setQty(invTrnDRespVo.getQty());
            operateBodyDTO.setLotNo(invTrnDRespVo.getLotNo());
            operateBodyDTO.setPCode(invTrnDRespVo.getIPCode());
            operateBodyDTO.setPType(invTrnDRespVo.getIPType());
            operateBodyDTO.setOuId(invTrnDRespVo.getOuId());
            operateBodyDTO.setVariId(invTrnDRespVo.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        return operateBodyDTOS;
    }


    private ArrayList<InvStkCommonOperateBodyDTO> getSourceBodyList(List<InvTrnAndTrnDTO> invTrnDRespVOS){
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<>();
        invTrnDRespVOS.stream().forEach(invTrnDRespVo -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invTrnDRespVo.getOWhId());
            operateBodyDTO.setItemId(invTrnDRespVo.getItemId());
            operateBodyDTO.setDeter2(invTrnDRespVo.getODeter2());
            operateBodyDTO.setSrcDocId(invTrnDRespVo.getId());
            operateBodyDTO.setDocNo(invTrnDRespVo.getDocNo());
            operateBodyDTO.setSrcDocDid(invTrnDRespVo.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            operateBodyDTO.setLineNo(invTrnDRespVo.getLineNo());
            operateBodyDTO.setCreateUserId(invTrnDRespVo.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invTrnDRespVo.getUom());
            operateBodyDTO.setQty(invTrnDRespVo.getQty());
            operateBodyDTO.setLotNo(invTrnDRespVo.getLotNo());
            operateBodyDTO.setPCode(invTrnDRespVo.getOPCode());
            operateBodyDTO.setPType(invTrnDRespVo.getOPType());
            operateBodyDTO.setOuId(invTrnDRespVo.getOuId());
            operateBodyDTO.setVariId(invTrnDRespVo.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        return operateBodyDTOS;
    }



    @Override
    @Transactional(rollbackFor = Exception.class)
    public void recevieConfirm(Long masId , boolean isAuto) {
        InvTrnDTO invTrnDTO = invTrnDomainService.findIdOne(masId).orElse(null);
        if (Objects.isNull(invTrnDTO)) {
            throw new BusinessException(ApiCode.FAIL, "库存转移单未找到");
        }
        if(!UdcEnum.INV_TRN_STATUS_CF.getValueCode().equals(invTrnDTO.getDocStatus())){
            throw new BusinessException(ApiCode.FAIL,"请选择<转移单状态>为【收货数量异常】或【已确认】的单据！");
        }
        val param = new InvTrnAllQueryParamVO();
        param.setMasId(masId);
        val invTrnAndTrnDVoList = invTrnDDomainService.findAll(param);
        //
        InvStkCommonOperateDTO stkCommonOperateDTO = getIInvStkCommonOperateDTO(invTrnAndTrnDVoList, "TRN004");
        invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
        //修改单据状态为收货
       invTrnDomainService.updateDocStatusByIds(List.of(masId), UdcEnum.INV_TRN_STATUS_RE.getValueCode());

    }

    @Override
    @Transactional
    public void check(Long masId) {
        Optional<InvTrnDTO> invTrnDTOOptional = invTrnDomainService.findIdOne(masId);
        if (!invTrnDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + masId);
        }
        // 修改状态为已审批
        invTrnDTOOptional.get().setDocStatus(UdcEnum.INV_TRN_STATUS_APPED.getValueCode());
        InvTrn invTrn = InvTrnConvert.INSTANCE.dtoToInvTrn(invTrnDTOOptional.get());
        invTrnDomainService.create(invTrn);
    }

    @Override
    @Transactional
    public void refuse(Long masId) {
        Optional<InvTrnDTO> invTrnDTOOptional = invTrnDomainService.findIdOne(masId);
        if (!invTrnDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + masId);
        }
        invTrnDTOOptional.get().setDocStatus(UdcEnum.INV_TRN_STATUS_RJ.getValueCode());
        InvTrn invTrn = InvTrnConvert.INSTANCE.dtoToInvTrn(invTrnDTOOptional.get());
        invTrnDomainService.create(invTrn);
        // 拒绝之后需要释放库存
//        releasLockQty(masId, null);
    }

    /**
     * 释放锁定量调用公共方法37
     *
     * @param masId
     * @param invTrnAndTrnDVOList
     */
    public void releasLockQty(Long masId, List<InvTrnAndTrnDTO> invTrnAndTrnDVOList) {
        val param = new InvTrnAllQueryParamVO();
        param.setMasId(masId);
        if (CollectionUtils.isEmpty(invTrnAndTrnDVOList)) {
            invTrnAndTrnDVOList = invTrnDDomainService.findAll(param);
        }
        val common37InvoList = invTrnAndTrnDVOList.stream().map(v -> {
            InvStkCommon37InSaveVO tmp = InvCommonConvert.INSTANCE.InvTrnAndTrnDRespVOToInvStkCommon37InVO(v);
            tmp.setInvStk28Enum1(InvStk28Enum.T_TYPE_25);
            tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            tmp.setOpDate(LocalDateTime.now());
            tmp.setReasonCode(v.getReasonCode());
            return tmp;
        }).collect(Collectors.toList());
        //释放锁定量 共通37
        invStkCommonService.invStkCommon37(common37InvoList);
    }

    /**
     * 释放在途功能区锁定量
     *
     * @param masId
     * @param invTrnAndTrnDVOList
     */
    public void releasTranLockQty(Long masId, List<InvTrnAndTrnDTO> invTrnAndTrnDVOList) {
        val param = new InvTrnAllQueryParamVO();
        param.setMasId(masId);
        if (CollectionUtils.isEmpty(invTrnAndTrnDVOList)) {
            invTrnAndTrnDVOList = invTrnDDomainService.findAll(param);
        }
        val common37InvoList = invTrnAndTrnDVOList.stream().map(v -> {
            v.setTranDeter2(UdcEnum.INV_FUNC_TYPE_9.getValueCode());
            InvStkCommon37InSaveVO tmp = InvCommonConvert.INSTANCE.InvTrnAndTrnDRespVOToInvStkCommon37InTranVO(v);
            tmp.setInvStk28Enum1(InvStk28Enum.T_TYPE_25);
            tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            tmp.setOpDate(LocalDateTime.now());
            tmp.setReasonCode(v.getReasonCode());
            return tmp;
        }).collect(Collectors.toList());
        //释放锁定量 共通37
        invStkCommonService.invStkCommon37(common37InvoList);
    }

    public List<InvTrnAndTrnRespVO> fillupNameList(List<InvTrnAndTrnRespVO> items) {
        Map<String, String> trnStatusMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_TRN_STATUS_DR.getModel(), UdcEnum.INV_TRN_STATUS_DR.getCode());
        Map<String, String> reasonMap = systemService.sysUdcGetCodeMap(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode());
        List<String> odeter2s = items.stream().filter(i -> i.getODeter2() != null).map(InvTrnAndTrnRespVO::getODeter2).distinct().collect(Collectors.toList());
        List<String> ideter2s = items.stream().filter(i -> i.getIDeter2() != null).map(InvTrnAndTrnRespVO::getIDeter2).distinct().collect(Collectors.toList());
        ideter2s.addAll(odeter2s);
        Map<String, String> uomMap = systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        List<Long> ouIdList = items.stream().filter(f -> f.getOuId() != null).map(InvTrnAndTrnRespVO::getOuId).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> orgOuVOS = orgOutService.findOuByIds(ouIdList);
        // 商品
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        List<Long> itemIds = items.stream().filter(f -> f.getItemId() != null).map(InvTrnAndTrnRespVO::getItemId).distinct().collect(Collectors.toList());
        itmItemPartParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemPartDTOS = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        // 仓库
        List<Long> iwhIdList = items.stream().filter(f -> f.getIWhId() != null).map(InvTrnAndTrnRespVO::getIWhId).distinct().collect(Collectors.toList());
        List<Long> owhIdList = items.stream().filter(f -> f.getIWhId() != null).map(InvTrnAndTrnRespVO::getOWhId).distinct().collect(Collectors.toList());
        iwhIdList.addAll(owhIdList);
        List<InvWhRespVO> invWhRespVOS = invWhDomainService.findIdBatch(iwhIdList);
        List<Long> userIds = items.stream().filter(Objects::nonNull).map(InvTrnAndTrnRespVO::getCreateUserId).collect(Collectors.toList());
        List<SysUserVO> empsByIdIn = systemService.findAllEmpsByIdIn(userIds);
        InvWhAreaParamVO paramVO = new InvWhAreaParamVO();
        paramVO.setDeter2s(ideter2s);
        paramVO.setWhIds(iwhIdList);
        List<InvWhAreaRespVO> whAreaRespVOS = whAreaDomainService.findWhAreasByParam(paramVO);
        items.forEach(i -> {
            //品项
            if (!CollectionUtils.isEmpty(itmItemPartDTOS)) {
                itmItemPartDTOS.stream().filter(f -> f.getId().equals(i.getItemId())).findFirst().ifPresent(e -> {
                    i.setItemCode(e.getItemCode());
                    i.setItemName(e.getItemName());
                    i.setBrand(e.getBrand());
                    i.setBrandName(e.getBrandName());
                });
            }
            if (!CollectionUtils.isEmpty(empsByIdIn)) {
                empsByIdIn.stream().filter(u -> u.getId().equals(i.getCreateUserId())).findFirst().ifPresent(v -> {
                    i.setCreateUserName(v.getUsername());
                });
            }
            // 仓库
            if (!CollectionUtils.isEmpty(invWhRespVOS)) {
                invWhRespVOS.stream().filter(f -> f.getId().equals(i.getIWhId())).findFirst().ifPresent(w -> {
                    i.setIWhCode(w.getWhCode());
                    i.setIWhName(w.getWhName());
                });
                invWhRespVOS.stream().filter(f -> f.getId().equals(i.getOWhId())).findFirst().ifPresent(w -> {
                    i.setOWhCode(w.getWhCode());
                    i.setOWhName(w.getWhName());
                });
            }
            // 公司
            if (!CollectionUtils.isEmpty(orgOuVOS)) {
                orgOuVOS.stream().filter(f -> f.getId().equals(i.getOuId())).findFirst().ifPresent(o -> {
                    i.setOuName(o.getOuName());
                    i.setOuCode(o.getOuCode());
                });
            }
            if (!CollectionUtils.isEmpty(trnStatusMap) && trnStatusMap.containsKey(i.getDocStatus())) {
                i.setDocStatusName(trnStatusMap.get(i.getDocStatus()));
            }
            if (!CollectionUtils.isEmpty(reasonMap) && reasonMap.containsKey(i.getReasonCode())) {
                i.setReasonCodeName(reasonMap.get(i.getReasonCode()));
            }
            if (!CollectionUtils.isEmpty(whAreaRespVOS)) {
                whAreaRespVOS.stream().filter(wharea -> wharea.getDeter2()
                        .equals(i.getODeter2()) && wharea.getWhId().equals(i.getOWhId())
                ).findAny().ifPresent( m ->{
                    i.setODeter2Name(m.getDeter2Name());
                });
                whAreaRespVOS.stream().filter(wharea -> wharea.getDeter2()
                        .equals(i.getIDeter2()) && wharea.getWhId().equals(i.getIWhId())
                ).findAny().ifPresent( m ->{
                    i.setIDeter2Name(m.getDeter2Name());
                });
            }
            if (!CollectionUtils.isEmpty(uomMap) && uomMap.containsKey(i.getUom())) {
                i.setUomName(uomMap.get(i.getUom()));
            }
        });
        return items;
    }


}
