package com.elitesland.yst.production.inv.application.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.*;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvStkCommonService;
import com.elitesland.yst.production.inv.application.service.InvTrnService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.convert.InvTrnConvert;
import com.elitesland.yst.production.inv.domain.convert.InvTrnDConvert;
import com.elitesland.yst.production.inv.domain.entity.invtrn.InvTrn;
import com.elitesland.yst.production.inv.domain.service.InvTrnDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvTrnDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.entity.InvTrnDDO;
import com.elitesland.yst.production.inv.entity.InvTrnDO;
import com.elitesland.yst.production.inv.entity.QInvTrnDO;
import com.elitesland.yst.production.inv.enums.InvStkSceneCodeEnum;
import com.elitesland.yst.production.inv.enums.ProcDefKey;
import com.elitesland.yst.production.inv.infr.dto.*;
import com.elitesland.yst.production.inv.infr.repo.InvTrnDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvTrnRepo;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.utils.ValidationUtil;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.util.concurrent.AtomicDouble;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class InvTrnServiceImpl implements InvTrnService {

    private final InvTrnDomainService invTrnDomainService;

    private final InvTrnDDomainService invTrnDDomainService;

    private final SystemService systemService;

    private final InvTrnDRepo invTrnDRepo;

    private final InvTrnRepo invTrnRepo;

    private final OrgOutService orgOutService;

    private final ItmOutService itmOutService;

    private final InvWhAreaService invWhAreaService;

    private final InvWhDomainService invWhDomainService;

    private final InvWhService invWhService;

    private final InvStkOptBizService invStkOptBizService;

    private final JPAQueryFactory jpaQueryFactory;

    private final WorkflowService workflowService;

    private final InvStkCommonService invStkCommonService;



    @Override
    public Long saveInvTrnInfo(InvTrnAndTrnDSaveVO inv) {
        ArrayList<String> runtimeValues = new ArrayList<>();
        InvTrnSaveVO invHeader = inv.getHeader();
        // 仓库设置校验
        if (StrUtil.equals(inv.getHeader().getReasonCode(), UdcEnum.INV_REASON_CODE_TRANS_201.getValueCode())) {
            if (ObjectUtil.equals(invHeader.getIWhId(), invHeader.getOWhId())) {
                throw new BusinessException(ApiCode.FAIL, "跨库调货，【发货/收货仓库】相同，请修改！");
            }
        }else if(StrUtil.equals(inv.getHeader().getReasonCode(), UdcEnum.INV_REASON_CODE_TRANS_202.getValueCode())){
            if (ObjectUtil.notEqual(invHeader.getIWhId(), invHeader.getOWhId())) {
                throw new BusinessException(ApiCode.FAIL, "同仓调拨，【发货/收货仓库】不同，请修改！");
            }
        }
        invHeader.setODeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
        invHeader.setIDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
        //校验必填项
        saveCheckIn(invHeader,inv.getDetails());
        InvTrnSaveVO invTrnSaveVO = new InvTrnSaveVO();
        invHeader.setDocStatus(UdcEnum.INV_TRN_STATUS_DR.getValueCode());
        invHeader.setDocType(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
        BeanUtils.copyProperties(invHeader, invTrnSaveVO);
        if(inv.getHeader().getId() != null)  {
            if(UdcEnum.INV_TRN_STATUS_APPING.getValueCode().equals(inv.getHeader().getDocStatus())
                    || UdcEnum.INV_TRN_STATUS_APPED.getValueCode().equals(inv.getHeader().getDocStatus()) ){
                throw new BusinessException(ApiCode.FAIL,"已审批或在审批中的单据不能保存，请检查");
            }
            Optional<InvTrnDTO> invTrnDTOOptional = invTrnDomainService.findIdOne(inv.getHeader().getId());
            if(invTrnDTOOptional.isPresent()){
                String procInstId = invTrnDTOOptional.get().getProcInstId();
                invTrnSaveVO.setProcInstId(procInstId);
                invTrnSaveVO.setDocNo(invTrnDTOOptional.get().getDocNo());
                invTrnSaveVO.setApprComment(invTrnDTOOptional.get().getApprComment());
                invTrnSaveVO.setProcInstStatus(invTrnDTOOptional.get().getProcInstStatus());
                invTrnSaveVO.setSubmitTime(invTrnDTOOptional.get().getSubmitTime());
            } else{
                throw new BusinessException(ApiCode.FAIL,String.format("单据【%s】不存在，请检查",inv.getHeader().getDocNo()));
            }
        }else{
            invHeader.setDocStatus(UdcEnum.INV_TRN_STATUS_DR.getValueCode());
            runtimeValues.add(invHeader.getOuCode());
            val code = systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_IT.getCode(), runtimeValues);
            invTrnSaveVO.setDocNo(inv.getHeader().getDocNo() != null ? inv.getHeader().getDocNo() : code);
        }
        invTrnSaveVO.setCreateTime(LocalDateTime.now());
        InvTrn invTrn = InvTrnConvert.INSTANCE.saveVOToInvTrn(invTrnSaveVO);
        val id = invTrnDomainService.create(invTrn);
        if (!CollectionUtils.isEmpty(inv.getDetails())) {
            if(inv.getHeader().getId() != null){
                List<InvTrnDDTO> invTrnDDTOS = invTrnDDomainService.findByMasId(inv.getHeader().getId());
                if(!CollectionUtils.isEmpty(invTrnDDTOS)){
                    List<Long> trndIds = invTrnDDTOS.stream().map(InvTrnDDTO::getId).collect(Collectors.toList());
                    invTrnDDomainService.deleteBatch(trndIds);
                }
            }
            List<Long> owhIds = inv.getDetails().stream().map(InvTrnDDetailRespVO::getOWhId).collect(Collectors.toList());
            List<Long> iwhIds = inv.getDetails().stream().map(InvTrnDDetailRespVO::getIWhId).collect(Collectors.toList());
            InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
            areaParamVO.setWhIds(owhIds);
            List<InvWhAreaRespVO> whAreasByParam1 = invWhAreaService.findWhAreasByParam(areaParamVO);
            areaParamVO.setWhIds(iwhIds);
            List<InvWhAreaRespVO> whAreasByParam2 = invWhAreaService.findWhAreasByParam(areaParamVO);
            AtomicDouble linoNo = new AtomicDouble(0);
            val detailDOs = inv.getDetails().stream().map(d -> {
                InvTrnDDO invTrnDDO = new InvTrnDDO();
                BeanUtils.copyProperties(d, invTrnDDO);
                invTrnDDO.setCreateTime(LocalDateTime.now());
                invTrnDDO.setMasId(id);
                invTrnDDO.setLineNo(linoNo.addAndGet(1));
                invTrnDDO.setIDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
                invTrnDDO.setODeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
                /*PriGroupParam param = new PriGroupParam();
                param.setItemId(d.getItemId());
                param.setDocTime(invTrnSaveVO.getIoDate());
                param.setFromOuId(invTrnSaveVO.getOOuId());
                param.setToOuId(invTrnSaveVO.getIOuId());*/
                //数据权限
                try{
                    GeneralUserDetails user = SecurityContextUtil.currentUser();
                    invTrnDDO.setSecBuId(invTrnSaveVO.getSecBuId() == null ? null :invTrnSaveVO.getSecBuId());
                    invTrnDDO.setSecOuId(invTrnSaveVO.getOOuId() == null ? null :invTrnSaveVO.getOOuId());
                }catch (Exception e){
                    log.error("无法获取当前登录人信息，请先登录：{}"+e.getMessage());
                }
                List<InvWhAreaRespVO> invWhAreaRespVOS = whAreasByParam2.stream().filter(v -> v.getWhId().equals(d.getIWhId())).collect(Collectors.toList());
                val deter2List = invWhAreaRespVOS.stream().map(InvWhAreaRespVO::getDeter2).collect(Collectors.toList());
                // 校验本仓库是否有对应功能区
                if (!deter2List.contains(d.getIDeter2())){
                    throw new BusinessException(ApiCode.FAIL, "至仓库没有" + d.getIDeter2Name() + "功能库区");
                }
                //校验仓库个人仓逻辑
                if(d.getOPCode() != null && d.getOPType() != null){
                    List<InvWhAreaRespVO> whAreaRespVOS = whAreasByParam1.stream().filter(v -> d.getOPType().equals(v.getPType()) && d.getOPCode().equals(v.getPCode())).collect(Collectors.toList());
                    if(CollectionUtils.isEmpty(whAreaRespVOS)){
                        throw new BusinessException(String.format("从仓库【%s】功能区【%s】合作伙伴【%s】不存在，请检查！",d.getOWhName(),d.getODeter2Name(),d.getOPName()));
                    }
                }
                if(d.getIPCode() != null && d.getIPType() != null){
                    List<InvWhAreaRespVO> whAreaRespVOS = whAreasByParam2.stream().filter(v -> d.getIPType().equals(v.getPType()) && d.getIPCode().equals(v.getPCode())).collect(Collectors.toList());
                    if(CollectionUtils.isEmpty(whAreaRespVOS)){
                        throw new BusinessException(String.format("至仓库【%s】功能区【%s】合作伙伴[%s]不存在，请检查！",d.getIWhName(),d.getIDeter2Name(),d.getIPName()));
                    }
                }
                return invTrnDDO;
            }).collect(Collectors.toList());
            invTrnDRepo.saveAll(detailDOs);
        }
        return id;
    }


    @Override
    @SysCodeProc
    public InvTrnDetailRespVO invTrnDetail(Long id) {
        Optional<InvTrnDTO> invTrnDTOOptional = invTrnDomainService.findIdOne(id);
        if (! invTrnDTOOptional.isPresent()){
            return null;
        }
        val oWh = invWhDomainService.findById(invTrnDTOOptional.get().getOWhId() != null ? invTrnDTOOptional.get().getOWhId() : 0L);
        val iWh = invWhDomainService.findById(invTrnDTOOptional.get().getIWhId() != null ? invTrnDTOOptional.get().getIWhId() : 0L);
        if (oWh.isPresent()) {
            invTrnDTOOptional.get().setOWhName(oWh.get().getWhName());
            invTrnDTOOptional.get().setOWhCode(oWh.get().getWhCode());
        }
        if (iWh.isPresent()) {
            invTrnDTOOptional.get().setIWhName(iWh.get().getWhName());
            invTrnDTOOptional.get().setIWhCode(iWh.get().getWhCode());
        }
        InvTrnDetailRespVO invTrnDetailRespVO = InvTrnConvert.INSTANCE.trnDTOToDetailRespVO(invTrnDTOOptional.get());
        InvTrnAllQueryParamVO queryParamVO = new InvTrnAllQueryParamVO();
        queryParamVO.setMasId(invTrnDTOOptional.get().getId());
        List<String> deter2s = new ArrayList<>();
        List<Long> whIds = new ArrayList<>();
        deter2s.add(invTrnDetailRespVO.getODeter2());
        deter2s.add(invTrnDetailRespVO.getIDeter2());
        whIds.add(invTrnDTOOptional.get().getOWhId());
        whIds.add(invTrnDTOOptional.get().getIWhId());
        InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
        areaParamVO.setDeter2s(deter2s);
        areaParamVO.setWhIds(whIds);
        List<InvWhAreaRespVO> whAreaRespVOS = invWhAreaService.findWhAreasByParam(areaParamVO);
        invTrnDetailRespVO.setDocStatusName(getUdcDesc(UdcEnum.INV_TRN_STATUS_DR.getModel(), UdcEnum.INV_TRN_STATUS_DR.getCode(),invTrnDTOOptional.get().getDocStatus()));
        invTrnDetailRespVO.setReasonCodeName(getUdcDesc(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode(),invTrnDetailRespVO.getReasonCode()));
        Map<String, String> pTypeMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_EMP.getModel(), UdcEnum.INV_PARTNER_TYPE_EMP.getCode());
        if(!CollectionUtils.isEmpty(whAreaRespVOS)){
            whAreaRespVOS.stream().filter(w -> w.getDeter2().equals(invTrnDetailRespVO.getODeter2()) &&
                    w.getWhId().equals(invTrnDetailRespVO.getOWhId())).findAny().ifPresent(m ->{
                invTrnDetailRespVO.setODeter2Name(m.getDeter2Name());
            });
            whAreaRespVOS.stream().filter(w -> w.getDeter2().equals(invTrnDetailRespVO.getIDeter2()) &&
                    w.getWhId().equals(invTrnDetailRespVO.getIWhId())).findAny().ifPresent(m ->{
                invTrnDetailRespVO.setIDeter2Name(m.getDeter2Name());
            });
        }
        Long ouId = invTrnDetailRespVO.getOuId();
        OrgOuRpcDTO orgOuRpcDTO = orgOutService.findOuById(ouId);
        if(orgOuRpcDTO != null) {
            invTrnDetailRespVO.setOuCode(orgOuRpcDTO.getOuCode());
            invTrnDetailRespVO.setOuName(orgOuRpcDTO.getOuName());
        }
        //发起人默认系统用户
        Long userId = invTrnDetailRespVO.getCreateUserId();
        if(userId != null) {
            ArrayList<Long> list = new ArrayList<>();
            list.add(userId);
            List<SysUserVO> sysUsers = systemService.findAllEmpsByIdIn(list);
            if(!CollectionUtils.isEmpty(sysUsers)){
                SysUserVO userVO = sysUsers.get(0);
                invTrnDetailRespVO.setCreateUserName(userVO.getUsername());
            }
        }
        List<InvTrnAndTrnDTO> domainServiceAll = invTrnDDomainService.findAll(queryParamVO);
        if (!CollectionUtils.isEmpty(domainServiceAll)){
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            List<Long> itemIds = domainServiceAll.stream().filter(f -> f.getItemId() != null).map(InvTrnAndTrnDTO::getItemId).collect(Collectors.toList());
            itmItemPartParam.setItemIds(itemIds);
            List<ItmItemRpcDTO> itmItemPartDTOS = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
            Map<String, String> udcUom = systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());//单位
            List<InvTrnDRespVO> invTrnDRespVOList = domainServiceAll.stream().map(e -> {
                InvTrnDRespVO invTrnDRespVO = InvTrnDConvert.INSTANCE.dtoToRespVO(e);
                invTrnDRespVO.setIWhName(invTrnDetailRespVO.getIWhName());
                invTrnDRespVO.setOWhName(invTrnDetailRespVO.getOWhName());
                invTrnDRespVO.setODeter2Name(invTrnDetailRespVO.getODeter2Name());
                invTrnDRespVO.setIDeter2Name(invTrnDetailRespVO.getIDeter2Name());
                // 手动设置重量单位
                if (e.getUom() != null && MapUtils.isNotEmpty(udcUom)) {
                    invTrnDRespVO.setUomName(udcUom.get(e.getUom()));
                }
                // 商品编码、名称转换
                if (!CollectionUtils.isEmpty(itmItemPartDTOS)){
                    itmItemPartDTOS.stream().filter(f -> f.getId().equals(e.getItemId())).findFirst().ifPresent(i -> {
                        invTrnDRespVO.setItemCode(i.getItemCode());
                        invTrnDRespVO.setItemName(i.getItemName());
                        invTrnDRespVO.setLotFlag(i.getLotFlag());
                        invTrnDRespVO.setBrandCode(i.getBrand());
                        invTrnDRespVO.setBrandName(i.getBrandName());
                        invTrnDRespVO.setPackageSpec(i.getPackageSpec()); //规格
                    });
                }

                //库存合作伙伴查询
                if (e.getOPType() != null && e.getOPCode() != null) {
                    InvParentParamVO paramVO = new InvParentParamVO();
                    paramVO.setCode(invTrnDRespVO.getOPCode());
                    paramVO.setType(invTrnDRespVO.getOPType());
                    List<OrgRespVO> vos = orgOutService.findcodeAndName(paramVO);
                    if (!CollectionUtils.isEmpty(vos)) {
                        invTrnDRespVO.setOPName(vos.get(0).getName());
                    }
                }
                if (invTrnDRespVO.getIPType() != null && e.getIPCode() != null) {
                    InvParentParamVO paramVO = new InvParentParamVO();
                    paramVO.setCode(invTrnDRespVO.getIPCode());
                    paramVO.setType(invTrnDRespVO.getIPType());
                    List<OrgRespVO> vos = orgOutService.findcodeAndName(paramVO);
                    if (!CollectionUtils.isEmpty(vos)) {
                        invTrnDRespVO.setIPName(vos.get(0).getName());
                    }
                }

                if(!MapUtils.isEmpty(pTypeMap)){
                    invTrnDRespVO.setIPTypeName(pTypeMap.get(invTrnDRespVO.getIPType()));
                }

                if(!MapUtils.isEmpty(pTypeMap)){
                    invTrnDRespVO.setOPTypeName(pTypeMap.get(invTrnDRespVO.getOPType()));
                }

                // 库存可供量查询
                invTrnDRespVO.setAvalQty(getAvalQty(e));
                return invTrnDRespVO;
            }).collect(Collectors.toList());
            invTrnDetailRespVO.setInvTrnDRespVOList(invTrnDRespVOList);
        }
        return invTrnDetailRespVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long  submit(Long id) {
        SysUserDTO user = systemService.sysUserCurrent();
        if (user == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法到获取当前用户");
        }
        Optional<InvTrnDO> invTrnVOOptional = invTrnRepo.findById(id);
        if (!invTrnVOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + id);
        }
        try {
            //开启工作流
            if (
                    invTrnVOOptional.get().getProcInstId() == null
                            || WorkflowConstant.CAN_START_PROC_STATUSES.contains(invTrnVOOptional.get().getProcInstStatus())
            ) {
                Long ouId = invTrnVOOptional.get().getOuId();
                OrgOuRpcDTO orgOuRpcDTO = orgOutService.findOuById(ouId);
                if (orgOuRpcDTO != null) {
                    //分子公司间仓库间转移
                    String procInstName = ProcDefKey.INV_TRN.getDesc() + invTrnVOOptional.get().getDocNo();
                    this.startWorkFlow(ProcDefKey.INV_TRN.name(), procInstName, invTrnVOOptional.get().getId() + "", user.getId() + "", id);
                } else {
                    throw new BusinessException("公司不存在，请检查");
                }
            } else {
                invTrnVOOptional.get().setDocStatus(UdcEnum.INV_TRN_STATUS_APPING.getValueCode());
                invTrnVOOptional.get().setIoDate(LocalDateTime.now()); // 交易日期为单据提交日期
                invTrnRepo.save(invTrnVOOptional.get());
            }
        } catch (Exception e){
            throw new BusinessException(ApiCode.FAIL,"提交失败"+e.getMessage());
        }
        return id;

    }

    private InvStkCommonOperateDTO getInvStkCommonOperateDTO(List<InvTrnDDO> invTrnDRespVOS, InvTrnDO invTrnDO, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-",""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<>();
        invTrnDRespVOS.stream().forEach(invTrnDRespVo -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invTrnDRespVo.getOWhId());
            operateBodyDTO.setItemId(invTrnDRespVo.getItemId());
            operateBodyDTO.setDeter2(invTrnDRespVo.getODeter2());
            operateBodyDTO.setSrcDocId(invTrnDO.getId());
            operateBodyDTO.setDocNo(invTrnDO.getDocNo());
            operateBodyDTO.setSrcDocDid(invTrnDRespVo.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            operateBodyDTO.setLineNo(invTrnDRespVo.getLineNo());
            operateBodyDTO.setCreateUserId(invTrnDO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invTrnDRespVo.getUom());
            operateBodyDTO.setQty(invTrnDRespVo.getQty());
            operateBodyDTO.setLotNo(invTrnDRespVo.getLotNo());
            operateBodyDTO.setPCode(invTrnDRespVo.getOPCode());
            operateBodyDTO.setPType(invTrnDRespVo.getOPType());
            operateBodyDTO.setOuId(invTrnDRespVo.getOuId());
            operateBodyDTO.setVariId(invTrnDRespVo.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        operateDTO.setSourceBodyList(operateBodyDTOS);
        return operateDTO;

    }


    private void startWorkFlow(String processDefinitionKey,String procInstName, String businessKey,String currentUserId,Long id){
        try {
            WorkflowResult<ProcessInfo> processInfoWorkflowResult = workflowService.startProcess(StartProcessPayload.of(processDefinitionKey, procInstName, businessKey, null));
            log.info("库存转移启动流程返回:" + processInfoWorkflowResult.getData());
            if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
                throw new BusinessException("调用工作流异常，错误信息:" + processInfoWorkflowResult.getMsg());
            }
            QInvTrnDO qInvTrnDO = QInvTrnDO.invTrnDO;
            JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qInvTrnDO)
                    .set(qInvTrnDO.procInstId, processInfoWorkflowResult.getData().getProcInstId())
                    .set(qInvTrnDO.submitTime, LocalDateTime.now())
                    .set(qInvTrnDO.ioDate,LocalDateTime.now())
                    .where(qInvTrnDO.id.eq(id));
            if (!Objects.equals(processInfoWorkflowResult.getData().getProcInstStatus(), ProcInstStatus.APPROVED)) {
                jpaUpdateClause.set(qInvTrnDO.procInstStatus, ProcInstStatus.APPROVING);
                jpaUpdateClause.set(qInvTrnDO.docStatus, UdcEnum.INV_TRN_STATUS_APPING.getValueCode());
            }
            jpaUpdateClause.execute();
        } catch (Exception e){
            throw new BusinessException(ApiCode.FAIL,"开启工作流服务失败:"+e.getMessage());
        }



    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<Long> updateStatusInBatch(List<Long> ids, String status) {
        invTrnDomainService.updateDocStatusByIds(ids,status);
        return ids;
    }

    private BigDecimal getAvalQty(InvTrnAndTrnDTO invTrnAndTrnDRespVO){
        val invStkParam = new InvBaseModel();
        invStkParam.setItemId(invTrnAndTrnDRespVO.getItemId());
        invStkParam.setWhId(invTrnAndTrnDRespVO.getOWhId());
        invStkParam.setVariId(invTrnAndTrnDRespVO.getVariId());
        invStkParam.setLotNo(invTrnAndTrnDRespVO.getLotNo());
        invStkParam.setDeter2(invTrnAndTrnDRespVO.getODeter2());
        val invStk = invStkCommonService.getInvGroupStk(invStkParam);
        if (invStk != null){
            return invStk.getAvalQty();
        }
        return null;
    }


    private String getUdcDesc(String domain, String udcCode,String udcVal){
        if (StringUtils.isEmpty(domain) || StringUtils.isEmpty(udcCode)){
            return null;
        }
        Map<String, String> codeMap = systemService.sysUdcGetCodeMap(domain, udcCode);
        if (CollectionUtils.isEmpty(codeMap)){
            return null;
        }
        if (codeMap.containsKey(udcVal)){
            return codeMap.get(udcVal);
        }
        return null;
    }

    public void saveCheckIn(InvTrnSaveVO invTrnSaveVO, List<InvTrnDDetailRespVO> invTrnDDetailRespVOS){
        // 必填参数校验
        ValidationUtil.ValidResult validResult = ValidationUtil.validate(invTrnSaveVO);
        if (validResult.isError()) {
            throw new BusinessException("主数据参数错误，移库原因、申请日期、从仓库、至仓库、从功能库区、至功能库区不能为空");
        }
        ValidationUtil.ValidResult validResult2 = ValidationUtil.validate(invTrnDDetailRespVOS);
        if (validResult2.isError()) {
            throw new BusinessException("明细数据参数错误，从功能库区、至功能库区、转移数量、从仓库、至仓库 不能为空");
        }
        //仓库公司校验
        if(!invTrnSaveVO.getOOuId().toString().equals(invTrnSaveVO.getIOuId().toString())){
            throw new BusinessException("移入和移出仓库公司非同一公司请检查！");
        }

        //仓库在途功能区校验
//        val whAreaList = invWhAreaService.findAllByWhId(invTrnDDetailRespVOS.stream().map(InvTrnDDetailRespVO::getOWhId).collect(Collectors.toList()));
//        long count = whAreaList.stream().filter(v -> UdcEnum.INV_FUNC_TYPE_9.getValueCode().equals(v.getDeter2())).distinct().count();
//        if(count <1){
//            throw new BusinessException("从仓库"+ invTrnSaveVO.getOWhCode()+"没有默认在途功能区，请检查！");
//        }
        //明细行校验
        long count2 = invTrnDDetailRespVOS.stream().map(v -> v.getItemId()+v.getOWhId()+"_" + v.getODeter2()+v.getIWhId()+"_"+v.getIDeter2()+"_"
                + v.getIPCode() + "_" + v.getIPType() + "_"
                + v.getOPCode() + "_" +v.getOPType()).distinct().count();
        if(count2 != invTrnDDetailRespVOS.size()){
            throw new BusinessException("明细数据参数错误，商品ID,从仓库/从功能区,至功能区/至功能库区存在相同数据，请检查");
        }

        List<InvWhRespVO> oWhRespVOS = invWhService.findIdBatch(invTrnDDetailRespVOS.stream().map(InvTrnDDetailRespVO::getOWhId).collect(Collectors.toList()));
        List<InvWhRespVO> iWhRespVOS = invWhService.findIdBatch(invTrnDDetailRespVOS.stream().map(InvTrnDDetailRespVO::getIWhId).collect(Collectors.toList()));
        oWhRespVOS.forEach(o ->{
            List<InvWhRespVO> vos = iWhRespVOS.stream().filter(i -> !o.getOuId().equals(i.getOuId())).collect(Collectors.toList());
            if(vos.size() > 0){
                throw new BusinessException("移入和移出仓库非同一公司！请检查");
            }
        });

    }

    @Override
    @Transactional
    public Long check(Long masId) {
        Optional<InvTrnDO> invTrnVOOptional = invTrnRepo.findById(masId);
        if (!invTrnVOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + masId);
        }
        if(! UdcEnum.INV_TRN_STATUS_APPING.getValueCode().equals(invTrnVOOptional.get().getDocStatus())){
            throw new BusinessException(ApiCode.FAIL, "请选择状态为审核中的单据" + masId);
        }
        invTrnVOOptional.get().setProcInstStatus(ProcInstStatus.APPROVED);
        invTrnVOOptional.get().setApprStatus(UdcEnum.INV_TRN_STATUS_APPED.getValueCode());
        invTrnVOOptional.get().setDocStatus(UdcEnum.INV_TRN_STATUS_APPED.getValueCode());
        invTrnRepo.save(invTrnVOOptional.get());
        //锁定库存
        List<InvTrnDDO> invTrnDDOS = invTrnDRepo.findByMasId(masId);
        InvStkCommonOperateDTO invStkCommonOperateDTO = getInvStkCommonOperateDTO(invTrnDDOS, invTrnVOOptional.get(), InvStkSceneCodeEnum.INV_TRN_TRN001.getType());
        invStkOptBizService.invStkCommonOperate(invStkCommonOperateDTO);
        return masId;

    }

    @Override
    @Transactional
    public void refuse(Long masId) {
        Optional<InvTrnDTO> invTrnDTOOptional = invTrnDomainService.findIdOne(masId);
        if (!invTrnDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + masId);
        }

        invTrnDTOOptional.get().setDocStatus(UdcEnum.INV_TRN_STATUS_RJ.getValueCode());
        InvTrn invTrn = InvTrnConvert.INSTANCE.dtoToInvTrn(invTrnDTOOptional.get());
        invTrnDomainService.create(invTrn);
    }

}
