package com.elitesland.yst.production.inv.application.service.stk.impl;

import com.elitesland.yst.production.inv.application.service.stk.AbstractInvStkOptService;
import com.elitesland.yst.production.inv.application.service.stk.InvOptCode;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptService;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkDO;
import com.elitesland.yst.production.inv.enums.InvOptEnum;
import com.elitesland.yst.production.inv.infr.dto.InvSceneConfigDtlDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author Tom.su
 * @program yst-inv
 * @description 库存锁定减
 * @date 2022/04/25 10:27
 */
@Slf4j
@Service
@InvOptCode(value = InvOptEnum.INV_IO_TYPE_T)
public class InvStkOptForTServiceImpl extends AbstractInvStkOptService implements InvStkOptService {
    @Override
    protected BigDecimal setInvIoQty(BigDecimal qty) {
        return BigDecimal.ZERO.subtract(qty);
    }

    @Override
    protected void updateQty(InvStkDO invStkDO, BigDecimal qty) {
        invStkDO.setLockQty(setQty(qty));
    }

    @Override
    protected void convertDeter2(InvSceneConfigDtlDTO config, List<InvStkCommonOperateBodyDTO> param) {
        param.forEach(dtl -> super.convertDeter2( config.getDeter2(), dtl));
    }

    @Override
    protected void convertDocNo(InvSceneConfigDtlDTO config, List<InvStkCommonOperateBodyDTO> param) {
        param.forEach(dtl -> super.convertDocNo(config.getIsUseRelDoc(),dtl));
    }
}