package com.elitesland.yst.production.inv.application.web.controller;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.CommonSaveVo;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigWhPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigDtlQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigQueryParam;
import com.elitesland.yst.production.inv.application.service.InvDespatchConfigService;
import com.elitesland.yst.production.inv.constant.InvBusinessObjectConstants;
import com.elitesland.yst.production.inv.domain.entity.despatch.InvDespatchConfigDO;
import com.elitesland.yst.production.support.provider.constant.SupportBusinessObjectConstants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 01月 04日 5:10 下午
 * @version: 1.0
 */
@RestController
@RequestMapping("/inv/despatch")
@Api(value = "发运地配置", tags = {"发运地管理"})
@AllArgsConstructor
@BusinessObject(businessType = InvBusinessObjectConstants.INV_DESPATCH_CONFIG, businessDoClass = InvDespatchConfigDO.class)
public class InvDespatchConfigController {

    private final InvDespatchConfigService invDespatchConfigService;

    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "销售组织列表",
            businessObjectType = InvBusinessObjectConstants.INV_DESPATCH_CONFIG,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    @PostMapping("/searchPage")
    @ApiOperation("发运地配置-分页查询")
    public ApiResult<PagingVO<InvDespatchConfigPageVO>> page(@RequestBody InvDespatchConfigQueryParam param) {
        val ret = invDespatchConfigService.searchPage(param);
        return ApiResult.ok(ret);
    }

    @PostMapping("/save")
    @ApiOperation("发运地配置-保存/更新")
    public ApiResult<Long> save(@RequestBody InvDespatchConfigSaveVO createParam) {
        return ApiResult.ok(invDespatchConfigService.saveOrUpdate(createParam));
    }

    @GetMapping("/header/{id}")
    @ApiOperation("发运地配置-详情")
    public ApiResult<InvDespatchConfigRespVO> getDetail(@PathVariable("id") Long id) {
        return ApiResult.ok(invDespatchConfigService.findIdOne(id));
    }

    @PostMapping("/pageDetails")
    @ApiOperation("发运地配置-绑定仓库信息")
    public ApiResult<PagingVO<InvDespatchConfigWhPageVO>> searchDtlPage(@RequestBody InvDespatchConfigDtlQueryParam param) {
        return ApiResult.ok(invDespatchConfigService.searchDtlPage(param));
    }

    @PutMapping("/enable")
    @ApiOperation("发运地配置-启用/禁用")
    public ApiResult<Boolean> enableDespatchConfig(@RequestBody CommonSaveVo<Long> id) {
        return ApiResult.ok(invDespatchConfigService.enableDespatchConfig(id.getDtls(),id.getStatus()));
    }

    @PostMapping("/select/listDespatch")
    @ApiOperation("发运地配置-（前端）下拉查询")
    public ApiResult<List<SelectOptionVO>> listDespatch(@RequestBody SelectOptionParam selectOptionParam) {
        return ApiResult.ok(invDespatchConfigService.listDespatchConfig(selectOptionParam));
    }

}
