package com.elitesland.yst.production.inv.domain.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author jeesie.jiang
 * @date 2022-03-30 15:58
 * Desc: 库内组装明细
 */
@Entity
@Table(name = "inv_asm_d")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "inv_asm_d", comment = "库内组装明细")
@Data
@Accessors(chain = true)
@ApiModel(value = "INV_ASM_D", description = "库内组装明细")
public class InvAsmDDO extends BaseModel implements Serializable
{
    @ApiModelProperty("主表ID")
    @Column(name="mas_id" , columnDefinition = "bigint(20)  comment '主表ID'")
    Long masId;

    @ApiModelProperty("行号")
    @Column(columnDefinition = "NUMERIC(20,3)   comment '行号'")
    Double lineNo;

    @ApiModelProperty("行状态")
    @Column(name="line_status" , columnDefinition = "varchar(40)  comment '行状态'")
    String lineStatus;

    @ApiModelProperty("行类型 [UDC]COM:IO")
    @Column(name="line_type" , columnDefinition = "varchar(40)  comment '行类型 [UDC]COM:IO'")
    String lineType;

    @ApiModelProperty("品项ID")
    @Column(name="item_id" , columnDefinition = "bigint(20)  comment '品项ID'")
    Long itemId;

    @ApiModelProperty("异构ID")
    @Column(name="vari_id" , columnDefinition = "bigint(20)  comment '异构ID'")
    Long variId;

    @ApiModelProperty("批次")
    @Column(name="lot_no" , columnDefinition = "varchar(40)  comment '批次'")
    String lotNo;

    @ApiModelProperty("序列号")
    @Column(name="sn_no" , columnDefinition = "varchar(40)  comment '序列号'")
    String snNo;

    @ApiModelProperty("数量")
    @Column(name="qty" , columnDefinition = "NUMERIC(20,8)  comment '数量'")
    BigDecimal qty;

    @ApiModelProperty("单位")
    @Column(name="uom" , columnDefinition = "varchar(10)  comment '单位'")
    String uom;

    @ApiModelProperty("数量2")
    @Column(name="qty2" , columnDefinition = "NUMERIC(20,8) comment '数量2'")
    BigDecimal qty2;

    @ApiModelProperty("单位2")
    @Column(name="uom2" , columnDefinition = "varchar(10)  comment '单位2'")
    String uom2;

    @ApiModelProperty("单位转换率")
    @Column(name="uom_ratio" , columnDefinition = "float(20,8)   comment '单位转换率'")
    Float uomRatio;

    @ApiModelProperty("单位转换率2")
    @Column(name="uom_ratio2" , columnDefinition = "float(20,8)   comment '单位转换率2'")
    Float uomRatio2;

    @ApiModelProperty("生产日期")
    @Column()
    @Comment("生产日期")
    LocalDateTime manuDate;

    @ApiModelProperty("生产批次")
    @Column(name="manu_lot_no" , columnDefinition = "varchar(40)  comment '生产批次'")
    String manuLotNo;

    @ApiModelProperty("失效日期")
    @Column()
    @Comment("失效日期")
    LocalDateTime expireDate;

    @ApiModelProperty("税额")
    @Column(name="tax_amt" , columnDefinition = "NUMERIC(20,4)   comment '税额'")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    @Column(name="amt" , columnDefinition = "NUMERIC(20,4)   comment '含税金额'")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    @Column(name="net_amt" , columnDefinition = "NUMERIC(20,4)   comment '不含税金额'")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    @Column(name="home_curr" , columnDefinition = "varchar(10)  comment '记账币种'")
    String homeCurr;

    @ApiModelProperty("交易币种")
    @Column(name="curr_code" , columnDefinition = "varchar(10)  comment '交易币种'")
    String currCode;

    @ApiModelProperty("汇率")
    @Column(name="curr_rate" , columnDefinition = "NUMERIC(20,8) comment '汇率'")
    Float currRate;

    @ApiModelProperty("外币不含税金额")
    @Column(name="curr_net_amt" , columnDefinition = "NUMERIC(20,4)   comment '外币不含税金额'")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    @Column(name="curr_amt" , columnDefinition = "NUMERIC(20,4)    comment '外币含税金额'")
    BigDecimal currAmt;

    @ApiModelProperty("单位成本")
    @Column(name="cost_price" , columnDefinition = "NUMERIC(20,4)   comment '单位成本'")
    BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    @Column(name="cost_amt" , columnDefinition = "NUMERIC(20,4)   comment '成本金额'")
    BigDecimal costAmt;

    @ApiModelProperty("原因码 [UDC]COM:APPR_STATUS")
    @Column(name="doc_reason" , columnDefinition = "varchar(10)  comment '原因码 [UDC]COM:APPR_STATUS'")
    String docReason;

    @ApiModelProperty("外部单据公司")
    @Column(name="outer_ou" , columnDefinition = "varchar(40)  comment '外部单据公司'")
    String outerOu;

    @ApiModelProperty("外部单据类型")
    @Column(name="outer_type" , columnDefinition = "varchar(40)  comment '外部单据类型'")
    String outerType;

    @ApiModelProperty("外部单据编号")
    @Column(name="outer_no" , columnDefinition = "varchar(40)  comment '外部单据编号'")
    String outerNo;

    @ApiModelProperty("外部单据行号")
    @Column(name="outer_lineno" , columnDefinition = "varchar(40)  comment '外部单据行号'")
    String outerLineno;

    @ApiModelProperty("WMS单据号")
    @Column(name="wms_no" , columnDefinition = "varchar(40)  comment 'WMS单据号'")
    String wmsNo;

    @ApiModelProperty("WMS单据行号")
    @Column(name="wms_lineno" , columnDefinition = "varchar(40)  comment 'WMS单据行号'")
    String wmsLineno;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvAsmDDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvAsmDDO entity = (InvAsmDDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}

