package com.elitesland.yst.production.inv.domain.entity.invstk;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.yst.production.inv.constants.InvBusinessObjectConstants;
import com.elitesland.yst.production.sale.constant.SaleBusinessObjectConstants;
import com.elitesland.yst.production.support.provider.constant.SupportBusinessObjectConstants;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;


/**
 * <p>
 * 功能说明:出入库台账
 * </p >
 *
 * @author jeesie
 * @date 2021/7/27
 */

@Entity
@Table(name = "inv_io")
@org.hibernate.annotations.Table(appliesTo = "inv_io", comment = "出入库台账")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "INV_IO", description = "出入库台账")
public class InvIoDO extends BaseModel implements Serializable {
    @ApiModelProperty("公司ID")
    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "ou_id")
    @Comment("公司")
    @Column(name = "ou_id", columnDefinition = "bigint(20)  comment '公司ID'")
    Long ouId;

    @ApiModelProperty("BUID")
    @Column(name = "bu_id", columnDefinition = "bigint(20)  comment 'BUID'")
    Long buId;

    @ApiModelProperty("单据编号")
    @Column(name = "doc_no", columnDefinition = "varchar(40)  comment '单据编号'")
    String docNo;

    @ApiModelProperty("台账批次ID")
    @Column(name = "io_batch_id", columnDefinition = "bigint(20)  comment '台账批次ID'")
    Long ioBatchId;

    @ApiModelProperty("台账状态 有效/已撤销")
    @Column(name = "io_status", columnDefinition = "varchar(40)  comment '台账状态 有效/已撤销'")
    String ioStatus;

    @ApiModelProperty("行号")
    @Column(columnDefinition = "NUMERIC(20,3)   comment '行号'")
    Double lineNo;

    @ApiModelProperty("仓库ID")
    @Column(name = "wh_id", columnDefinition = "bigint(20)  comment '仓库ID'")
    Long whId;

    @ApiModelProperty("仓库编码")
    @Column(name = "wh_Code", columnDefinition = "varchar(40)  comment '仓库编码'")
    String whCode;

    @ApiModelProperty("stkID")
    @Column(name = "stk_id", columnDefinition = "bigint(20)  comment '库存ID'")
    Long stkId;

    @ApiModelProperty("经销商")
    @BusinessParam(relatedBusinessObject = SaleBusinessObjectConstants.SALE_DEALER, relatedField = "dealer_code")
    @Comment("经销商")
    @Column(name = "deter1", columnDefinition = "varchar(40)  comment '经销商'")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @Column(name = "deter2", columnDefinition = "varchar(40)  comment '功能区 [UDC]INV:FUNC_TYPE'")
    String deter2;

    @ApiModelProperty("场景码")
    @Column(name = "scene_code", columnDefinition = "varchar(40)  comment '场景码'")
    String sceneCode;

    @ApiModelProperty("合作伙伴编码")
    @Column(name="p_code" , columnDefinition = "varchar(20)  comment '合作伙伴编码'")
    String pCode;

    @ApiModelProperty("合作伙伴类型")
    @Column(name="p_type" , columnDefinition = "varchar(100)  comment '合作伙伴类型'")
    String pType;

    @ApiModelProperty("客户标识")
    @Column(name = "deter3", columnDefinition = "varchar(40)  comment '客户标识'")
    String deter3;

    @ApiModelProperty("限定4")
    @Column(name = "deter4", columnDefinition = "varchar(40)  comment '限定4'")
    String deter4;

    @ApiModelProperty("限定5")
    @Column(name = "deter5", columnDefinition = "varchar(40)  comment '限定5'")
    String deter5;

    @ApiModelProperty("限定6")
    @Column(name = "deter6", columnDefinition = "varchar(40)  comment '限定6'")
    String deter6;

    @ApiModelProperty("限定7")
    @Column(name = "deter7", columnDefinition = "varchar(40)  comment '限定7'")
    String deter7;

    @ApiModelProperty("限定8")
    @Column(name = "deter8", columnDefinition = "varchar(40)  comment '限定8'")
    String deter8;

    @ApiModelProperty("库位")
    @Column(name = "wh_loc", columnDefinition = "varchar(40)  comment '库位'")
    String whLoc;

    @ApiModelProperty("货位")
    @Column(name = "wh_posi", columnDefinition = "varchar(40)  comment '货位'")
    String whPosi;

    @ApiModelProperty("品项ID")
    @Column(name = "item_id", columnDefinition = "bigint(20)  comment '品项ID'")
    Long itemId;

    @ApiModelProperty("商品SKU品类编号")
    @Column(name = "item_cate_code", columnDefinition = "varchar(255)  comment '商品品类'")
    String itemCateCode;

    @ApiModelProperty("品牌")
    @Column(name = "brand", columnDefinition = "varchar(255)  comment '品牌'")
    String brand;

    @ApiModelProperty("品项名称")
    @Column(name = "item_name", columnDefinition = "varchar(255)  comment '品项名'")
    String itemName;

    @ApiModelProperty("异构ID")
    @Column(name = "vari_id", columnDefinition = "bigint default 0  comment '异构ID'")
    Long variId;

    @ApiModelProperty("品项编号")
    @Column(name = "item_code", columnDefinition = "varchar(40)  comment '品项编号'")
    String itemCode;

    @ApiModelProperty("出入码")
    @Column(name = "io_code", columnDefinition = "varchar(40)  comment '出入码'")
    String ioCode;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    @Column(name="reason_code" , columnDefinition = "varchar(100)  comment '原因码 [UDC]COM:REASON_CODE'")
    String reasonCode;

    @ApiModelProperty("出入库发生日期")
    @Column()
    @Comment("出入库发生日期")
    LocalDateTime ioDate;

    @ApiModelProperty("出入库记账日期")
    @Column()
    @Comment("出入库记账日期")
    LocalDateTime finDate;

    @ApiModelProperty("财务年度")
    @Column(name = "fin_year", columnDefinition = "int(18)  comment '财务年度'")
    Integer finYear;

    @ApiModelProperty("财务期间")
    @Column(name = "fin_period", columnDefinition = "int(18)  comment '财务期间'")
    Integer finPeriod;

    @ApiModelProperty("单位")
    @Column(name = "uom", columnDefinition = "varchar(10)  comment '单位'")
    String uom;

    @ApiModelProperty("数量")
    @Column(name = "qty", columnDefinition = "NUMERIC(20,8) comment '数量'")
    BigDecimal qty;

    @ApiModelProperty("单位2")
    @Column(name = "uom2", columnDefinition = "varchar(10)  comment '单位2'")
    String uom2;

    @ApiModelProperty("数量2")
    @Column(name = "qty2", columnDefinition = "NUMERIC(20,8) comment '数量2'")
    Double qty2;

    @ApiModelProperty("单位转换率")
    @Column(name = "uom_ratio", columnDefinition = "float(20,8)   comment '单位转换率'")
    Double uomRatio;

    @ApiModelProperty("单位转换率2")
    @Column(name = "uom_ratio2", columnDefinition = "float(20,8)   comment '单位转换率2'")
    Double uomRatio2;

    @ApiModelProperty("体积")
    @Column(name = "volume", columnDefinition = "float(20,8)   comment '体积'")
    Double volume;

    @ApiModelProperty("净重")
    @Column(name = "net_weight", columnDefinition = "float(20,8)   comment '净重'")
    Double netWeight;

    @ApiModelProperty("毛重")
    @Column(name = "gross_weight", columnDefinition = "float(20,8)   comment '毛重'")
    Double grossWeight;

    @ApiModelProperty("重量")
    @Column(name = "weight", columnDefinition = "float(20,8)   comment '重量'")
    Double weight;

    @ApiModelProperty("重量单位")
    @Column(name = "weight_uom_code", columnDefinition = "varchar(40)  comment '重量单位'")
    String weightUomCode;

    @ApiModelProperty("重量转换率 重量单位与主单位")
    @Column(name = "weight_ratio", columnDefinition = "float(20,8)   comment '重量转换率 重量单位与主单位'")
    Double weightRatio;

    @ApiModelProperty("批次号")
    @Column(name = "lot_no", columnDefinition = "varchar(40)  comment '批次号'")
    String lotNo;

    @ApiModelProperty("整批号")
    @Column(name = "batch_no", columnDefinition = "varchar(40)  comment '整批号'")
    String batchNo;

    @ApiModelProperty("序列号")
    @Column(name = "sn_no", columnDefinition = "varchar(40)  comment '序列号'")
    String snNo;

    @ApiModelProperty("单位成本")
    @Column(name = "cost_price", columnDefinition = "float(20,8)   comment '单位成本'")
    BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    @Column(name = "cost_amt", columnDefinition = "float(20,8)   comment '成本金额'")
    BigDecimal costAmt;

    @ApiModelProperty("含税价格")
    @Column(name = "price", columnDefinition = "float(20,8)   comment '含税价格'")
    BigDecimal price;

    @ApiModelProperty("不含税价格")
    @Column(name = "net_price", columnDefinition = "float(20,8)   comment '不含税价格'")
    BigDecimal netPrice;

    @ApiModelProperty("税率")
    @Column(name = "tax_rate", columnDefinition = "float(20,8)   comment '税率'")
    Double taxRate;

    @ApiModelProperty("税额")
    @Column(name = "tax_amt", columnDefinition = "float(20,2)   comment '税额'")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    @Column(name = "amt", columnDefinition = "float(20,2)   comment '含税金额'")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    @Column(name = "net_amt", columnDefinition = "float(20,2)   comment '不含税金额'")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    @Column(name = "home_curr", columnDefinition = "varchar(10)  comment '记账币种'")
    String homeCurr;

    @ApiModelProperty("交易币种")
    @Column(name = "curr_code", columnDefinition = "varchar(10)  comment '交易币种'")
    String currCode;

    @ApiModelProperty("汇率")
    @Column(name = "curr_rate", columnDefinition = "float(20,8)   comment '汇率'")
    Double currRate;

    @ApiModelProperty("外币不含税金额")
    @Column(name = "curr_net_amt", columnDefinition = "float(20,2)   comment '外币不含税金额'")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    @Column(name = "curr_amt", columnDefinition = "float(20,2)   comment '外币含税金额'")
    BigDecimal currAmt;

    @ApiModelProperty("客户ID")
    @Column(name = "cust_id", columnDefinition = "bigint(20)  comment '客户ID'")
    Long custId;

    @ApiModelProperty("供应商ID")
    @Column(name = "supp_id", columnDefinition = "bigint(20)  comment '供应商ID'")
    Long suppId;

    @ApiModelProperty("客户ID2 最终客户")
    @Column(name = "cust_id2", columnDefinition = "bigint(20)  comment '客户ID2 最终客户'")
    Long custId2;

    @ApiModelProperty("来源单据类别")
    @Column(name = "src_doc_cls", columnDefinition = "varchar(40)  comment '来源单据类别'")
    String srcDocCls;

    @ApiModelProperty("来源单据ID")
    @Column(name = "src_doc_id", columnDefinition = "bigint(20)  comment '来源单据ID'")
    Long srcDocId;

    @ApiModelProperty("来源单据编号")
    @Column(name = "src_doc_no", columnDefinition = "varchar(40)  comment '来源单据编号'")
    String srcDocNo;

    @ApiModelProperty("来源单据明细ID")
    @Column(name = "src_doc_did", columnDefinition = "bigint(20)  comment '来源单据明细ID'")
    Long srcDocDid;

    @ApiModelProperty("来源单据类别2")
    @Column(name = "src_doc_cls2", columnDefinition = "varchar(40)  comment '来源单据类别2'")
    String srcDocCls2;

    @ApiModelProperty("来源单据ID2")
    @Column(name = "src_doc_id2", columnDefinition = "bigint(20)  comment '来源单据ID2'")
    Long srcDocId2;

    @ApiModelProperty("来源单据编号2")
    @Column(name = "src_doc_no2", columnDefinition = "varchar(40)  comment '来源单据编号2'")
    String srcDocNo2;

    @ApiModelProperty("来源单据明细ID2")
    @Column(name = "src_doc_did2", columnDefinition = "bigint(20)  comment '来源单据明细ID'")
    Long srcDocDid2;

    @ApiModelProperty("销售配货单明细ID")
    @Column(name = "src_doc_d_did", columnDefinition = "bigint(20)  comment '销售配货单明细ID'")
    Long srcDocDDid;

    @ApiModelProperty("成本计算单号")
    @Column(name="cost_calculate_id" , columnDefinition = "varchar(20)  comment '成本计算单号'")
    String costCalculateId;

    @ApiModelProperty("ES1")
    @Column(name = "es1", columnDefinition = "varchar(40)  comment 'ES1'")
    String es1;

    @ApiModelProperty("ES2")
    @Column(name = "es2", columnDefinition = "varchar(40)  comment 'ES2'")
    String es2;

    @ApiModelProperty("ES3")
    @Column(name = "es3", columnDefinition = "varchar(40)  comment 'ES3'")
    String es3;

    @ApiModelProperty("ES4")
    @Column(name = "es4", columnDefinition = "varchar(40)  comment 'ES4'")
    String es4;

    @ApiModelProperty("ES5")
    @Column(name = "es5", columnDefinition = "varchar(40)  comment 'ES5'")
    String es5;

    @ApiModelProperty("ERP成功标识")
    @Column(name = "fin1", columnDefinition = "varchar(40)  comment 'ERP成功标识'")
    String fin1;

    @ApiModelProperty("ERP凭证号")
    @Column(name = "fin2", columnDefinition = "varchar(40)  comment 'ERP凭证号'")
    String fin2;

    @ApiModelProperty("ERP传输日期")
    @Comment("ERP传输日期")
    LocalDateTime fin3;

    @ApiModelProperty("传输ERP唯一标识码")
    @Column(name = "fin4", columnDefinition = "varchar(40)  comment '传输ERP唯一标识码-成本结转业务'")
    String fin4;

    @ApiModelProperty("ERP成功标识-成本结转业务")
    @Column(name = "fin5", columnDefinition = "varchar(40)  comment 'ERP成功标识-成本结转业务'")
    String fin5;

    @ApiModelProperty("ERP凭证号-成本结转业务")
    @Column(name = "fin6", columnDefinition = "varchar(40)  comment 'ERP凭证号-成本结转业务'")
    String fin6;

    @ApiModelProperty("ERP传输日期-成本结转业务")
    @Comment("ERP传输日期-成本结转业务")
    LocalDateTime fin7;

    @ApiModelProperty("传输ERP唯一标识码-成本结转业务")
    @Column(name = "fin8", columnDefinition = "varchar(40)  comment '传输ERP唯一标识码-成本结转业务'")
    String fin8;

    @ApiModelProperty("limit1")
    @Column(name = "limit1", columnDefinition = "varchar(40)  comment 'limit1'")
    private String limit1;

    @ApiModelProperty("limit2")
    @Column(name = "limit2", columnDefinition = "varchar(40)  comment 'limit2'")
    private String limit2;

    @ApiModelProperty("limit3")
    @Column(name = "limit3", columnDefinition = "varchar(40)  comment 'limit3'")
    private String limit3;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvIoDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvIoDO entity = (InvIoDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
