package com.elitesland.yst.production.inv.entity;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.yst.production.inv.constants.InvBusinessObjectConstants;
import com.elitesland.yst.production.sale.constant.SaleBusinessObjectConstants;
import com.elitesland.yst.production.support.provider.constant.SupportBusinessObjectConstants;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

/**
 * @author jeesie.jiang
 * @date 2022-03-17 16:20
 * Desc: 库存转移
 */
@Entity
@Table(name = "inv_trn")
@org.hibernate.annotations.Table(appliesTo = "inv_trn", comment = "库存转移")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "INV_TRN", description = "库存转移")
public class InvTrnDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -139077873874594105L;
    @ApiModelProperty("公司ID")
    @Column(name = "ou_id", columnDefinition = "bigint(20)  comment '公司ID'")
    Long ouId;

    @ApiModelProperty("公司编码")
    @Column(name = "ou_code", columnDefinition = "varchar(40)  comment '公司编码'")
    String ouCode;

    @ApiModelProperty("BUID")
    @Column(name = "bu_id", columnDefinition = "bigint(20)  comment 'BUID'")
    Long buId;

    @ApiModelProperty("单据编号")
    @Column(name = "doc_no", columnDefinition = "varchar(40)  comment '单据编号'")
    String docNo;

    @ApiModelProperty("转移类型 [UDC]INV:TRN_TYPE")
    @Column(name = "doc_type", columnDefinition = "varchar(10)  comment '转移类型 [UDC]INV:TRN_TYPE'")
    String docType;

    @ApiModelProperty("转移单状态 [UDC]INV:TRN_STATUS")
    @Column(name = "doc_status", columnDefinition = "varchar(40)  comment '转移单状态 [UDC]INV:TRN_STATUS'")
    String docStatus;

    @ApiModelProperty("提审人ID")
    @Column(name = "appr_create_user_id", columnDefinition = "bigint default 0 comment '提审人ID'")
    Long apprCreateUserId;

    @ApiModelProperty("申请人员工ID")
    @Column(name = "apply_emp_id", columnDefinition = "bigint(20)  comment '申请人员工ID'")
    Long applyEmpId;

    @ApiModelProperty("申请日期")
    @Column()
    @Comment("申请日期")
    LocalDateTime applyDate;

    @ApiModelProperty("申请描述")
    @Column(name = "apply_desc", columnDefinition = "varchar(100)  comment '申请描述'")
    String applyDesc;

    @ApiModelProperty("交易日期 实际出入库日期")
    @Column()
    @Comment("交易日期")
    LocalDateTime ioDate;

    @ApiModelProperty("从公司ID")
    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "o_ou_id")
    @Comment("从公司")
    @Column(name = "o_ou_id", columnDefinition = "bigint(20)  comment '从公司ID'")
    Long oOuId;

    @ApiModelProperty("从仓库ID")
    @Column(name = "o_wh_id", columnDefinition = "bigint(20)  comment '从仓库ID'")
    Long oWhId;

    @ApiModelProperty("从仓库编码")
    @Column(name = "o_wh_code", columnDefinition = "varchar(200)  comment '从仓库编码'")
    String oWhCode;

    @ApiModelProperty("至仓库编号")
    @Column(name = "i_wh_code", columnDefinition = "varchar(200)  comment '至仓库编号'")
    String iWhCode;

    @ApiModelProperty("从温层 [UDC]INV:TEMP_TYPE")
    @BusinessParam(relatedBusinessObject = SaleBusinessObjectConstants.SALE_DEALER, relatedField = "dealer_code")
    @Comment("从经销商")
    @Column(name = "o_deter1", columnDefinition = "varchar(40)  comment '从温层 [UDC]INV:TEMP_TYPE'")
    String oDeter1;

    @ApiModelProperty("从功能区 [UDC]INV:FUNC_TYPE")
    @Column(name = "o_deter2", columnDefinition = "varchar(40)  comment '从功能区 [UDC]INV:FUNC_TYPE'")
    String oDeter2;

    @ApiModelProperty("从客户标识")
    @Column(name = "o_deter3", columnDefinition = "varchar(40)  comment '从客户标识'")
    String oDeter3;

    @ApiModelProperty("从限定4")
    @Column(name = "o_deter4", columnDefinition = "varchar(40)  comment '从限定4'")
    String oDeter4;

    @ApiModelProperty("从限定5")
    @Column(name = "o_deter5", columnDefinition = "varchar(40)  comment '从限定5'")
    String oDeter5;

    @ApiModelProperty("从限定6")
    @Column(name = "o_deter6", columnDefinition = "varchar(40)  comment '从限定6'")
    String oDeter6;

    @ApiModelProperty("从限定7")
    @Column(name = "o_deter7", columnDefinition = "varchar(40)  comment '从限定7'")
    String oDeter7;

    @ApiModelProperty("从限定8")
    @Column(name = "o_deter8", columnDefinition = "varchar(40)  comment '从限定8'")
    String oDeter8;

    @ApiModelProperty("到公司ID")
    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "i_ou_id")
    @Comment("到公司")
    @Column(name = "i_ou_id", columnDefinition = "bigint(20)  comment '到公司ID'")
    Long iOuId;

    @ApiModelProperty("到仓库ID")
    @Column(name = "i_wh_id", columnDefinition = "bigint(20)  comment '到仓库ID'")
    Long iWhId;

    @ApiModelProperty("到温层 [UDC]INV:TEMP_TYPE")
    @BusinessParam(relatedBusinessObject = SaleBusinessObjectConstants.SALE_DEALER, relatedField = "dealer_code")
    @Comment("到经销商")
    @Column(name = "i_deter1", columnDefinition = "varchar(40)  comment '到温层 [UDC]INV:TEMP_TYPE'")
    String iDeter1;

    @ApiModelProperty("到功能区 [UDC]INV:FUNC_TYPE")
    @Column(name = "i_deter2", columnDefinition = "varchar(40)  comment '到功能区 [UDC]INV:FUNC_TYPE'")
    String iDeter2;

    @ApiModelProperty("到客户标识")
    @Column(name = "i_deter3", columnDefinition = "varchar(40)  comment '到客户标识'")
    String iDeter3;

    @ApiModelProperty("到限定4")
    @Column(name = "i_deter4", columnDefinition = "varchar(40)  comment '到限定4'")
    String iDeter4;

    @ApiModelProperty("到限定5")
    @Column(name = "i_deter5", columnDefinition = "varchar(40)  comment '到限定5'")
    String iDeter5;

    @ApiModelProperty("到限定6")
    @Column(name = "i_deter6", columnDefinition = "varchar(40)  comment '到限定6'")
    String iDeter6;

    @ApiModelProperty("到限定7")
    @Column(name = "i_deter7", columnDefinition = "varchar(40)  comment '到限定7'")
    String iDeter7;

    @ApiModelProperty("到限定8")
    @Column(name = "i_deter8", columnDefinition = "varchar(40)  comment '到限定8'")
    String iDeter8;

    @ApiModelProperty("总数量")
    @Column(name = "qty", columnDefinition = "NUMERIC(20,8)   comment '总数量'")
    BigDecimal qty;

    @ApiModelProperty("数量单位")
    @Column(name = "qty_uom", columnDefinition = "varchar(10)  comment '数量单位'")
    String qtyUom;

    @ApiModelProperty("税额")
    @Column(name = "tax_amt", columnDefinition = "NUMERIC(20,4)   comment '税额'")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    @Column(name = "amt", columnDefinition = "NUMERIC(20,4)   comment '含税金额'")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    @Column(name = "net_amt", columnDefinition = "NUMERIC(20,4)   comment '不含税金额'")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    @Column(name = "home_curr", columnDefinition = "varchar(10)  comment '记账币种'")
    String homeCurr;

    @ApiModelProperty("交易币种")
    @Column(name = "curr_code", columnDefinition = "varchar(10)  comment '交易币种'")
    String currCode;

    @ApiModelProperty("汇率")
    @Column(name = "curr_rate", columnDefinition = "float(20,8)   comment '汇率'")
    Float currRate;

    @ApiModelProperty("外币不含税金额")
    @Column(name = "curr_net_amt", columnDefinition = "NUMERIC(20,4)   comment '外币不含税金额'")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    @Column(name = "curr_amt", columnDefinition = "NUMERIC(20,4)   comment '外币含税金额'")
    BigDecimal currAmt;

    @ApiModelProperty("成本金额")
    @Column(name = "cost_amt", columnDefinition = "NUMERIC(20,4)   comment '成本金额'")
    BigDecimal costAmt;

    @ApiModelProperty("关联单据类别 如RMA。[UDC]COM:DOC_CLS")
    @Column(name = "relate_doc_cls", columnDefinition = "varchar(40)  comment '关联单据类别 如RMA。[UDC]COM:DOC_CLS'")
    String relateDocCls;

    @ApiModelProperty("关联单据类型")
    @Column(name = "relate_doc_type", columnDefinition = "varchar(40)  comment '关联单据类型'")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    @Column(name = "relate_doc_id", columnDefinition = "bigint(20)  comment '关联单据ID'")
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    @Column(name = "relate_doc_no", columnDefinition = "varchar(40)  comment '关联单据编号'")
    String relateDocNo;

    @ApiModelProperty("关联ID")
    @Column(name = "relate_id", columnDefinition = "bigint(20)  comment '关联ID'")
    Long relateId;

    @ApiModelProperty("关联编号")
    @Column(name = "relate_no", columnDefinition = "varchar(40)  comment '关联编号'")
    String relateNo;

    @ApiModelProperty("关联2ID")
    @Column(name = "relate2_id", columnDefinition = "bigint(20)  comment '关联2ID'")
    Long relate2Id;

    @ApiModelProperty("关联2编号")
    @Column(name = "relate2_no", columnDefinition = "varchar(40)  comment '关联2编号'")
    String relate2No;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    @Column(name = "reason_code", columnDefinition = "varchar(40)  comment '原因码 [UDC]COM:REASON_CODE'")
    String reasonCode;

    @ApiModelProperty("是否走接口： 从E1 生成的数据，状态为1；从中台生成的数据，状态为null,同步接口表后，状态改为2")
    @Column(name="intf_flag" , columnDefinition = " int(1)   comment '是否走接口： 从E1 生成的数据，状态为1；从中台生成的数据，状态为null,同步接口表后，状态改为2'")
    Integer intfFlag;

    @ApiModelProperty("ES1")
    @Column(name="es1" , columnDefinition = "varchar(40)  comment 'ES1'")
    String es1;

    @ApiModelProperty("ES2")
    @Column(name="es2" , columnDefinition = "varchar(40)  comment 'ES2'")
    String es2;

    @ApiModelProperty("ES3")
    @Column(name="es3" , columnDefinition = "varchar(40)  comment 'ES3'")
    String es3;

    @ApiModelProperty("ES4")
    @Column(name="es4" , columnDefinition = "varchar(40)  comment 'ES4'")
    String es4;

    @ApiModelProperty("ES5")
    @Column(name="es5" , columnDefinition = "varchar(40)  comment 'ES5'")
    String es5;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    @Column
    @Comment("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    @Comment("提交时间")
    @Column
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    @Comment("审批通过时间")
    @Column
    private LocalDateTime approvedTime;

    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    @Column(name="appr_status" , columnDefinition = "varchar(40)  comment '审批状态 [UDC]COM:APPR_STATUS'")
    String apprStatus;

    @ApiModelProperty("京云仓采购入库单号")
    @Column(name="jd_po_order_no" , columnDefinition = "varchar(40) comment '京云仓采购入库单号'")
    private String jdPoOrderNo;

    @ApiModelProperty("单据类别")
    @Column(name = "doc_cls", columnDefinition = "varchar(40)  comment '单据类别'")
    String docCls;




    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvTrnDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvTrnDO entity = (InvTrnDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
