package com.elitesland.yst.production.inv.domain.entity.invwh;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 库区
 */
@Entity
@Table(name = "inv_wh_area")
@org.hibernate.annotations.Table(appliesTo = "inv_wh_area", comment = "库区")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "INV_WH_AREA", description = "库区")
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class InvWhAreaDO extends BaseModel implements Serializable
{

    @Comment(value = "仓库ID", defaultValue = "0")
    @Column(name="wh_id" )
    Long whId;

    @ApiModelProperty("地址号 仓库本身的地址号")
    @Column(name = "addr_no")
    Long addrNo;

    @ApiModelProperty("功能区类型")
    @Column(name = "deter2_type")
    String deter2Type;

    @ApiModelProperty("功能区名称")
    @Column(name = "deter2_name")
    String deter2Name;

    @Comment(value = "功能区状态", defaultValue = "0")
    @Column(name = "deter2_status")
    Integer deter2Status;

    @Comment(value = "BUID", defaultValue = "0")
    @Column(name = "bu_id")
    Long buId;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @Column(name="wh_area" )
    String whArea;

    @ApiModelProperty("合作伙伴编码")
    @Column(name="p_code" )
    String pCode;

    @ApiModelProperty("合作伙伴地址")
    @Column(name="p_addr" )
    String pAddr;

    @ApiModelProperty("合作伙伴类型")
    @Column(name="p_type" )
    String pType;

    @Comment(value = "温层 [UDC]INV:TEMP_TYPE", defaultValue = "'RT'")
    @Column(name="deter1")
    String deter1;


    @Comment("功能区 [UDC]INV:FUNC_TYPE")
    @Column(name="deter2" )
    String deter2;

    @Comment("客户地址号 ADDR_NO")
    @Column(name="deter3" )
    String deter3;

    @Comment("限定词4")
    @Column(name="deter4" )
    String deter4;

    @ApiModelProperty("限定词5")
    @Column(name="deter5" )
    String deter5;

    @ApiModelProperty("限定词6")
    @Column(name="deter6")
    String deter6;

    @ApiModelProperty("限定词7")
    @Column(name="deter7" )
    String deter7;

    @ApiModelProperty("限定词8")
    @Column(name="deter8")
    String deter8;

    @ApiModelProperty("ERP编码")
    @Column(name="outer_code")
    String outerCode;

    @ApiModelProperty("ERP名")
    @Column(name="outer_code_name" )
    String outerCodeName;

    @ApiModelProperty("E1库区编号")
    @Column(name="outer_code2" )
    String outerCode2;

    @ApiModelProperty("ES1")
    @Column(name="es1" )
    String es1;

    @ApiModelProperty("ES2")
    @Column(name="es2" )
    String es2;

    @ApiModelProperty("ES3")
    @Column(name="es3" )
    String es3;

    @ApiModelProperty("ES4")
    @Column(name="es4" )
    String es4;

    @ApiModelProperty("ES5")
    @Column(name="es5" )
    String es5;

    @ApiModelProperty("库区状态")
    @Column(name="area_status")
    String areaStatus;

    @ApiModelProperty("库区编号")
    @Column(name="area_code" )
    String areaCode;

    @ApiModelProperty("库区名称")
    @Column(name="area_name" )
    String areaName;

    @ApiModelProperty("库区类型")
    @Column(name="area_type" )
    String areaType;

    @ApiModelProperty("京东事业部编码")
    @Column(name = "jdsyb_code")
    String jdsybCode;

    @ApiModelProperty("京东事业部编码名")
    @Column(name = "jdsyb_code_name")
    String jdsybCodeName;

    @ApiModelProperty("国家")
    @Column(name = "country")
    private String country;

    @ApiModelProperty("省")
    @Column(name = "province")
    private String province;

    @ApiModelProperty("市")
    @Column(name = "city")
    private String city;

    @ApiModelProperty("区县")
    @Column(name = "county")
    private String county;

    @ApiModelProperty("详细地址")
    @Column(name = "detailaddr")
    private String detailaddr;

    @ApiModelProperty("外部系统编码")
    @Column(name = "other_sys_code")
    private String otherSysCode;

    @ApiModelProperty("外部系统名称")
    @Column(name = "other_sys_name")
    private String otherSysName;

}