package com.elitesland.yst.production.inv.domain.service;


import com.elitesland.yst.production.inv.application.facade.vo.InvAjAndInvAjDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDQueryAllParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDSaveVO;
import com.elitesland.yst.production.inv.domain.entity.InvAjD;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.domain.entity.InvAjDDO;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.List;

/**
 * @author lvqf
 * @date 2021-02-1 11:36
 * Desc:
 */
public interface InvAjDDomainService {

    /**
     * zhao_qiao_gong
     * 保存库存调整单明细
     *
     * @param invAjD 保存信息
     * @return 主表id
     */
    Long createInvAjD(InvAjD invAjD);

    void deleteByMasId(Long masId);

    /**
     * 批量保存库存调整明细
     * @param invAjDList
     */
    void saveAll(List<InvAjD> invAjDList);

    List<InvAjDRespVO> findByMasId(Long masId);

    /**
     * 批量更新
     * @param data
     * @return
     */
    List<Long> updateInBatch(List<InvAjDSaveVO> data);


   // JPAQuery<InvAjAndInvAjDRespVO> invAjSelect(InvAjDQueryAllParamVO param);

    PagingVO<InvAjAndInvAjDRespVO> invAjSearch(InvAjDQueryAllParamVO param);
}
