package com.elitesland.yst.production.inv.domain.service;


import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAndAsmDSaveVO;
import com.elitesland.yst.production.inv.domain.entity.InvAsm;
import com.elitesland.yst.production.inv.infr.dto.InvAsmDTO;

import java.util.List;
import java.util.Optional;

/**
 * @author lu.wang
 * @date 2020-08-11 17:07
 * Desc:
 */
public interface InvAsmDomainService {

    Optional<InvAsmDTO> findIdOne(Long id);

    Long create(InvAsm invAsm);

    /**
     * 根据id批量修改状态
     * @param ids
     * @param status
     * @return
     */
    List<Long> updateStatusInBatch(List<Long> ids, String status);

    /**
     * 提交
     * @param id
     * @return
     */
    Long submit(Long id);

    /**
     * 审核通过
     * @param masId
     */
    void check(Long masId);

}
