package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitesland.yst.production.inv.application.facade.vo.InvAjAndInvAjDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDQueryAllParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkRespVO;
import com.elitesland.yst.production.inv.application.service.InvStkService;
import com.elitesland.yst.production.inv.domain.convert.InvAjDConvert;
import com.elitesland.yst.production.inv.domain.entity.InvAjD;
import com.elitesland.yst.production.inv.domain.entity.InvAjDDO;
import com.elitesland.yst.production.inv.domain.entity.QInvAjDDO;
import com.elitesland.yst.production.inv.domain.service.InvAjDDomainService;
import com.elitesland.yst.production.inv.infr.repo.InvAjDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvAjDRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lvqf
 * @date 2021-02-1 11:36
 * Desc:
 */
@Slf4j
@Service
@AllArgsConstructor
public class InvAjDDomainServiceImpl implements InvAjDDomainService {

    private final InvAjDRepo invAjDRepo;
    private final InvAjDRepoProc invAjDRepoProc;
    private final InvStkService invStkService;

    @Override
    public Long createInvAjD(InvAjD invAjD) {
        return null;
    }

    @Override
    public void deleteByMasId(Long masId) {
        invAjDRepo.deleteByMasId(masId);
    }

    @Override
    public void saveAll(List<InvAjD> invAjDList) {
        if (CollectionUtils.isEmpty(invAjDList)) {
            throw new BusinessException(ApiCode.FAIL, "库存调整明细保存集合为空！");
        }
        List<InvAjDDO> collect = invAjDList.stream().map(invajd -> {
            InvAjDDO invAjDDO = InvAjDConvert.INSTANCE.invAjDToInvAjDDO(invajd);
            return invAjDDO;
        }).collect(Collectors.toList());

        invAjDRepo.saveAll(collect);
    }

    @Override
    public List<InvAjDRespVO> findByMasId(Long masId) {
        List<InvAjDRespVO> invAjDRespVOS = invAjDRepo.findByMasId(masId).stream()
                .map(InvAjDConvert.INSTANCE::doToInvAjDRespVO)
                .collect(Collectors.toList());
        this.fillUpNameList2(invAjDRespVOS);
        /** 优化库存调整查询 2021-4-28 jeesie.jiang **/
        invAjDRespVOS.forEach(i -> {
            InvBaseModel tskParam = new InvBaseModel();
            tskParam.setWhId(i.getWhId());
            tskParam.setDeter1(i.getDeter1());
            tskParam.setDeter2(i.getDeter2());
            tskParam.setLotNo(i.getLotNo());
            tskParam.setItemId(i.getItemId());
            /** 库存余额查询 由于需求没确定需要进一步优化，待定**/
            InvStkRespVO ret = invStkService.getInvStk(tskParam);
            if (ret != null) {
                i.setAvalQty(ret.getAvalQty());
            }
        });
        return invAjDRespVOS;
    }

    @Override
    public List<Long> updateInBatch(List<InvAjDSaveVO> data) {
        List<InvAjDDO> invAjDDOS = data.stream().map(e -> {
            InvAjDDO invAjDDO = InvAjDConvert.INSTANCE.invAjDSaveVOToInvAjDDO(e);
            return invAjDDO;
        }).collect(Collectors.toList());
        return invAjDRepo.saveAll(invAjDDOS).stream().map(InvAjDDO::getId).collect(Collectors.toList());
    }

   /* @Override
    public JPAQuery<InvAjAndInvAjDRespVO> invAjSelect(InvAjDQueryAllParamVO param) {
        val invAjDRespVOJPAQuery = invAjDRepoProc.ajSelect().where(invAjDRepoProc.searchWhere(param));
        List<InvAjAndInvAjDRespVO> fetch = invAjDRespVOJPAQuery.fetch();
        if (CollectionUtils.isEmpty(fetch)) {
            throw new BusinessException(ApiCode.FAIL, "查询结果不存在！");
        }
        return invAjDRespVOJPAQuery;
    }*/

    @Override
    @SysCodeProc
    public PagingVO<InvAjAndInvAjDRespVO> invAjSearch(InvAjDQueryAllParamVO param) {
        JPAQuery<InvAjAndInvAjDRespVO> jpaQuery = invAjDRepoProc.ajSelect().where(invAjDRepoProc.searchWhere(param));
        invAjDRepoProc.openOrderAndLimit(jpaQuery, param, QInvAjDDO.invAjDDO);
        long dataCount = jpaQuery.fetchCount();
        List<InvAjAndInvAjDRespVO> ajAndInvAjDRespVOS = jpaQuery.fetch();

        return PagingVO.<InvAjAndInvAjDRespVO>builder().records(ajAndInvAjDRespVOS).total(dataCount).build();
    }

    /**
     * 填充反查数据
     *
     * @param vos 查询结果
     */
    private void fillUpNameList2(List<InvAjDRespVO> vos) {
//        List<Long> itemIds = vos.stream().map(InvAjDRespVO::getItemId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
//        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
//        itmItemPartParam.setItemIds(itemIds);
//        List<ItmItemRpcDTO> itmItemDTOS = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
//        vos.forEach(vo -> {
//            Optional<ItmItemRpcDTO> itmItemDTOOptional = itmItemDTOS.stream().filter(v -> v.getId().equals(vo.getItemId())).findFirst();
//            if (itmItemDTOOptional.isPresent()) {
//                ItmItemRpcDTO itmItemDTO = itmItemDTOOptional.get();
//                vo.setItemCode(itmItemDTO.getItemCode());
//                vo.setItemName(itmItemDTO.getItemName());
//                vo.setBrand(itmItemDTO.getBrand());
//            }
//        });
    }

}
