package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkRespVO;
import com.elitesland.yst.production.inv.domain.convert.ck.InvCkConvert;
import com.elitesland.yst.production.inv.domain.entity.ck.InvCk;
import com.elitesland.yst.production.inv.domain.entity.ck.InvCkDO;
import com.elitesland.yst.production.inv.domain.service.InvCkDomainService;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDTO;
import com.elitesland.yst.production.inv.infr.repo.ck.InvCkRepo;
import com.elitesland.yst.production.inv.infr.repo.ck.InvCkRepoProc;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Optional;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/14
 * @Version 1.0
 * @Content:
 */
@Service
@AllArgsConstructor
public class InvCkDomainServiceImpl implements InvCkDomainService {
    private final InvCkRepo invCkRepo;
    private final InvCkRepoProc invCkRepoProc;

    /**
     * 根据ID查询库存盘点信息
     *
     * @param id 库存盘点ID
     * @return 库存盘点对象
     */
    @Override
    @SysCodeProc
    public Optional<InvCkDTO> findById(Long id) {
        return invCkRepo.findById(id).map(InvCkConvert.INSTANCE::doToDto);
    }

    /**
     * 库存盘点保存
     *
     * @param invCk
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveInvCk(InvCk invCk) {
        InvCkDO invCkDO = InvCkConvert.INSTANCE.enToDo(invCk);
        return invCkRepo.save(invCkDO).getId();
    }

    @Override
    @SysCodeProc
    public PagingVO<InvCkRespVO> invCkSearch(InvCkParamVO param) {
        val pagingVo = invCkRepoProc.invCkSearch(param);
        return pagingVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDocStatus(Long id,String docStatus) {
        invCkRepoProc.updateDocStatus(id, docStatus);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateIsAjStatus(Long id,Integer isAjStatus) {
        invCkRepoProc.updateIsAjStatus(id,isAjStatus);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateProcInstStatusById(ProcInstStatus procInstStatus, Long id) {
        invCkRepoProc.updateProcInstStatusById(procInstStatus, id).execute();
    }

    /**
     * 修改业务审批数据
     *
     * @param processInfo 工作流
     * @param id          采购退货ID
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateProcInst(ProcessInfo processInfo, Long id,String docStatus) {
        invCkRepoProc.updateProcInst(processInfo, id,docStatus).execute();
    }


}
