package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryGroupParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryParamVO;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvStkConvert;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkDO;
import com.elitesland.yst.production.inv.domain.entity.invstk.QInvStkDO;
import com.elitesland.yst.production.inv.domain.service.InvStkDomainService;
import com.elitesland.yst.production.inv.dto.invstk.InvStkAllRpcDtoParam;
import com.elitesland.yst.production.inv.dto.invstk.InvStkRpcDTO;
import com.elitesland.yst.production.inv.dto.invstk.InvStkRpcDtoParam;
import com.elitesland.yst.production.inv.infr.dto.InvStkDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkFullDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkGroupDTO;
import com.elitesland.yst.production.inv.infr.repo.InvStkRepo;
import com.elitesland.yst.production.inv.infr.repo.InvStkRepoProc;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import lombok.AllArgsConstructor;
import lombok.val;
import org.apache.logging.log4j.util.Strings;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@Service("InvStkDomainService")
@AllArgsConstructor
public class InvStkDomainServiceImpl implements InvStkDomainService {

    private final InvStkRepo invStkRepo;

    private final InvStkRepoProc invStkRepoProc;

    @Override
    public InvStkDO saveInvStk(InvStkDO invStkDO) {
        return invStkRepo.save(invStkDO);
    }

    @Override
    public List<InvStkDO> saveInvStkList(List<InvStkDO> invStkList) {
        return invStkRepo.saveAll(invStkList);
    }

    @Override
    public int saveInvStkAll(List<InvStkDO> invStkList) {
        return invStkRepo.saveAll(invStkList).size();
    }

    @Override
    public Optional<InvStkDO> getInvStkById(Long id) {
        return invStkRepo.findById(id);
    }

    @Override
    public InvStkDTO getInvStk(InvBaseModel queryParam) {
        List<InvStkDTO> fetch = invStkRepoProc.select(null).where(getPredicate(QInvStkDO.invStkDO, queryParam)).fetch();
        if (!ObjectUtils.isEmpty(fetch) && fetch.size() > 0) {
            return fetch.get(0);
        }
        return null;
    }

    @Override
    public List<InvStkRpcDTO> findStkAllRpcDTOByParam(InvStkAllRpcDtoParam param) {
        List<InvStkRpcDTO> invStkRpcDTOS = invStkRepoProc.findStkAllDTOByParam(param);
        return invStkRpcDTOS;
    }

    @Override
    public List<InvStkRpcDTO> getInvStkRpcDTOByParam(InvStkRpcDtoParam param) {
        List<InvStkRpcDTO> invStkRpcDTOS = invStkRepoProc.findStkRpcDTOByParam(param);
        return invStkRpcDTOS;

    }


    @Override
    public void deleteById(Long id) {
        invStkRepo.deleteById(id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> invStkRepo.deleteById(id));
    }


    @Override
    public List<InvStkDTO> findInvStkRespVOs(InvStkQueryParamVO param) {
        Iterable<InvStkDO> invStkDOIterable = invStkRepo.findAll(invStkRepoProc.findInvStkList(param));
        List<InvStkDTO> invStkDTOS = StreamSupport.stream(invStkDOIterable.spliterator(), false)
                .map(InvStkConvert.INSTANCE::doToDto).collect(Collectors.toList());
        return invStkDTOS;
    }

    @Override
    @SysCodeProc
    public List<InvStkGroupDTO> selectInvStkGroupByParam(InvStkQueryGroupParamVO param) {
        List<InvStkGroupDTO> invStkGroupDTOList = invStkRepoProc.selectInvStkGroupByParam(param).fetch();
        if (CollectionUtils.isEmpty(invStkGroupDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return invStkGroupDTOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvStkGroupDTO> invStkGroupSearch(InvStkQueryGroupParamVO param) {
        val pagingVo = invStkRepoProc.invStkGroupSearch(param);
        return pagingVo;
    }


    /**
     * 全量库存分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 库存多条数据
     */
    @Override
    @SysCodeProc
    public PagingVO<InvStkFullDTO> fullSearch(InvStkQueryGroupParamVO param) {
        val jpaQuery = invStkRepoProc.fullSearch(null).where(invStkRepoProc.whereGroup(param));
        param.fillOrders(jpaQuery, QInvStkDO.invStkDO);
        param.setPaging(jpaQuery);
        return PagingVO.<InvStkFullDTO>builder()
                .total(jpaQuery.fetch().size())
                .records(jpaQuery.fetch())
                .build();
    }

    @Override
    @SysCodeProc
    public List<InvStkGroupDTO> selectInvStkGroupByInvBaseModel(InvBaseModel param) {
        List<InvStkGroupDTO> invStkGroupDTOList = invStkRepoProc.selectInvStkGroupByParam(null).where(getPredicate(QInvStkDO.invStkDO, param)).fetch();
        if (CollectionUtils.isEmpty(invStkGroupDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return invStkGroupDTOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvStkDTO> queryAll(InvStkQueryParamVO param) {
        return  invStkRepoProc.queryAll(param);
    }

    /**
     * 封装 查询条件
     *
     * @param jpaQDo
     * @param queryParam
     * @return
     */
    private Predicate getPredicate(QInvStkDO jpaQDo, InvBaseModel queryParam) {
        Predicate predicate1 = queryParam.getItemId() != null ? jpaQDo.itemId.eq(queryParam.getItemId()) : null;
        Predicate predicate2 = queryParam.getVariId() != null && queryParam.getVariId() != 0 ? jpaQDo.variId.eq(queryParam.getVariId()) : null;
        //批次号
        Predicate predicate3 = !StringUtils.isEmpty(queryParam.getLotNo()) ? jpaQDo.lotNo.eq(queryParam.getLotNo()) : null;
        Predicate predicate4 = queryParam.getWhId() != null ? jpaQDo.whId.eq(queryParam.getWhId()) : null;
        Predicate predicate5 = !StringUtils.isEmpty(queryParam.getDeter1()) ? jpaQDo.deter1.eq(queryParam.getDeter1()) : null;
        Predicate predicate6 = !StringUtils.isEmpty(queryParam.getDeter2()) ? jpaQDo.deter2.eq(queryParam.getDeter2()) : null;
        Predicate predicate7 = !StringUtils.isEmpty(queryParam.getUom()) ? jpaQDo.uom.eq(queryParam.getUom()) : null;
        Predicate predicate8 = !StringUtils.isEmpty(queryParam.getPType()) ? jpaQDo.pType.eq(queryParam.getPType()) : null;
        Predicate predicate9 = !StringUtils.isEmpty(queryParam.getPCode()) ? jpaQDo.pCode.eq(queryParam.getPCode()) : null;
        Predicate predicate10 = !StringUtils.isEmpty(queryParam.getSnNo()) ? jpaQDo.snNo.eq(queryParam.getSnNo()) : null;
        Predicate predicate11 = !StringUtils.isEmpty(queryParam.getDeter3()) ? jpaQDo.deter3.eq(queryParam.getDeter3()) : null;
        Predicate predicate12 = !StringUtils.isEmpty(queryParam.getLimit1()) ? jpaQDo.limit1.eq(queryParam.getLimit1()) : null;
        Predicate predicate13 = !StringUtils.isEmpty(queryParam.getLimit2()) ? jpaQDo.limit2.eq(queryParam.getLimit2()) : null;
        Predicate predicate14 = Strings.isNotEmpty(queryParam.getSnNo()) ? jpaQDo.snNo.eq(queryParam.getSnNo()) : null;
        return ExpressionUtils.allOf(predicate1,
                predicate2,
                predicate3,
                predicate4,
                predicate5,
                predicate6,
                predicate7,
                predicate8,
                predicate9,
                predicate10,
                predicate11,
                predicate12,
                predicate13,
                predicate14);

    }


}
