package com.elitesland.yst.production.inv.domain.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRpcDtoParam;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeter2RespVO;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhAreaDO;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaRpcDTO;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhAreaRepo;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhAreaRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service("InvWhAreaDomainService")
@AllArgsConstructor
public class InvWhAreaDomainServiceImpl implements InvWhAreaDomainService {

    private final InvWhAreaRepo invWhAreaRepo;

    private final InvWhAreaRepoProc invWhAreaRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<InvWhAreaRespVO> searchPaging(InvWhAreaParamVO queryParam) {
        PagingVO<InvWhAreaRespVO> pagingVO = invWhAreaRepoProc.selectWhAreaPaging(queryParam);
        return pagingVO;
    }

    @Override
    public List<InvWhAreaRespVO> findByWhId(Long whId) {
        InvWhAreaParamVO param = new InvWhAreaParamVO();
        param.setWhId(whId);
        JPAQuery<InvWhAreaRespVO> select = invWhAreaRepoProc.select(param);
        return select.fetch();
    }

    @Override
    public List<InvWhAreaRespVO> findWhAreasByParam(InvWhAreaParamVO paramVO) {
        List<InvWhAreaRespVO> areaRespVOS = invWhAreaRepoProc.select(paramVO).fetch();
        return areaRespVOS;
    }

    @Override
    @SysCodeProc
    public List<InvWhAreaRpcDTO> selectWhAreaRpcDTOByParam(InvWhAreaRpcDtoParam paramVO) {
        List<InvWhAreaRpcDTO> whAreaRpcDTOS = invWhAreaRepoProc.selectByParam(paramVO);
        return whAreaRpcDTOS;
    }

    @Override
    public List<InvWhDeter2RespVO> findDeter2sByWhId(Long id) {
        return null;
    }

    @Override
    public List<InvWhAreaRespVO> findByDeter2Names(List<String> deter2Names) {
        if(CollectionUtils.isEmpty(deter2Names)){
            return new ArrayList<>();
        }
        return invWhAreaRepoProc.selectByDeter2Names(deter2Names);
    }

    @Override
    public List<InvWhAreaRespVO> findByDeter2KeyWord(String deter2KeyWord) {
        if(StringUtils.hasText(deter2KeyWord)) {
            return invWhAreaRepoProc.findByDeter2KeyWord(deter2KeyWord);
        } else{
            throw new BusinessException(ApiCode.FAIL,"参数校验有误");
        }
    }

    @Override
    public List<InvWhAreaRespVO> findAllWhareas() {
        return invWhAreaRepoProc.findAllWhareas();
    }

    @Override
    public List<InvWhAreaRespVO> findBydeter2s(List<String> deter2s) {
        if(CollectionUtils.isEmpty(deter2s)){
            return new ArrayList<>();
        }
        List<InvWhAreaRespVO> whAreaRespVOS = invWhAreaRepoProc.findByDeter2s(deter2s);
        return whAreaRespVOS;
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> invWhAreaRepo.deleteById(id));
    }

    @Override
    @Transactional
    public void deleteByWhId(Long whId) {
        invWhAreaRepo.deleteByWhId(whId);
    }

    @Override
    @Transactional
    public InvWhAreaDO saveInvWhArea(InvWhAreaDO invWhAreaDO) {
        return invWhAreaRepo.save(invWhAreaDO);
    }

    @Override
    @Transactional
    public int saveInvWhAreaList(List<InvWhAreaDO> invWhAreaDO) {
        return invWhAreaRepo.saveAll(invWhAreaDO).size();
    }

    @Override
    @Transactional
    public List<InvWhAreaDO> saveInvWhAreas(List<InvWhAreaDO> invWhAreaDO) {
        return invWhAreaRepo.saveAll(invWhAreaDO);
    }

    @Override
    @Transactional
    public Optional<InvWhAreaDO> findOneById(Long id) {
        return invWhAreaRepo.findById(id);
    }

    @Override
    public InvWhAreaRespVO findByWhIdAndWhArea(Long whId, String whArea) {
        return BeanUtil.copyProperties(invWhAreaRepo.findFirstByWhIdAndDeter2(whId, whArea), InvWhAreaRespVO.class);
    }

}
