package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.domain.convert.InvWhAreaSettingConvert;
import com.elitesland.yst.production.inv.domain.entity.whAreaSetting.InvWhAreaSetting;
import com.elitesland.yst.production.inv.domain.entity.whAreaSetting.InvWhAreaSettingDO;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaSettingDomainService;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaSettingRpcDTO;
import com.elitesland.yst.production.inv.dto.invwhAreaSetting.InvWhAreaSettingParamRpcDTO;
import com.elitesland.yst.production.inv.infr.dto.InvWhAreaSettingDTO;
import com.elitesland.yst.production.inv.infr.repo.whAreaSetting.InvWhAreaSettingRepo;
import com.elitesland.yst.production.inv.infr.repo.whAreaSetting.InvWhAreaSettingRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:功能区配置
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
@Service("InvWhAreaSettingDomainService")
@AllArgsConstructor
public class InvWhAreaSettingDomainServiceImpl implements InvWhAreaSettingDomainService {

    private final InvWhAreaSettingRepo invWhAreaSettingRepo;
    private final InvWhAreaSettingRepoProc invWhAreaSettingRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<InvWhAreaSettingDTO> search(InvWhAreaSettingParamVO param) {
        val pagingVo = invWhAreaSettingRepoProc.search(param);
        return pagingVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveInvWhAreaSetting(InvWhAreaSetting invWhAreaSetting, Optional<InvWhAreaSettingDTO> optional) {
        if (optional.isPresent()) {
            InvWhAreaSettingDTO invWhAreaSettingDTO = optional.get();
            //修改时，不可编辑
            invWhAreaSetting.setDeter2Type(invWhAreaSettingDTO.getDeter2Type());
            //修改
            invWhAreaSetting.setId(invWhAreaSettingDTO.getId());
            invWhAreaSetting.setCreator(invWhAreaSettingDTO.getCreator());
            invWhAreaSetting.setCreateUserId(invWhAreaSettingDTO.getCreateUserId());
            invWhAreaSetting.setCreateTime(invWhAreaSettingDTO.getCreateTime());
            invWhAreaSetting.setModifyTime(LocalDateTime.now());

        } else {
            invWhAreaSetting.setId(null);
            invWhAreaSetting.setCreateTime(LocalDateTime.now());
            invWhAreaSetting.setModifyTime(LocalDateTime.now());
        }
        InvWhAreaSettingDO invWhAreaSettingDO = InvWhAreaSettingConvert.INSTANCE.enToDo(invWhAreaSetting);
        Long id = invWhAreaSettingRepo.save(invWhAreaSettingDO).getId();
        return id;
    }

    /**
     * 根据ID查询功能区配置信息
     *
     * @param id 功能区配置ID
     * @return 功能区配置对象
     */
    @Override
    @SysCodeProc
    public Optional<InvWhAreaSettingDTO> findById(Long id) {
        return invWhAreaSettingRepo.findById(id).map(InvWhAreaSettingConvert.INSTANCE::doToDto);
    }

    @Override
    @SysCodeProc
    public Optional<InvWhAreaSettingDTO> findByDeter2(String deter2) {
        if (StringUtils.isEmpty(deter2)) {
            return Optional.empty();
        }
        InvWhAreaSettingParamVO param = new InvWhAreaSettingParamVO();
        param.setDeter2(deter2);
        JPAQuery<InvWhAreaSettingDTO> jpaQuery = invWhAreaSettingRepoProc.select(param);

        return Optional.of(jpaQuery.fetchFirst());
    }

    @Override
    @SysCodeProc
    public List<InvWhAreaSettingDTO> findByIdBatch(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.EMPTY_LIST;
        }
        List<InvWhAreaSettingDTO> whAreaSettingDTOList = invWhAreaSettingRepo.findAllById(idList).stream().map(InvWhAreaSettingConvert.INSTANCE::doToDto).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(whAreaSettingDTOList)) {
            return Collections.EMPTY_LIST;
        }

        return whAreaSettingDTOList;
    }

    @Override
    @SysCodeProc
    public List<InvWhAreaSettingDTO> findByDeter2Batch(List<String> deter2List) {
        if (CollectionUtils.isEmpty(deter2List)) {
            return Collections.EMPTY_LIST;
        }
        InvWhAreaSettingParamVO param = new InvWhAreaSettingParamVO();
        param.setDeter2List(deter2List);
        JPAQuery<InvWhAreaSettingDTO> jpaQuery = invWhAreaSettingRepoProc.select(param);
        List<InvWhAreaSettingDTO> invWhAreaSettingDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty(invWhAreaSettingDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return invWhAreaSettingDTOS;
    }


    @Override
    @SysCodeProc
    public List<InvWhAreaSettingDTO> selectByParam(InvWhAreaSettingParamVO param) {
        JPAQuery<InvWhAreaSettingDTO> jpaQuery = invWhAreaSettingRepoProc.select(param);
        List<InvWhAreaSettingDTO> invWhAreaSettingDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty(invWhAreaSettingDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return invWhAreaSettingDTOS;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList) {
        invWhAreaSettingRepoProc.updateDeleteFlagByIds(deleteFlag, idList).execute();
    }

    @Override
    public List<SelectOptionVO> listDeter2Type(SelectOptionParam param){
        return invWhAreaSettingRepoProc.listDeter2Type(param);
    }

    @Override
    public List<InvWhAreaSettingRespVO> findByDeter2Types(List<String> deter2Types) {
        if(CollectionUtils.isEmpty(deter2Types)){
            return new ArrayList<InvWhAreaSettingRespVO>();
        }
        return invWhAreaSettingRepoProc.findByDeter2Types(deter2Types);
    }

    @Override
    public List<InvWhAreaSettingRpcDTO> findWhAreaSettingRpcDTO(InvWhAreaSettingParamRpcDTO param) {
        return invWhAreaSettingRepoProc.findWhAreaSettingRpcDTO(param);
    }

}
