package com.elitesland.yst.production.inv.infr.repo.carr;


import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrRespVO;
import com.elitesland.yst.production.inv.domain.entity.carr.QInvCarrDDO;
import com.elitesland.yst.production.inv.domain.entity.carr.QInvCarrDO;
import com.elitesland.yst.production.inv.infr.repo.JpaQueryProcInterface;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * @author feng
 * @program: yst-inv
 * @description: 承运商配送单
 * @date 2021-09-19 11:17:26
 */
@Component
@RequiredArgsConstructor
public class InvCarrRepoProc implements JpaQueryProcInterface {

    private final JPAQueryFactory jpaQueryFactory;

    public JPAQuery<InvCarrRespVO> select(InvCarrParamVO param) {
        val jpaQDo = QInvCarrDO.invCarrDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvCarrRespVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.buId,
                jpaQDo.docNo,
                jpaQDo.docType,
                jpaQDo.docStatus,
                jpaQDo.shipmentDate,
                jpaQDo.qty,
                jpaQDo.poId,
                jpaQDo.suppId,
                jpaQDo.carrierSuppId,
                jpaQDo.carrierSuppCode,
                jpaQDo.suppDocNo,
                jpaQDo.crosswhFlag,
                jpaQDo.whId,
                jpaQDo.deter1,
                jpaQDo.deter2,
                jpaQDo.deter3,
                jpaQDo.deter4,
                jpaQDo.deter5,
                jpaQDo.deter6,
                jpaQDo.deter7,
                jpaQDo.deter8,
                jpaQDo.whLoc,
                jpaQDo.whPosi,
                jpaQDo.etaDate,
                jpaQDo.shipmentContactName,
                jpaQDo.shipmentContactTel,
                jpaQDo.rejectReason,
                jpaQDo.rejectTime,
                jpaQDo.rootId,
                jpaQDo.relateDocCls,
                jpaQDo.relateDocType,
                jpaQDo.relateDocId,
                jpaQDo.relateDocNo,
                jpaQDo.relateDoc2Cls,
                jpaQDo.relateDoc2Type,
                jpaQDo.relateDoc2Id,
                jpaQDo.relateDoc2No,
                jpaQDo.relateId,
                jpaQDo.relateNo,
                jpaQDo.relate2Id,
                jpaQDo.relate2No,
                jpaQDo.rootDocCls,
                jpaQDo.rootDocId,
                jpaQDo.rootDocNo,
                jpaQDo.rootDocType,
                jpaQDo.es1,
                jpaQDo.es2,
                jpaQDo.es3,
                jpaQDo.es4,
                jpaQDo.es5,
                jpaQDo.tenantId,
                jpaQDo.remark,
                jpaQDo.createUserId,
                jpaQDo.createTime,
                jpaQDo.modifyUserId,
                jpaQDo.modifyTime,
                jpaQDo.deleteFlag,
                jpaQDo.auditDataVersion,
                jpaQDo.amt,
                jpaQDo.recvAddr,
                jpaQDo.homeCurr,
                jpaQDo.currCode,
                jpaQDo.currRate,
                jpaQDo.taxCode,
                jpaQDo.recvEmpName,
                jpaQDo.recvEmpId,
                jpaQDo.tel,
                jpaQDo.detailAddr,
                jpaQDo.intfFlag,
                jpaQDo.acceptQty,
                jpaQDo.logisticsOuCode,
                jpaQDo.logisticsDocNo,
                jpaQDo.carNumber,
                jpaQDo.driver,
                jpaQDo.driverPhone,
                jpaQDo.packingQty,
                jpaQDo.totalWeight,
                jpaQDo.logisticsRemark,
                jpaQDo.deliveryDate,
                jpaQDo.creator
        )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    public Predicate where(InvCarrParamVO param) {
        val jpaQDo = QInvCarrDO.invCarrDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getBuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.buId.eq(param.getBuId()));
        }
        if (!StringUtils.isEmpty(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.docNo.eq(param.getDocNo()));
        }
        if (!StringUtils.isEmpty(param.getDocType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.docType.eq(param.getDocType()));
        }
        if (!StringUtils.isEmpty(param.getDocStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.docStatus.eq(param.getDocStatus()));
        }
        if (param.getShipmentDate() != null && param.getShipmentDate().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.shipmentDate.between(param.getShipmentDate().get(0), param.getShipmentDate().get(1)));
        }
        if (!StringUtils.isEmpty(param.getPoId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.poId.eq(param.getPoId()));
        }
        if (!StringUtils.isEmpty(param.getSuppId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.suppId.eq(param.getSuppId()));
        }
        if (!StringUtils.isEmpty(param.getSuppDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.suppDocNo.eq(param.getSuppDocNo()));
        }
        if (!StringUtils.isEmpty(param.getCrosswhFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.crosswhFlag.eq(param.getCrosswhFlag()));
        }
        if (!StringUtils.isEmpty(param.getWhId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.eq(param.getWhId()));
        }
        if (!StringUtils.isEmpty(param.getDeter1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter1.eq(param.getDeter1()));
        }
        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.eq(param.getDeter2()));
        }
        if (!StringUtils.isEmpty(param.getDeter3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter3.eq(param.getDeter3()));
        }
        if (!StringUtils.isEmpty(param.getDeter4())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter4.eq(param.getDeter4()));
        }
        if (!StringUtils.isEmpty(param.getDeter5())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter5.eq(param.getDeter5()));
        }
        if (!StringUtils.isEmpty(param.getDeter6())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter6.eq(param.getDeter6()));
        }
        if (!StringUtils.isEmpty(param.getDeter7())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter7.eq(param.getDeter7()));
        }
        if (!StringUtils.isEmpty(param.getDeter8())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter8.eq(param.getDeter8()));
        }
        if (!StringUtils.isEmpty(param.getWhLoc())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whLoc.eq(param.getWhLoc()));
        }
        if (!StringUtils.isEmpty(param.getWhPosi())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whPosi.eq(param.getWhPosi()));
        }
        if (!StringUtils.isEmpty(param.getEtaDate())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.etaDate.eq(param.getEtaDate()));
        }
        if (!StringUtils.isEmpty(param.getShipmentContactName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.shipmentContactName.eq(param.getShipmentContactName()));
        }
        if (!StringUtils.isEmpty(param.getShipmentContactTel())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.shipmentContactTel.eq(param.getShipmentContactTel()));
        }
        if (!StringUtils.isEmpty(param.getRejectReason())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.rejectReason.eq(param.getRejectReason()));
        }
        if (!StringUtils.isEmpty(param.getRejectTime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.rejectTime.eq(param.getRejectTime()));
        }
        if (!StringUtils.isEmpty(param.getRootId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.rootId.eq(param.getRootId()));
        }
        if (!StringUtils.isEmpty(param.getRelateDocCls())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDocCls.eq(param.getRelateDocCls()));
        }
        if (!StringUtils.isEmpty(param.getRelateDocType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDocType.eq(param.getRelateDocType()));
        }
        if (!StringUtils.isEmpty(param.getRelateDocId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDocId.eq(param.getRelateDocId()));
        }
        if (!StringUtils.isEmpty(param.getRelateDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDocNo.eq(param.getRelateDocNo()));
        }
        if (!StringUtils.isEmpty(param.getRelateDoc2Cls())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDoc2Cls.eq(param.getRelateDoc2Cls()));
        }
        if (!StringUtils.isEmpty(param.getRelateDoc2Type())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDoc2Type.eq(param.getRelateDoc2Type()));
        }
        if (!StringUtils.isEmpty(param.getRelateDoc2Id())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDoc2Id.eq(param.getRelateDoc2Id()));
        }
        if (!StringUtils.isEmpty(param.getRelateDoc2No())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateDoc2No.eq(param.getRelateDoc2No()));
        }
        if (!StringUtils.isEmpty(param.getRelateId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateId.eq(param.getRelateId()));
        }
        if (!StringUtils.isEmpty(param.getRelateNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateNo.eq(param.getRelateNo()));
        }
        if (!StringUtils.isEmpty(param.getRelate2Id())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relate2Id.eq(param.getRelate2Id()));
        }
        if (!StringUtils.isEmpty(param.getRelate2No())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relate2No.eq(param.getRelate2No()));
        }

        if((!StringUtils.isEmpty(param.getRecvEmpIds())) && param.getRecvEmpIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.recvEmpId.in(param.getRecvEmpIds()));
        }
        if (param.getDeliveryDateStart() != null && param.getDeliveryDateEnd() != null){
            predicate = ExpressionUtils.and(predicate,jpaQDo.deliveryDate.between(param.getDeliveryDateStart(),param.getDeliveryDateEnd()));
        }
        if (!CollectionUtils.isEmpty(param.getItemIds())){
            predicate = ExpressionUtils.and(predicate,jpaQDo.id.in(subQuery(param)));
        }
        if (param.getCreateUserId() != null){
            predicate = ExpressionUtils.and(predicate,jpaQDo.createUserId.eq(param.getCreateUserId()));
        }
        if (param.getCarrierSuppId() != null){
            predicate = ExpressionUtils.and(predicate,jpaQDo.carrierSuppId.eq(param.getCarrierSuppId()));
        }
        if (!CollectionUtils.isEmpty(param.getIds())){
            predicate = ExpressionUtils.and(predicate,jpaQDo.id.in(param.getIds()));
        }

        return predicate;
    }

    private List<Long> subQuery(InvCarrParamVO param) {
        val invCarrDDO = QInvCarrDDO.invCarrDDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (!CollectionUtils.isEmpty(param.getItemIds())){
            predicate = ExpressionUtils.and(predicate,invCarrDDO.itemId.in(param.getItemIds()));
        }
        return jpaQueryFactory.select(invCarrDDO.masId).from(invCarrDDO).where(predicate).fetch();
    }

    public void updateInvCarrStatus(List<Long> ids, String docStatus){
        val jpaDo =  QInvCarrDO.invCarrDO;
        jpaQueryFactory.update(jpaDo).set(jpaDo.docStatus,docStatus).where(jpaDo.id.in(ids)).execute();
    }
    public void updateInvCarrStatusByRelateDocId(Long relateDocId,String docStatus){
        val jpaDo =  QInvCarrDO.invCarrDO;
        jpaQueryFactory.update(jpaDo).set(jpaDo.docStatus,docStatus).where(jpaDo.relateDocId.eq(relateDocId)).execute();
    }

}
