package com.elitesland.yst.production.inv.infr.repo.invwh;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public interface JpaQueryProcInterface {
    /**
     * 排序与分页
     *  classObj是继承EntityPathBase的QueryDSL生成的对象 里面存储了对象信息.
     * **/
    default void openOrderAndLimit(JPAQuery jpaQuery, AbstractOrderQueryParam abstractOrderQueryParam, EntityPathBase classObj){
        openOrder( jpaQuery,  abstractOrderQueryParam, classObj);
        openLimit( jpaQuery,  abstractOrderQueryParam);
    }

    default void openLimit(JPAQuery jpaQuery, AbstractOrderQueryParam abstractOrderQueryParam){
        /**如果是0 设置1.  前端传参是1开始, 后端是0开始**/
        if(abstractOrderQueryParam.getCurrent()!=null&&abstractOrderQueryParam.getCurrent() ==0){
            abstractOrderQueryParam.setCurrent(1);
        }
        jpaQuery.limit(abstractOrderQueryParam.getSize())
                .offset((abstractOrderQueryParam.getCurrent() ) * abstractOrderQueryParam.getSize());
    }
    /**
     * 设置排序路径映射
     * abstractOrderQueryParam 里面需要有order参数
     * classObj是继承EntityPathBase的QueryDSL生成的对象 里面存储了对象信息.
     * 重写排序
     * 参考见:http://www.querydsl.com/static/querydsl/3.6.4/apidocs/com/mysema/query/types/path/PathBuilder.html#PathBuilder(java.lang.Class,%20com.mysema.query.types.PathMetadata)
     * **/
    default void openOrder(JPAQuery jpaQuery, AbstractOrderQueryParam abstractOrderQueryParam, EntityPathBase classObj){
        PageRequest pageRequest= abstractOrderQueryParam.getPageRequest();
        for (Sort.Order o : pageRequest.getSort()) {
            PathBuilder orderByExpression = new PathBuilder(classObj.getClass(),
                    classObj.getMetadata().getElement().toString());
            PathBuilder<Object> objectPathBuilder=    orderByExpression.get(o.getProperty());
            jpaQuery.orderBy(new OrderSpecifier(o.isAscending() ?  Order.ASC
                    : Order.DESC,objectPathBuilder ));
        }
    }
}
