package com.elitesland.yst.production.inv.infr.repo.lot;


import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotAllRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCombineParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvStkDParam;
import com.elitesland.yst.production.inv.domain.entity.invstk.QInvStkDO;
import com.elitesland.yst.production.inv.domain.entity.lot.QInvLotDO;
import com.elitesland.yst.production.inv.infr.dto.InvLotDTO;
import com.elitesland.yst.production.inv.infr.dto.InvLotStkDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.List;



/**
 * <p>
 * 批次主档
 * </p>
 *
 * @author ssy
 * @since 2020-07-30 15:08:01
 */
@Component
@AllArgsConstructor
public class InvLotRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QInvLotDO invLotDO = QInvLotDO.invLotDO;
    /**
     * 封装select查询
     * @return
     */
    public PagingVO<InvLotDTO> useSelect(InvLotParam param){
        JPAQuery<InvLotDTO> jpaQuery = select(null).where(where(param));
        param.fillOrders(jpaQuery, invLotDO);
        param.setPaging(jpaQuery);

        val records = jpaQuery.fetch();
        return PagingVO.<InvLotDTO>builder()
                .total(jpaQuery.fetchCount())
                .records(records)
                .build();
    }

    /**
     * 查询字段
     */
    public JPAQuery<InvLotDTO> select(InvLotParam param) {
        val jpaQDo = invLotDO;
        JPAQuery<InvLotDTO> jpaQuery = getInvLotDTOJPAQuery(jpaQDo);

        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return jpaQuery;
    }

    private JPAQuery<InvLotDTO> getInvLotDTOJPAQuery(QInvLotDO jpaQDo) {
        return jpaQueryFactory.select(Projections.bean(InvLotDTO.class,
                    jpaQDo.id,
                    jpaQDo.ouId,
                    jpaQDo.buId,
                    jpaQDo.itemId,
                    jpaQDo.variId,
                    jpaQDo.itemCode,
                    jpaQDo.lotNo,
                    jpaQDo.lotDesc,
                    jpaQDo.lotStatus,
                    jpaQDo.lotStatus2,
                    jpaQDo.lotStatus3,
                    jpaQDo.qcStatus,
                    jpaQDo.sinStatus,
                    jpaQDo.lockReason,
                    jpaQDo.sinQty,
                    jpaQDo.expireDays,
                    jpaQDo.manuDate,
                    jpaQDo.menuLotNo,
                    jpaQDo.batchNo,
                    jpaQDo.expireDate,
                    jpaQDo.untilExpireDays,
                    jpaQDo.fressType,
                    jpaQDo.firstInDate,
                    jpaQDo.lastOutDate,
                    jpaQDo.maxSaleDate,
                    jpaQDo.menuCountry,
                    jpaQDo.menuDesc,
                    jpaQDo.menuDocNo,
                    jpaQDo.manuerId,
                    jpaQDo.manuerCode,
                    jpaQDo.manuerName,
                    jpaQDo.suppId,
                    jpaQDo.sinId,
                    jpaQDo.sinNo,
                    jpaQDo.sinDate,
                    jpaQDo.ownerType,
                    jpaQDo.ownerId,
                    jpaQDo.ownerCode,
                    jpaQDo.srcDocCls,
                    jpaQDo.srcDocId,
                    jpaQDo.srcDocNo,
                    jpaQDo.srcDocDid,
                    jpaQDo.poId,
                    jpaQDo.poNo,
                    jpaQDo.poType,
                    jpaQDo.poDId,
                    jpaQDo.es1,
                    jpaQDo.es2,
                    jpaQDo.es3,
                    jpaQDo.es4,
                    jpaQDo.es5,
                jpaQDo.date1,
                jpaQDo.date2,
                jpaQDo.date3,
                jpaQDo.date4,
                jpaQDo.date5,
                    jpaQDo.tenantId,
                    jpaQDo.remark,
                    jpaQDo.createUserId,
                    jpaQDo.createTime,
                    jpaQDo.modifyUserId,
                    jpaQDo.modifyTime,
                    jpaQDo.deleteFlag,
                    jpaQDo.auditDataVersion
            )).from(jpaQDo);
    }

    public JPAQuery<InvLotRespVO> selectCombine(InvLotCombineParam param) {
        val jpaQDo = invLotDO;
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvLotRespVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.buId,
                jpaQDo.itemId,
                jpaQDo.variId,
                jpaQDo.itemCode,
                jpaQDo.lotNo,
                jpaQDo.lotDesc,
                jpaQDo.lotStatus,
                jpaQDo.lotStatus2,
                jpaQDo.lotStatus3,
                jpaQDo.qcStatus,
                jpaQDo.sinStatus,
                jpaQDo.lockReason,
                jpaQDo.sinQty,
                jpaQDo.expireDays,
                jpaQDo.manuDate,
                jpaQDo.menuLotNo,
                jpaQDo.batchNo,
                jpaQDo.expireDate,
                jpaQDo.untilExpireDays,
                jpaQDo.fressType,
                jpaQDo.firstInDate,
                jpaQDo.lastOutDate,
                jpaQDo.maxSaleDate,
                jpaQDo.menuCountry,
                jpaQDo.menuDesc,
                jpaQDo.menuDocNo,
                jpaQDo.manuerId,
                jpaQDo.manuerCode,
                jpaQDo.manuerName,
                jpaQDo.suppId,
                jpaQDo.sinId,
                jpaQDo.sinNo,
                jpaQDo.sinDate,
                jpaQDo.ownerType,
                jpaQDo.ownerId,
                jpaQDo.ownerCode,
                jpaQDo.srcDocCls,
                jpaQDo.srcDocId,
                jpaQDo.srcDocNo,
                jpaQDo.srcDocDid,
                jpaQDo.poId,
                jpaQDo.poNo,
                jpaQDo.poType,
                jpaQDo.poDId,
                jpaQDo.es1,
                jpaQDo.es2,
                jpaQDo.es3,
                jpaQDo.es4,
                jpaQDo.es5,
                jpaQDo.date1,
                jpaQDo.date2,
                jpaQDo.date3,
                jpaQDo.date4,
                jpaQDo.date5,
                jpaQDo.tenantId,
                jpaQDo.remark,
                jpaQDo.createUserId,
                jpaQDo.createTime,
                jpaQDo.modifyUserId,
                jpaQDo.modifyTime,
                jpaQDo.deleteFlag,
                jpaQDo.auditDataVersion
        )).from(jpaQDo);

        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return jpaQuery;
    }

    /**
     * 查询表头字段
     */
    public JPAQuery<InvLotAllRespVO> selectHeader() {
        val invlot = invLotDO;
//        val purpo = QPurPoDO.purPoDO;
//        val itmitem = QItmItemDO.itmItemDO;
//        val
        return jpaQueryFactory.select(Projections.bean(
                InvLotAllRespVO.class,
                invlot.id,
                invlot.lotNo,
                invlot.lotDesc,
                invlot.itemId,
//                itmitem.itemName,
                invlot.menuLotNo,
                invlot.manuDate,
                invlot.expireDate,
                invlot.poNo,
                invlot.poType,
//                purpo.docStatus,
                invlot.ouId,
                invlot.qcStatus,
                invlot.sinQty,
                invlot.sinStatus,
                invlot.sinNo,
                invlot.lockReason,
                invlot.srcDocCls,
                invlot.srcDocNo,
                invlot.remark,
                invlot.firstInDate

        )).from(invlot)
//                .leftJoin(purpo).on(invlot.poId.eq(purpo.id))
//                .leftJoin(itmitem).on(invlot.itemId.eq(itmitem.id))
                ;


    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     */
    public Predicate where(Long id) {
        val jpaQDo = invLotDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
        return predicate;
    }

    public Predicate where(InvLotCombineParam param) {
        val jpaQDo = invLotDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
//        predicate = StringUtils.isEmpty(param.getLotNo()) ? predicate :
//                ExpressionUtils.and(predicate, jpaQDo.lotNo.eq(param.getLotNo()));
//        predicate = StringUtils.isEmpty(param.getOuIds()) ? predicate :
//                ExpressionUtils.and(predicate, jpaQDo.ouId.in(param.getOuIds()));
        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lotNo.in(param.getLotNo()));
        }
        if (param.getOuIds() != null && param.getOuIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.in(param.getOuIds()));
        }
        if (param.getItemIds() != null && param.getItemIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemId.in(param.getItemIds()));
        }
        // 批次创建日期
        if (param.getFirstInDates() != null && param.getFirstInDates().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.firstInDate.between(param.getFirstInDates().get(0), param.getFirstInDates().get(1)));
        }
        if (!StringUtils.isEmpty(param.getSrcDocCls())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocCls.eq(param.getSrcDocCls()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocNo.like("%" + param.getSrcDocNo() + "%"));
        }
        if (param.getSuppIds() != null && param.getSuppIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.suppId.in(param.getSuppIds()));
        }
        if (param.getManuDates() != null && param.getManuDates().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.manuDate.between(param.getManuDates().get(0), param.getManuDates().get(1)));
        }
        if (!StringUtils.isEmpty(param.getMenuLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.menuLotNo.like("%" + param.getMenuLotNo() + "%"));
        }

        if (!StringUtils.isEmpty(param.getQcStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.qcStatus.eq(param.getQcStatus()));
        }
        if (param.getExpireDates() != null && param.getExpireDates().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.expireDate.between(param.getExpireDates().get(0), param.getExpireDates().get(1)));
        }
        return predicate;
    }

    /**
     * 前端分页专用
     */
    public Predicate searchWhere(InvLotCombineParam param) {
        val jpaQDo = invLotDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());

        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lotNo.like("%" + param.getLotNo() + "%"));
        }
        if (param.getOuIds() != null && param.getOuIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.in(param.getOuIds()));
        }
        if (param.getBuIds() != null && param.getBuIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.buId.in(param.getBuIds()));
        }
        if (param.getItemIds() != null && param.getItemIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemId.in(param.getItemIds()));
        }
        if (param.getSuppIds() != null && param.getSuppIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.suppId.in(param.getSuppIds()));
        }
        if (param.getFirstInDates() != null && param.getFirstInDates().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.firstInDate.between(param.getFirstInDates().get(0), param.getFirstInDates().get(1)));
        }
        if (param.getManuDates() != null && param.getManuDates().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.manuDate.between(param.getManuDates().get(0), param.getManuDates().get(1)));
        }
        if (param.getExpireDates() != null && param.getExpireDates().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.expireDate.between(param.getExpireDates().get(0), param.getExpireDates().get(1)));
        }
        if (!StringUtils.isEmpty(param.getSrcDocCls())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocCls.like("%" + param.getSrcDocCls() + "%"));
        }
        if (!StringUtils.isEmpty(param.getSrcDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocNo.like("%" + param.getSrcDocNo() + "%"));
        }
        if (!StringUtils.isEmpty(param.getMenuLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.menuLotNo.like("%" + param.getMenuLotNo() + "%"));
        }

        if (!StringUtils.isEmpty(param.getQcStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.qcStatus.like("%" + param.getQcStatus() + "%"));
        }

        if (!StringUtils.isEmpty(param.getExpireDate())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.expireDate.eq(param.getExpireDate()));
        }

        if (!StringUtils.isEmpty(param.getFirstInDate())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.firstInDate.eq(param.getFirstInDate()));
        }

        if (!StringUtils.isEmpty(param.getManuDate())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.manuDate.eq(param.getManuDate()));
        }

        return predicate;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(InvLotParam param) {
        val jpaQDo = invLotDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getBuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.buId.eq(param.getBuId()));
        }
        if (!StringUtils.isEmpty(param.getItemId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemId.eq(param.getItemId()));
        }
//        if (!StringUtils.isEmpty(param.getVariId())) {
//            if(param.getVariId() == 0L){
//                predicate = ExpressionUtils.and(predicate, jpaQDo.variId.eq(0L).or(jpaQDo.variId.isNull()));
//            }else {
//                predicate = ExpressionUtils.and(predicate, jpaQDo.variId.eq(param.getVariId()));
//            }
//        }else{
//            predicate = ExpressionUtils.and(predicate, jpaQDo.variId.eq(0L).or(jpaQDo.variId.isNull()));
//        }
        if (!StringUtils.isEmpty(param.getItemCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemCode.eq(param.getItemCode()));
        }
        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lotNo.eq(param.getLotNo()));
        }
        if (!StringUtils.isEmpty(param.getLotDesc())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lotDesc.eq(param.getLotDesc()));
        }
        if (!StringUtils.isEmpty(param.getLotStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lotStatus.eq(param.getLotStatus()));
        }
        if (!StringUtils.isEmpty(param.getLotStatus2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lotStatus2.eq(param.getLotStatus2()));
        }
        if (!StringUtils.isEmpty(param.getLotStatus3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lotStatus3.eq(param.getLotStatus3()));
        }
        if (!StringUtils.isEmpty(param.getQcStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.qcStatus.eq(param.getQcStatus()));
        }
        if (!StringUtils.isEmpty(param.getSinStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.sinStatus.eq(param.getSinStatus()));
        }
        if (!StringUtils.isEmpty(param.getLockReason())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lockReason.eq(param.getLockReason()));
        }
        if (!StringUtils.isEmpty(param.getSinQty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.sinQty.eq(param.getSinQty()));
        }
        if (!StringUtils.isEmpty(param.getExpireDays())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.expireDays.eq(param.getExpireDays()));
        }
        if (!StringUtils.isEmpty(param.getManuDate())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.manuDate.eq(param.getManuDate()));
        }
        if (!StringUtils.isEmpty(param.getMenuLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.menuLotNo.eq(param.getMenuLotNo()));
        }
        if (!StringUtils.isEmpty(param.getBatchNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.batchNo.eq(param.getBatchNo()));
        }
        if (!StringUtils.isEmpty(param.getExpireDate())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.expireDate.eq(param.getExpireDate()));
        }
        if (!StringUtils.isEmpty(param.getUntilExpireDays())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.untilExpireDays.eq(param.getUntilExpireDays()));
        }
        if (!StringUtils.isEmpty(param.getFressType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.fressType.eq(param.getFressType()));
        }
        if (!StringUtils.isEmpty(param.getFirstInDate())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.firstInDate.eq(param.getFirstInDate()));
        }
        if (!StringUtils.isEmpty(param.getLastOutDate())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lastOutDate.eq(param.getLastOutDate()));
        }
        if (!StringUtils.isEmpty(param.getMaxSaleDate())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.maxSaleDate.eq(param.getMaxSaleDate()));
        }
        if (!StringUtils.isEmpty(param.getMenuCountry())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.menuCountry.eq(param.getMenuCountry()));
        }
        if (!StringUtils.isEmpty(param.getMenuDesc())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.menuDesc.eq(param.getMenuDesc()));
        }
        if (!StringUtils.isEmpty(param.getMenuDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.menuDocNo.eq(param.getMenuDocNo()));
        }
        if (!StringUtils.isEmpty(param.getManuerId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.manuerId.eq(param.getManuerId()));
        }
        if (!StringUtils.isEmpty(param.getManuerCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.manuerCode.eq(param.getManuerCode()));
        }
        if (!StringUtils.isEmpty(param.getManuerName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.manuerName.eq(param.getManuerName()));
        }
        if (!StringUtils.isEmpty(param.getSuppId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.suppId.eq(param.getSuppId()));
        }
        if (!StringUtils.isEmpty(param.getSinId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.sinId.eq(param.getSinId()));
        }
        if (!StringUtils.isEmpty(param.getSinNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.sinNo.eq(param.getSinNo()));
        }
        if (!StringUtils.isEmpty(param.getSinDate())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.sinDate.eq(param.getSinDate()));
        }
        if (!StringUtils.isEmpty(param.getOwnerType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ownerType.eq(param.getOwnerType()));
        }
        if (!StringUtils.isEmpty(param.getOwnerId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ownerId.eq(param.getOwnerId()));
        }
        if (!StringUtils.isEmpty(param.getOwnerCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ownerCode.eq(param.getOwnerCode()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocCls())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocCls.eq(param.getSrcDocCls()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocId.eq(param.getSrcDocId()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocNo.eq(param.getSrcDocNo()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocDid())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocDid.eq(param.getSrcDocDid()));
        }
        if (!StringUtils.isEmpty(param.getPoId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.poId.eq(param.getPoId()));
        }
        if (!StringUtils.isEmpty(param.getPoNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.poNo.eq(param.getPoNo()));
        }
        if (!StringUtils.isEmpty(param.getPoType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.poType.eq(param.getPoType()));
        }
        if (!StringUtils.isEmpty(param.getPoDId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.poDId.eq(param.getPoDId()));
        }
        if (!StringUtils.isEmpty(param.getEs1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es1.eq(param.getEs1()));
        }
        if (!StringUtils.isEmpty(param.getEs2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es2.eq(param.getEs2()));
        }
        if (!StringUtils.isEmpty(param.getEs3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es3.eq(param.getEs3()));
        }
        if (!StringUtils.isEmpty(param.getEs4())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es4.eq(param.getEs4()));
        }
        if (!StringUtils.isEmpty(param.getEs5())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es5.eq(param.getEs5()));
        }
        if (!StringUtils.isEmpty(param.getTenantId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.tenantId.eq(param.getTenantId()));
        }
        if (!StringUtils.isEmpty(param.getRemark())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.remark.eq(param.getRemark()));
        }
        if (!StringUtils.isEmpty(param.getCreateUserId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.createUserId.eq(param.getCreateUserId()));
        }
        if (!StringUtils.isEmpty(param.getCreateTime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.createTime.eq(param.getCreateTime()));
        }
        if (!StringUtils.isEmpty(param.getModifyUserId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.modifyUserId.eq(param.getModifyUserId()));
        }
        if (!StringUtils.isEmpty(param.getModifyTime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.modifyTime.eq(param.getModifyTime()));
        }
        if (!StringUtils.isEmpty(param.getDeleteFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deleteFlag.eq(param.getDeleteFlag()));
        }
        if (!StringUtils.isEmpty(param.getAuditDataVersion())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.auditDataVersion.eq(param.getAuditDataVersion()));
        }
        return predicate;
    }

    public JPAQuery<InvLotDTO> findAllByItemIdAndLotNoAndVariId(InvLotParam param) {
        val jpaQDo = invLotDO;
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvLotDTO.class,
                jpaQDo.id,
                jpaQDo.itemId,
                jpaQDo.variId,
                jpaQDo.lotNo,
                jpaQDo.manuDate,
                jpaQDo.expireDate,
                jpaQDo.sinNo
        )).from(jpaQDo);

//            jpaQuery.where(where2(param));
        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = StringUtils.isEmpty(param.getLotNo()) ? predicate
                    : ExpressionUtils.and(predicate, jpaQDo.lotNo.eq(param.getLotNo()));
        } else {
            predicate = !StringUtils.isEmpty(param.getLotNo()) ? predicate
                    : ExpressionUtils.and(predicate, jpaQDo.lotNo.isNull());
        }
        if (!StringUtils.isEmpty(param.getItemId())) {
            predicate = StringUtils.isEmpty(param.getItemId()) ? predicate
                    : ExpressionUtils.and(predicate, jpaQDo.itemId.eq(param.getItemId()));
        } else {
            predicate = !StringUtils.isEmpty(param.getItemId()) ? predicate
                    : ExpressionUtils.and(predicate, jpaQDo.itemId.isNull());
        }
        if (!StringUtils.isEmpty(param.getVariId())) {
            predicate = StringUtils.isEmpty(param.getVariId()) ? predicate
                    : ExpressionUtils.and(predicate, jpaQDo.variId.eq(param.getVariId()));
        } else {
            predicate = !StringUtils.isEmpty(param.getVariId()) ? predicate
                    : ExpressionUtils.and(predicate, jpaQDo.variId.isNull());
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));

        return jpaQuery;
    }

    /**
     * 封装selectD查询方法
     */
    public PagingVO<InvLotStkDTO> useSelectD(InvStkDParam param){
        JPAQuery<InvLotStkDTO> invStkDJPAQuery =selectD(param);
        param.fillOrders(invStkDJPAQuery);
        param.setPaging(invStkDJPAQuery);
        List<InvLotStkDTO> fetch = invStkDJPAQuery.fetch();
        return PagingVO.<InvLotStkDTO>builder()
                .total(invStkDJPAQuery.fetchCount())
                .records(fetch)
                .build();
    }
    /**
     * 批次主档关联库存余额
     */
    public JPAQuery<InvLotStkDTO> selectD(InvStkDParam param) {
        val invLotDO = QInvLotDO.invLotDO;
        val invStkDO = QInvStkDO.invStkDO;
        return jpaQueryFactory.select(
                Projections.bean(
                        InvLotStkDTO.class,
                        invLotDO.id,
                        invLotDO.buId,
                        invLotDO.itemId,
                        invLotDO.variId,
                        invLotDO.itemCode,
                        invLotDO.lotNo,
                        invLotDO.menuLotNo,
                        invLotDO.sinNo,
                        invLotDO.sinQty,
                        invLotDO.manuDate,
                        invLotDO.expireDate,
                        invLotDO.es1,
                        invLotDO.es2,
                        invLotDO.es3,
                        invLotDO.es4,
                        invLotDO.es5,
                        invLotDO.date1,
                        invLotDO.date2,
                        invLotDO.date3,
                        invLotDO.date4,
                        invLotDO.date5,

                        invStkDO.ouId,
                        invStkDO.whId,
                        invStkDO.deter1,
                        invStkDO.deter2,
                        invStkDO.deter3,
                        invStkDO.inDate,
                        invStkDO.untilExpireDays,
                        invStkDO.fressType,
                        invStkDO.uom,
                        invStkDO.uom2,
                        invStkDO.uomRatio,
                        invStkDO.uomRatio2,
                        invStkDO.ohQty,
                        invStkDO.rsvQty,
                        invStkDO.rsvQty2,
                        invStkDO.lockQty,
                        invStkDO.avalQty,
                        invStkDO.amt,
                        invStkDO.stkDesc,
                        invStkDO.stkDesc2,
                        invStkDO.srcDocCls,
                        invStkDO.srcDocId,
                        invStkDO.srcDocDid,
                        invStkDO.srcDocCls2,
                        invStkDO.srcDocId2,
                        invStkDO.srcDocDid2
                )
        ).from(invLotDO)
                .leftJoin(invStkDO).on(invLotDO.itemId.eq(invStkDO.itemId),
                        invLotDO.lotNo.eq(invStkDO.lotNo),
                        StringUtils.isEmpty(param.getDeter3())?
                            invStkDO.deter1.eq(param.getDeter1()).and(invStkDO.deter2.eq(param.getDeter2())):
                                invStkDO.deter3.eq(param.getDeter3()),
                        invStkDO.whId.in(param.getWhIds())
                )
                .where(whereD(param), invLotDO.deleteFlag.eq(0).or(invLotDO.deleteFlag.isNull())).distinct();
    }

    public Predicate whereD(InvStkDParam param) {
        val invLotDO = QInvLotDO.invLotDO;
        val invStkDO = QInvStkDO.invStkDO;

        Predicate predicate = invLotDO.isNotNull();
        if (!StringUtils.isEmpty(param.getItemId())) {
            predicate = ExpressionUtils.and(predicate, invLotDO.itemId.eq(param.getItemId()));
        }
        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, invLotDO.lotNo.like("%" + param.getLotNo() + "%"));
        }
        if (!StringUtils.isEmpty(param.getMultiKeywords())) {
            predicate = ExpressionUtils.and(predicate, invLotDO.lotNo.like("%" + param.getMultiKeywords() + "%"));
        }


        return predicate;
    }

    public JPAUpdateClause updateDeleteFlagById(Integer deleteFlag, Long id) {
        val jpaQDo = QInvLotDO.invLotDO;
        Predicate predicate = jpaQDo.isNotNull();
        return jpaQueryFactory.update(jpaQDo)
                .set(jpaQDo.deleteFlag, deleteFlag)
                .where(ExpressionUtils.and(predicate, jpaQDo.id.eq(id)));
    }

}
