package com.elitesland.yst.production.inv.utils;

import lombok.Getter;

/**
 * <p>
 * 库存共通方法28入参
 * /p >
 *
 * @author ssy
 * @date 2020/8/13
 */
@Getter
public enum InvStk28Enum {

    /**
     * 销售出库
     */
    O_TYPE_01_01("O_TYPE_01_01", "销售出库", "销售出库减", "O", "O"),
//    O_TYPE_01_02("O_TYPE_01_02", "销售出库", "销售出库硬承诺减", "O", "O"),

    I_TYPE_02("I_TYPE_02", "采购收货", "采购收货", "I", "I"),
    I_TYPE_19("I_TYPE_19", "供应商合作库拒收入库", "供应商合作库拒收入库", "I", "I"),
    O_TYPE_03("O_TYPE_03", "采购退货出库", "采购退货出库", "O", "O"),
    I_TYPE_04("I_TYPE_04", "库存调整增", "库存调整增", "I", "I"),
    O_TYPE_05("O_TYPE_05", "库存调整减", "库存调整减", "O", "O"),

    I_TYPE_06("I_TYPE_06", "销售退货入库", "销售退货入库", "I", "I"),

    //销售分配
    T_TYPE_07_01("T_TYPE_07_01", "销售库存自动分配", "销售订单配货锁定增", "T", "T"),
    T_TYPE_07_02("T_TYPE_07_02", "销售库存自动分配", "销售订单配货锁定减", "T", "T"),
    T_TYPE_07_03("T_TYPE_07_03", "销售库存自动分配", "销售分配预留增", "T", "T"),
    T_TYPE_07_04("T_TYPE_07_04", "销售库存自动分配", "销售分配预留减", "T", "T"),

    //库存预留
    T_TYPE_10("T_TYPE_10", "库存预留新增", "库存预留增", "T", "T"),
    T_TYPE_11("T_TYPE_11", "库存预留修改", "库存预留减", "T", "T"),
    T_TYPE_12("T_TYPE_12", "库存预留自动释放", "库存预留自动释放", "T", "T"),
    T_TYPE_13("T_TYPE_13", "库存预留手动释放", "库存预留手动释放", "T", "T"),

    //寄售
    O_TYPE_14("O_TYPE_14", "寄售仓调出", "供应商合作库出库", "O", "O"),
    I_TYPE_15("I_TYPE_15", "寄售仓调入", "供应商合作库入库", "I", "I"),

    //库存转移及组装
    I_TYPE_16("I_TYPE_16", "库存移入", "库存移入", "I", "I"),
    O_TYPE_17("O_TYPE_17", "库存移出", "库存移出", "O", "O"),
    I_TYPE_18("I_TYPE_18", "库存组装入", "库存组装入", "I", "I"),
    O_TYPE_19("O_TYPE_19", "库存组装出", "库存组装出", "O", "O"),

    // 库存锁定专用属性
    T_TYPE_20("T_TYPE_20", "采购退货制单锁定增", "采购退货制单锁定增", "T", "T"),
    T_TYPE_21("T_TYPE_21", "库存转移制单锁定增", "库存转移制单锁定增", "T", "T"),
    T_TYPE_22("T_TYPE_22", "库存调整制单锁定增", "库存调整制单锁定增", "T", "T"),
    T_TYPE_23("T_TYPE_23", "库存组装制单锁定增", "库存组装制单锁定增", "T", "T"),
    T_TYPE_24("T_TYPE_24", "采购退货制单锁定减", "采购退货制单锁定减", "T", "T"),
    T_TYPE_25("T_TYPE_25", "库存转移制单锁定减", "库存转移制单锁定减", "T", "T"),
    T_TYPE_26("T_TYPE_26", "库存调整制单锁定减", "库存调整制单锁定减", "T", "T"),
    T_TYPE_27("T_TYPE_27", "库存组装制单锁定减", "库存组装制单锁定减", "T", "T"),
    ;

    private final String ioCode;
    private final String ioName;
    private final String ioFlag;
    private final String ioType;
    private final String type;

    InvStk28Enum(final String ioCode, final String type, final String ioName, final String ioFlag, final String ioType) {
        this.ioCode = ioCode;
        this.type = type;
        this.ioName = ioName;
        this.ioFlag = ioFlag;
        this.ioType = ioType;
    }

}
