package com.elitesland.yst.production.inv.utils;

import lombok.Getter;

/**
 * @ProjectName: yst-dch-score
 * @Package: com.elitesland.common
 * @ClassName: UdcEnum
 * @Author: chen
 * @Description: udc枚举
 * @Date: 2020/7/7 15:22
 * @Version: 1.0
 */
@Getter
public enum UdcEnum {
    //数据库sql拼接：SELECT CONCAT(domain_code,'_',udc_code,'_',udc_val,'("',domain_code,'","',udc_code,'","',udc_name,'","',udc_val,'","',val_desc,'"),') FROM sys_udc ORDER BY domain_code,udc_name
    COM_IO_I("yst-supp","IO","出入","I","入"),
    COM_IO_O("yst-supp","IO","出入","O","出"),
    ORG_OU_TYPE_10("yst-supp","OU_TYPE","公司类型","10","集团公司"),
    ORG_OU_TYPE_20("yst-supp","OU_TYPE","公司类型","20","区域公司"),
    ORG_OU_TYPE_30("yst-supp","OU_TYPE","公司类型","30","分子公司"),
    OU_STATUS_ACTIVE("ORG", "OU_STATUS", "OU状态", "ACTIVE", "正常"),
    COM_DOC_CLS_SPA("yst-supp","DOC_CLS","单据类别","SPA","销售价格变更单"),
    COM_DOC_CLS_PO("yst-supp","DOC_CLS","单据类别","PO","采购订单"),
    COM_DOC_CLS_SS("yst-supp","DOC_CLS","单据类别","SS","供应商发货单"),
    COM_DOC_CLS_GR("yst-supp","DOC_CLS","单据类别","GR","采购收货单"),
    COM_DOC_CLS_PRMA("yst-supp","DOC_CLS","单据类别","PRMA","采购RMA"),
    COM_DOC_CLS_RNS("yst-supp","DOC_CLS","单据类别","RNS","采购退货单"),
    COM_DOC_CLS_OP("yst-supp","DOC_CLS","单据类别","OP","旧件返还单"),
    COM_DOC_CLS_SO("yst-supp","DOC_CLS","单据类别","SO","销售订单"),
    COM_DOC_CLS_DO("yst-supp","DOC_CLS","单据类别","DO","销售发货单"),
    SAL_SELL_METHOD_2("SAL","SELL_METHOD","出货方式","2","总部"),
    SAL_SELL_METHOD_1("SAL","SELL_METHOD","出货方式","1","本公司"),
    COM_DOC_CLS_SRMA("yst-supp","DOC_CLS","单据类别","SRMA","销售RMA"),
    COM_DOC_CLS_RSO("yst-supp","DOC_CLS","单据类别","RSO","销售退货单"),
    COM_DOC_CLS_RDO("yst-supp","DOC_CLS","单据类别","RDO","退货入库单"),
    COM_DOC_CLS_SIN("yst-supp","DOC_CLS","单据类别","SIN","卫检单"),
    COM_DOC_CLS_RO("yst-supp","DOC_CLS","单据类别","RO","预留单"),
    COM_DOC_CLS_STKAJ("yst-supp","DOC_CLS","单据类别","STKIN","库存调整单"),
    COM_DOC_CLS_STKOUT("yst-supp","DOC_CLS","单据类别","STKOUT","调整出库单"),
    COM_DOC_CLS_ASM("yst-supp","DOC_CLS","单据类别","ASM","库存组装单"),
    COM_DOC_CLS_STKTRN("yst-supp","DOC_CLS","单据类别","STKTRN","库存转移单"),
    COM_DOC_CLS_STKCK("yst-supp","DOC_CLS","单据类别","STKCK","库存盘点单"),
    COM_REASON_CODE_183("yst-supp","REASON_CODE","原因码","183","183-收货调整"),
    INV_REASON_CODE_SKAJ("yst-inv","REASON_CODE_STKAJ","原因码","183","183-收货调整"),
    COM_REASON_CODE_101("yst-supp","REASON_CODE","原因码","101","101-保内售后配件领用"),
    COM_REASON_CODE_102("yst-supp","REASON_CODE","原因码","102","102-保外售后配件领用"),
    COM_REASON_CODE_107("yst-supp","REASON_CODE","原因码","107","107-盘盈"),
    COM_REASON_CODE_108("yst-supp","REASON_CODE","原因码","108","108-管理不善盘亏"),
    COM_REASON_CODE_119("yst-supp","REASON_CODE","原因码","119","119-保内售后配件入库"),
    REASON_CODE_STKAJ("yst-supp","REASON_CODE_STKAJ","原因码","200","200-期初调整"),
    COM_STATUS_ACTIVEORNO_ACTIVE("yst-supp","STATUS_ACTIVEORNO","启用停用状态","ACTIVE","有效"),
    COM_APPR_STATUS_APPROVING("yst-supp","APPR_STATUS","审批状态","APPROVING","审批中"),
    COM_APPR_STATUS_APPROVED("yst-supp","APPR_STATUS","审批状态","APPROVED","已批准"),
    COM_APPR_STATUS_REJECTED("yst-supp","APPR_STATUS","审批状态","REJECTED","已拒绝"),
    COM_APPR_STATUS_NOTSUBMIT("yst-supp","APPR_STATUS","审批状态","NOTSUBMIT","未提交"),
    COM_FRESS_TYPE_1("yst-supp","FRESS_TYPE","新鲜度类型","1","<1/3"),
    COM_FRESS_TYPE_2("yst-supp","FRESS_TYPE","新鲜度类型","2","1/3-1/2"),
    COM_FRESS_TYPE_3("yst-supp","FRESS_TYPE","新鲜度类型","3","1/2-2/3"),
    COM_FRESS_TYPE_4("yst-supp","FRESS_TYPE","新鲜度类型","4",">2/3"),
    COM_FRESS_TYPE_5("yst-supp","FRESS_TYPE","新鲜度类型","5","过期"),
    COM_UOM_BG("yst-supp","UOM","计量单位","BG","袋"),
    INV_OPT_TYPE_A("yst-inv","OPT_TYPE","库存操作参数选择","A","原仓库库存操作"),
    INV_OPT_TYPE_B("yst-inv","OPT_TYPE","库存操作参数选择","B","目的仓库库存操作"),
    INV_E1_BP_181012021("yst-inv","E1_BP","E1仓库","181012021","上海大昌行食品-ECL-常温好货仓(零售)"),
    INV_E1_LOC_DAMG("yst-inv","E1_LOC","E1库区","DAMG","DAMG"),
    INV_WH_PROP_SAL("yst-inv","WH_PROP","仓库属性","SAL","销售仓库"),
    INV_WH_PROP_PRU("yst-inv","WH_PROP","仓库属性","PRU","采购仓库"),
    INV_WH_PROP_AFTERSAL("yst-inv","WH_PROP","仓库属性","AFTERSAL","售后仓库"),
    INV_WH_TYPE_1("yst-inv","WH_TYPE","仓库类型","1","总仓"),
    INV_WH_TYPE_2("yst-inv","WH_TYPE","仓库类型","2","城市仓"),
    INV_WH_TYPE_3("yst-inv","WH_TYPE","仓库类型","3","网格仓"),
    INV_WH_TYPE_4("yst-inv","WH_TYPE","仓库类型","4","营业厅仓"),
    INV_WH_TYPE_5("yst-inv","WH_TYPE","仓库类型","5","售后仓"),
    INV_WH_TYPE_6("yst-inv","WH_TYPE","仓库类型","6","供应商仓"),
    INV_WH_TYPE_LOGICAL("yst-inv","WH_TYPE","仓库类型","LOGICAL","逻辑仓"),
    INV_FUNC_TYPE_1("yst-inv","FUNC_TYPE","功能区","1","增值产品库"),
    INV_FUNC_TYPE_9("yst-inv","FUNC_TYPE","功能区","9","TRAN - 在途（默认）"),
    INV_FUNC_TYPE_15("yst-inv","FUNC_TYPE","功能区","15","网格个人库"),
    INV_FUNC_TYPE_11("yst-inv","FUNC_TYPE","功能区","11","配件良品库"),
    INV_FUNC_TYPE_13("yst-inv","FUNC_TYPE","功能区","13","配件不良品库"),
    INV_FUNC_TYPE_16("yst-inv","FUNC_TYPE","功能区","16","虚拟中转库"),
    INV_FUNC_TYPE_18("yst-inv","FUNC_TYPE","功能区","18","高频C端产品库"),
    INV_FUNC_TYPE_20("yst-inv","FUNC_TYPE","功能区","20","低频C端产品库"),
    INV_FUNC_TYPE_22("yst-inv","FUNC_TYPE","功能区","22","南宁大件C端产品库"),
    PUR_PUR_BUSINESS_TYPE_INNER("PUR","PUR_BUSINESS_TYPE","采购业务团内团外","INNER","集团内业务"),
    INV_TEMP_TYPE_RT("yst-inv","TEMP_TYPE","温层","RT","常温"),
    INV_CK_STATUS_DR("yst-inv","CK_STATUS","盘点单状态","DR","草稿"),
    INV_CK_STATUS_APPED("yst-inv","CK_STATUS","盘点单状态","APPED","已审批"),
    INV_CK_STATUS_APPING("yst-inv","CK_STATUS","盘点单状态","APPING","审批中"),
    INV_CK_STATUS_RJ("yst-inv","CK_STATUS","盘点单状态","RJ","已拒绝"),
    INV_CK_STATUS_CL("yst-inv","CK_STATUS","盘点单状态","CL","已取消"),
    INV_CK_METHOD_BLD("yst-inv","CK_METHOD","盘点方式","BLD","盲盘"),
    INV_CK_METHOD_FACT("yst-inv","CK_METHOD","盘点方式","FACT","实盘"),
    INV_CK_MODE_ALL("yst-inv","CK_MODE","盘点模式","ALL","全库盘点"),
    INV_CK_MODE_ITEM("yst-inv","CK_MODE","盘点模式","ITEM","按指定商品盘点"),
    INV_CK_MODE_LOT("yst-inv","CK_MODE","盘点模式","LOT","按指定批次盘点"),
    INV_CK_TYPE_DAY("yst-inv","CK_TYPE","盘点类型","DAY","日盘"),
    INV_CK_TYPE_MON("yst-inv","CK_TYPE","盘点类型","MON","月盘"),
    INV_ASM_STATUS_DR("yst-inv","ASM_STATUS","组装单状态","DR","草稿"),
    INV_ASM_STATUS_CF("yst-inv","ASM_STATUS","组装单状态","CF","已确认"),
    INV_ASM_STATUS_CL("yst-inv","ASM_STATUS","组装单状态","CL","已取消"),
    INV_ASM_STATUS_APPING("yst-inv","ASM_STATUS","组装单状态","APPING","审批中"),
    INV_ASM_STATUS_APPED("yst-inv","ASM_STATUS","组装单状态","APPED","已审批"),
    INV_ASM_STATUS_RJ("yst-inv","ASM_STATUS","组装单状态","RJ","已拒绝"),
    INV_ASM_TYPE_DEF("yst-inv","ASM_TYPE","组装类型","DEF","默认"),
    INV_AJ_STATUS_DR("yst-inv","AJ_STATUS","调整单状态","DR","草稿"),
    INV_AJ_STATUS_CL("yst-inv","AJ_STATUS","调整单状态","CL","已取消"),
    INV_AJ_STATUS_APPING("yst-inv","AJ_STATUS","调整单状态","APPING","审批中"),
    INV_AJ_STATUS_APPED("yst-inv","AJ_STATUS","调整单状态","APPED","已审批"),
    INV_AJ_STATUS_CF("yst-inv","AJ_STATUS","调整单状态","CF","已确认"),
    INV_AJ_STATUS_RJ("yst-inv","AJ_STATUS","调整单状态","RJ","已拒绝"),
    INV_AJ_TYPE_STKCK("yst-inv","AJ_TYPE","调整类型","STKCK","盘点差异调整"),
    INV_AJ_TYPE_STKIN("yst-inv","AJ_TYPE","调整类型","STKIN","退料入库"),
    INV_AJ_TYPE_STKOUT("yst-inv","AJ_TYPE","调整类型","STKOUT","领料出库"),
    INV_AJ_TYPE_STKO("yst-inv","AJ_TYPE","调整类型","STKO","期初调整"),
    INV_AJ_TYPE_LOT("yst-inv","AJ_TYPE","调整类型","LOT","批次调整"),
    INV_AJ_TYPE_DES("yst-inv","AJ_TYPE","调整类型","DES","过期销毁"),
    INV_TRN_STATUS_DR("yst-inv","TRN_STATUS","转移单状态","DR","草稿"),
    INV_TRN_STATUS_CF("yst-inv","TRN_STATUS","转移单状态","CF","已确认"),
    INV_TRN_STATUS_RE("yst-inv","TRN_STATUS","转移单状态","RE","已收货"),
    INV_TRN_STATUS_CL("yst-inv","TRN_STATUS","转移单状态","CL","已取消"),
    INV_TRN_STATUS_APPING("yst-inv","TRN_STATUS","转移单状态","APPING","审批中"),
    INV_TRN_STATUS_APPED("yst-inv","TRN_STATUS","转移单状态","APPED","已审批"),
    INV_TRN_STATUS_RJ("yst-inv","TRN_STATUS","转移单状态","RJ","已拒绝"),
    INV_TRN_STATUS_YC("yst-inv","TRN_STATUS","转移单状态","YC","异常"),
    INV_TRN_TYPE_DEF("yst-inv","TRN_TYPE","转移类型","DEF","默认"),
    INV_RO_STATUS_DR("yst-inv","RO_STATUS","预留单状态","DR","草稿"),
    INV_RO_STATUS_APPING("yst-inv","RO_STATUS","预留单状态","APPING","审批中"),
    INV_RO_STATUS_APPED("yst-inv","RO_STATUS","预留单状态","APPED","已审批"),
    INV_RO_STATUS_RJ("yst-inv","RO_STATUS","预留单状态","RJ","已拒绝"),
    INV_RO_STATUS_RL("yst-inv","RO_STATUS","预留单状态","RL","已释放"),
    INV_RO_STATUS_CL("yst-inv","RO_STATUS","预留单状态","CL","已取消"),
    INV_RO_USE_TYPE_SO_ALLOC("yst-inv","RO_USE_TYPE","预留扣减类型","SO_ALLOC","订单分配"),
    INV_RO_USE_TYPE_CH_ALLOC("yst-inv","RO_USE_TYPE","预留扣减类型","CH_ALLOC","分配变更"),
    INV_RO_USE_TYPE_OD_RELEASE("yst-inv","RO_USE_TYPE","预留扣减类型","OD_RELEASE","过期释放"),
    INV_RO_USE_TYPE_MU_RELEASE("yst-inv","RO_USE_TYPE","预留扣减类型","MU_RELEASE","人工释放"),
    ITM_ITEM_TYPE_EHC("ITM","ITEM_TYPE","产品类型","EHC","Ethical"),
    ITM_ITEM_TYPE_NFD("ITM","ITEM_TYPE","产品类型","NFD","非食品"),
    ITM_ITEM_TYPE_FD("ITM","ITEM_TYPE","产品类型","FD","食品"),
    ITM_ITEM_TYPE1_ITM_CENTER("ITM","ITEM_TYPE","商品类型","10","实物类商品"),
    ITM_ITEM_TYPE2_10("ITM","ITEM_TYPE2","商品类型2","10","商品"),
    ITM_FIN_GL_TYPE_DEFAULT("ITM","FIN_GL_TYPE","商品总账级","DEFAULT","默认"),
    ITM_ITEM_STATUS_VALID("ITM","ITEM_STATUS","商品状态","VALID","有效"),
    ITM_ITEM_STATUS_INVALID("ITM","ITEM_STATUS","商品状态","INVALID","停用"),
    ORG_ADDRESS_TYPE_DEFAULT("ORG","ADDRESS_TYPE","地址类型","DEFAULT","默认地址"),
    ORG_ADDR_TYPE_WH("ORG","ADDR_TYPE","地址簿类型","WH","仓库"),
    ORG_BU_TYPE_WH("ORG","BU_TYPE","组织类型","WH","仓库"),
    PRI_CE_POLICY_BASE("PRI","CE_POLICY","公司间价格策略类型","BASE","基础提价"),
    PRI_CE_POLICY_OU("PRI","CE_POLICY","公司间价格策略类型","OU","公司间提价"),
    PRI_CE_POLICY_ITEM("PRI","CE_POLICY","公司间价格策略类型","ITEM","商品提价"),
    PRI_SALE_PRICE_TYPE_PRICEGROUP_PRICE("PRI","SALE_PRICE_TYPE","销售价格类型","PRICEGROUP_PRICE","政策组价格"),
    PRI_SALE_PRICE_TYPE_COST_PRICE("PRI","SALE_PRICE_TYPE","销售价格类型","COST_PRICE","成本价"),
    PUR_SS_STATUS_DR("PUR","SS_STATUS","供应商发货单状态","DR","草稿"),
    PUR_SS_STATUS_SUBMIT("PUR","SS_STATUS","供应商发货单状态","SUBMIT","已提交"),
    PUR_SS_STATUS_CONFIRMED("PUR","SS_STATUS","供应商发货单状态","CONFIRMED","仓管员已确认"),
    PUR_SS_STATUS_CF("PUR","SS_STATUS","供应商发货单状态","CF","已发货"),
    PUR_SS_STATUS_RJ("PUR","SS_STATUS","供应商发货单状态","RJ","已拒绝"),
    PUR_SS_STATUS_CL("PUR","SS_STATUS","供应商发货单状态","CL","已取消"),
    PUR_SS_STATUS_RSVING("PUR","SS_STATUS","供应商发货单状态","RSVING","部分收货"),
    PUR_SS_STATUS_DONE("PUR","SS_STATUS","供应商发货单状态","DONE","收货完成"),
    PUR_GR_STATUS_DR("PUR","GR_STATUS","采购收货单状态","DR","草稿"),
    PUR_GR_STATUS_CF("PUR","GR_STATUS","采购收货单状态","CF","已确认"),
    PUR_GR_STATUS_CL("PUR","GR_STATUS","采购收货单状态","CL","已取消"),
    PUR_PO_STATUS_CF("PUR","PO_STATUS","采购订单状态","CF","已确认"),
    PUR_PO_STATUS_SHIPPED("PUR","PO_STATUS","采购订单状态","SHIPPED","供应商已发货"),
    PUR_PO_STATUS_RSVING("PUR","PO_STATUS","采购订单状态","RSVING","部分收货"),
    PUR_PO_STATUS_DONE("PUR","PO_STATUS","采购订单状态","DONE","收货完成"),
    PUR_RNS_STATUS_CF("PUR","RNS_STATUS","采购退货单状态","CF","已确认"),
    PUR_RNS_STATUS_DONE("PUR", "RNS_STATUS", "采购退货单状态", "DONE", "退货完成"),
    PUR_RNS_STATUS_DR("PUR", "RNS_STATUS", "采购退货单状态", "DR", "草稿"),
    PUR_RNS_STATUS_WT("PUR", "RNS_STATUS", "采购退货单状态", "WT", "审批中"),
    PUR_RNS_STATUS_RJ("PUR", "RNS_STATUS", "采购退货单状态", "RJ", "审批拒绝"),
    PUR_RNS_STATUS_CL("PUR", "RNS_STATUS", "采购退货单状态", "CL", "已取消"),
    PUR_RNS_STATUS_RSVING("PUR", "RNS_STATUS", "采购退货单状态", "RSVING", "部分退货"),

    SAL_DO_STATUS_CF("SAL","DO_STATUS","发货单","CF","已发货"),
    SAL_SO_ALLOC_TYPE_USE_RO("SAL","SO_ALLOC_TYPE","订单配货类型","USE_RO","通过预留单"),
    SAL_SO_ALLOC_TYPE_RSV_OH("SAL","SO_ALLOC_TYPE","订单配货类型","RSV_OH","预留本公司库存"),
    SAL_RSO_STATUS_DONE("SAL","RSO_STATUS","退货单状态","DONE","已完成"),

    INV_LOT_SIN_STATUS_NON("yst-inv","LOT_SIN_STATUS","批次卫检状态","NON","待卫检"),
    INV_LOT_SIN_STATUS_PART("yst-inv","LOT_SIN_STATUS","批次卫检状态","PART","部分卫检"),
    INV_LOT_SIN_STATUS_ALL("yst-inv","LOT_SIN_STATUS","批次卫检状态","ALL","全部卫检"),
    INV_LOT_LOCK_REASON_EXP("yst-inv","LOT_LOCK_REASON","批次锁定原因","EXP","保质期天数疑似错误"),
    INV_LOT_LOCK_REASON_QC("yst-inv","LOT_LOCK_REASON","批次锁定原因","QC","质量锁定"),
    INV_LOT_QC_STATUS_LOCK("yst-inv","LOT_QC_STATUS","批次质量状态","LOCK","锁定"),
    INV_PARTNER_TYPE_CUST("yst-inv","PARTNER_TYPE","库存合作伙伴类型","CUST","客户"),
    INV_PARTNER_TYPE_SUPP("yst-inv","PARTNER_TYPE","库存合作伙伴类型","SUPP","供应商"),
    INV_PARTNER_TYPE_EMP("yst-inv","PARTNER_TYPE","库存合作伙伴类型","EMP","员工"),
    INV_PLN_INACTIVE_FOODS("yst-inv","INACTIVE_RULE","库存呆滞规则","FOODS","食品类"),
    INV_PLN_INACTIVE_OTHERS("yst-inv","INACTIVE_RULE","库存呆滞规则","OTHERS","其他"),
    INV_PLN_PICKING_RULE("yst-inv","PICKING_RULE","出库规则","FIFO","先入先出"),
    INV_LOT_DOC_CLS_STKAJ("yst-inv","DOC_CLS","单据类别","STKAJ","库存调整单"),
    INV_LOT_DOC_CLS_GR("yst-inv","DOC_CLS","单据类别","GR","采购入库单"),

    INV_STATUS_IN("yst-inv","INV_STATUS","库存状态","IN","在库"),
    INV_STATUS_OUT("yst-inv","INV_STATUS","库存状态","OUT","已出库"),
    PUR_CCOUNTBILLTYPE_GR("PUR","ACCOUNTBILLTYPE","单据类型","GR","采购收货登记"),

    PUR_ACCOUNT_TYPE_1("PUR","ACCOUNT_TYPE","对账类型","1","一件代发"),
    PUR_ACCOUNT_TYPE_2("PUR","ACCOUNT_TYPE","对账类型","2","非一件代发"),
    PUR_BUSSINESS_TYPE_COMMON("PUR", "BUSS_TYPE", "业务类型", "COMMON", "常规"),
    PUR_BUSSINESS_TYPE_ONEFORONE("PUR", "BUSS_TYPE", "业务类型", "ONEFORONE", "一件代发"),
    PUR_SCENE_TYPE_POSCENE("PUR", "SCENE_TYPE", "场景类型", "A", "采购场景"),
    PUR_SCENE_TYPE_RNSSCENE("PUR", "SCENE_TYPE", "场景类型", "B", "退货场景"),
    INV_OCCUPANCY_STATUS_O("yst-inv","OCCUPANCY_STATUS","库存锁定占用状态","O","已占有"),
    INV_OCCUPANCY_STATUS_NO("yst-inv","OCCUPANCY_STATUS","库存锁定占用状态","NO","未占用"),

    PUR_PARTS_INIT_STATUS_DR("PUR", "PARTS_INIT_STATUS", "期初配额状态", "DR", "草稿"),
    PUR_PARTS_INIT_STATUS_RJ("PUR", "PARTS_INIT_STATUS", "期初配额状态", "RJ", "已拒绝"),
    PUR_PARTS_INIT_STATUS_SUBMIT("" +
            "PUR", "PARTS_INIT_STATUS", "期初配额状态", "SUBMIT", "已提交"),
    PUR_PARTS_INIT_STATUS_DONE("PUR", "PARTS_INIT_STATUS", "期初配额状态", "DONE", "已审批"),
    PUR_PARTS_INIT_STATUS_CANCEL("PUR", "PARTS_INIT_STATUS", "期初配额状态", "CANCEL", "已作废"),

    //共享仓类型
    INV_PLN_SHARE_TYPE_D("yst-inv","SHARE_TYPE","共享类型","D","库存天数"),
    INV_PLN_SHARE_TYPE_R("yst-inv","SHARE_TYPE","共享类型","R","有效期比例"),
    INV_PLN_SHARE_TYPE_TD("yst-inv","SHARE_TYPE","共享类型","TD","库存周转天数"),

    ITM_ALLOC_TYPE_SUPP("ITM","ALLOC_TYPE","配货类型","SUPP","一件代发"),
    PUR_PO_STATUS_DR("PUR", "PO_STATUS", "采购订单状态", "DR", "草稿"),
    PUR_PO_STATUS_APPING("PUR", "PO_STATUS", "采购订单状态", "APPING", "审批中"),
    PUR_PO_STATUS_CL("PUR", "PO_STATUS", "采购订单状态", "CL", "已取消"),
    PUR_PO_STATUS_RJ("PUR", "PO_STATUS", "采购订单状态", "RJ", "已拒绝"),

    // 库存转移原因码
    INV_REASON_CODE_TRANS_201("yst-inv", "REASON_CODE_TRANS", "库存转移原因码", "201", "201-跨仓调货"),
    INV_REASON_CODE_TRANS_202("yst-inv", "REASON_CODE_TRANS", "库存转移原因码", "202", "202-同仓转移")

            ;
    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    UdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }


//    public String getValueCode() {
//        return valueCode;
//    }
//
//    public String getMsg() {
//        return valueCodeName;
//    }
//
//    public String getModel() {
//        return model;
//    }
//
//    public String getCode() {
//        return code;
//    }


}
