/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDRespVO;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvAjProcessService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.entity.QInvAjDO;
import com.elitesland.yst.production.inv.domain.service.InvAjDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvAjDomainService;
import com.elitesland.yst.production.inv.enums.InvStkSceneCodeEnum;
import com.elitesland.yst.production.inv.infr.dto.InvAjDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.repo.InvAjRepo;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvAjProcessServiceImpl
implements InvAjProcessService {
    private final JPAQueryFactory jpaQueryFactory;
    private final InvAjRepo invAjRepo;
    private final InvAjDomainService invAjDomainService;
    private final InvAjDDomainService invAjDDomainService;
    private final SystemService systemService;
    private final InvStkOptBizService invStkOptBizService;

    @Override
    @Transactional
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        Optional invAjDO = this.invAjRepo.findById(id);
        if (!invAjDO.isPresent()) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QInvAjDO qInvAjDO = QInvAjDO.invAjDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qInvAjDO).set(qInvAjDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{qInvAjDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: 
            case INTERRUPT: {
                jpaUpdateClause.set((Path)qInvAjDO.docStatus, (Object)UdcEnum.INV_AJ_STATUS_DR.getValueCode());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)qInvAjDO.docStatus, (Object)UdcEnum.INV_AJ_STATUS_RJ.getValueCode());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)qInvAjDO.docStatus, (Object)UdcEnum.INV_AJ_STATUS_CL.getValueCode());
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)qInvAjDO.docStatus, (Object)UdcEnum.INV_AJ_STATUS_APPING.getValueCode());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)qInvAjDO.docStatus, (Object)UdcEnum.INV_AJ_STATUS_APPED.getValueCode()).set(qInvAjDO.approvedTime, (Object)LocalDateTime.now());
            }
        }
        jpaUpdateClause.execute();
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            InvAjDTO invAjDTO = this.invAjDomainService.findById(id);
            if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjDTO.getDocType()) || UdcEnum.INV_AJ_TYPE_DES.getValueCode().equals(invAjDTO.getDocType()) || UdcEnum.INV_AJ_TYPE_STKOUT.getValueCode().equals(invAjDTO.getDocType())) {
                this.stratLock(invAjDTO);
            }
        }
    }

    @Override
    @Transactional
    public ArrayList<String> taskAssignee(Long id, String customParams) {
        List<Long> userIds = this.systemService.findUserIdsByFlowRoles(id, customParams);
        ArrayList<String> userStrIds = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds.stream().forEach(i -> {
                String newString = String.valueOf(i);
                userStrIds.add(newString);
            });
            return userStrIds;
        }
        return null;
    }

    private void stratLock(InvAjDTO invAjDTO) {
        if (Objects.nonNull(invAjDTO)) {
            List<InvAjDRespVO> invAjDVOS = this.invAjDDomainService.findByMasId(invAjDTO.getId());
            InvStkCommonOperateDTO operateDTO = this.getInvStkCommonOperateDTO(invAjDVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ002.getType());
            this.invStkOptBizService.invStkCommonOperate(operateDTO);
        }
    }

    private InvStkCommonOperateDTO getInvStkCommonOperateDTO(List<InvAjDRespVO> invAjDRespVOS, InvAjDTO invAjDTO, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-", ""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<InvStkCommonOperateBodyDTO>();
        invAjDRespVOS.stream().forEach(invAjDSaveVO -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invAjDSaveVO.getWhId());
            operateBodyDTO.setItemId(invAjDSaveVO.getItemId());
            operateBodyDTO.setDeter2(invAjDSaveVO.getDeter2());
            operateBodyDTO.setSrcDocId(invAjDTO.getId());
            operateBodyDTO.setDocNo(invAjDTO.getDocNo());
            operateBodyDTO.setSrcDocDid(invAjDSaveVO.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKOUT.getValueCode());
            operateBodyDTO.setLineNo(invAjDSaveVO.getLineNo());
            operateBodyDTO.setCreateUserId(invAjDTO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invAjDSaveVO.getUom());
            operateBodyDTO.setQty(invAjDSaveVO.getQty());
            operateBodyDTO.setLotNo(invAjDSaveVO.getLotNo());
            if (UdcEnum.INV_AJ_TYPE_STKIN.getValueCode().equals(invAjDTO.getDocType()) || UdcEnum.INV_AJ_TYPE_STKO.getValueCode().equals(invAjDTO.getDocType())) {
                operateBodyDTO.setLotNo(invAjDSaveVO.getToLotNo());
            }
            operateBodyDTO.setPCode(invAjDSaveVO.getPCode());
            operateBodyDTO.setPType(invAjDSaveVO.getPType());
            operateBodyDTO.setOuId(invAjDTO.getOuId());
            operateBodyDTO.setVariId(invAjDSaveVO.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        operateDTO.setSourceBodyList(operateBodyDTOS);
        return operateDTO;
    }

    public InvAjProcessServiceImpl(JPAQueryFactory jpaQueryFactory, InvAjRepo invAjRepo, InvAjDomainService invAjDomainService, InvAjDDomainService invAjDDomainService, SystemService systemService, InvStkOptBizService invStkOptBizService) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.invAjRepo = invAjRepo;
        this.invAjDomainService = invAjDomainService;
        this.invAjDDomainService = invAjDDomainService;
        this.systemService = systemService;
        this.invStkOptBizService = invStkOptBizService;
    }
}

