/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCommon21FilterParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCommon21InVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCommonSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotSaveVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvLotCommonService;
import com.elitesland.yst.production.inv.application.service.InvLotService;
import com.elitesland.yst.production.inv.domain.convert.InvLotConvert;
import com.elitesland.yst.production.inv.domain.entity.lot.InvLot;
import com.elitesland.yst.production.inv.domain.service.InvLotDomainService;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvLotCommonServiceImpl
implements InvLotCommonService {
    private static final Logger log = LoggerFactory.getLogger(InvLotCommonServiceImpl.class);
    private final InvLotService invLotService;
    private final InvLotDomainService invLotDomainService;
    private final SystemService systemService;
    private final ItmOutService itmOutService;

    @Override
    public Map<Integer, List<InvLotRespVO>> getInvLotVOList(List<InvLotCommon21InVO> inVOList) {
        log.info("\u5171\u901a\u65b9\u6cd521\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", inVOList.stream().map(InvLotCommon21InVO::toString).collect(Collectors.toList())));
        Map<Integer, List<InvLotRespVO>> result = Collections.synchronizedMap(new HashMap());
        if (CollectionUtils.isEmpty(inVOList)) {
            List<InvLotRespVO> invLotList = this.invLotService.findByParams(new InvLotParam());
            result.put(0, invLotList);
        } else {
            inVOList.stream().forEach(i -> {
                InvLotParam queryParam = new InvLotParam();
                queryParam.setItemId(i.getItemId());
                queryParam.setVariId(i.getVariId());
                queryParam.setLotNo(i.getLotNo());
                queryParam.setOuId(i.getOuId());
                List<InvLotRespVO> invLotList = this.invLotService.findByParams(queryParam);
                if (!CollectionUtils.isEmpty(invLotList)) {
                    result.put(inVOList.indexOf(i), invLotList);
                }
            });
        }
        return result;
    }

    @Override
    public Map<String, List<InvLotRespVO>> getInvLotVOListByKey(List<String> concatKey) {
        log.info("getInvLotVOListByKey\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), concatKey);
        if (CollectionUtils.isEmpty(concatKey)) {
            return new HashMap<String, List<InvLotRespVO>>();
        }
        List<InvLotRespVO> list = this.invLotService.findByQueryParam(concatKey);
        return list.stream().collect(Collectors.groupingBy(lot -> lot.getItemId() == null ? "" : "" + lot.getItemId() + (Serializable)(lot.getVariId() == null ? "" : lot.getVariId()) + lot.getLotNo() + lot.getOuId()));
    }

    @Override
    public List<InvLotRespVO> getInvLotVOListByParam(InvLotParam queryParam) {
        List<InvLotRespVO> invLotRespVOS = this.invLotService.findByParams(queryParam);
        return invLotRespVOS;
    }

    @Override
    public List<InvLotRespVO> getInvLotCheckedList(List<InvLotRespVO> source, InvLotCommon21FilterParamVO filterVO) {
        return source.stream().filter(i -> {
            if (!StringUtils.isEmpty((Object)filterVO.getLotStatus())) {
                return filterVO.getLotStatus().equals(i.getLotStatus());
            }
            return true;
        }).filter(i -> {
            if (!StringUtils.isEmpty((Object)filterVO.getQcStatus())) {
                return filterVO.getQcStatus().equals(i.getQcStatus());
            }
            return true;
        }).filter(i -> {
            if (!StringUtils.isEmpty((Object)filterVO.getFirstLotNo())) {
                return filterVO.getFirstLotNo().compareTo(i.getLotNo()) <= 0;
            }
            return true;
        }).filter(i -> {
            if (StringUtils.isEmpty((Object)filterVO.getFressType())) {
                return true;
            }
            return filterVO.getFressType().equals(i.getFressType());
        }).filter(i -> {
            if (filterVO.getFressTypeDays() != null) {
                if (filterVO.getAdjustDays() == null) {
                    return (i.getUntilExpireDays() == null ? 0.0 : (double)i.getUntilExpireDays().intValue()) >= filterVO.getFressTypeDays();
                }
                return (i.getUntilExpireDays() == null ? 0.0 : (double)i.getUntilExpireDays().intValue()) >= filterVO.getFressTypeDays() + filterVO.getAdjustDays();
            }
            return true;
        }).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public ApiResult createInvLotInfo(List<InvLotSaveVO> source) {
        log.info("\u5171\u901a\u65b9\u6cd522\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", source.stream().map(InvLotSaveVO::toString).collect(Collectors.toList())));
        List<InvLotCommonSaveVO> lotVOS = source.stream().map(i -> {
            InvLotCommonSaveVO vo = new InvLotCommonSaveVO();
            BeanUtils.copyProperties((Object)i, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
        Map<Integer, List<InvLotRespVO>> map = this.checkIn(lotVOS);
        try {
            List<InvLotCommonSaveVO> sourceClone = BeanCopyUtil.deepCopy(lotVOS);
            map.keySet().stream().forEach(key -> {
                List list = (List)map.get(key);
                list.stream().forEach(v -> {
                    String a = v.getItemId() + "_" + v.getVariId() + "_" + v.getLotNo() + "_" + v.getOuId();
                    Iterator ite = sourceClone.iterator();
                    while (ite.hasNext()) {
                        InvLotCommonSaveVO s = (InvLotCommonSaveVO)ite.next();
                        String b = s.getItemId() + "_" + s.getVariId() + "_" + s.getLotNo() + "_" + v.getOuId();
                        if (!a.equals(b)) continue;
                        ite.remove();
                    }
                });
            });
            sourceClone.forEach(i -> i.setFirstInDate(LocalDateTime.now()));
            ArrayList<InvLot> invLotList = new ArrayList<InvLot>();
            for (InvLotCommonSaveVO invLotCommonSaveVO : sourceClone) {
                invLotCommonSaveVO.setCreateTime(LocalDateTime.now());
                InvLot invLot = InvLotConvert.INSTANCE.comSaveVoToEn(invLotCommonSaveVO);
                invLotList.add(invLot);
            }
            List lotList = invLotList.stream().filter(i -> i.getLotNo() != null && !"".equals(i.getLotNo())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(lotList)) {
                ArrayList lotSaveVOS = invLotList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<InvLot>(Comparator.comparing(o -> o.getItemId() + "_" + o.getLotNo() + "_" + o.getOuId() + "_" + o.getVariId()))), ArrayList::new));
                this.invLotDomainService.createBatch(lotSaveVOS);
            }
            return ((ApiResult)((ApiResult)((ApiResult)((ApiResult)ApiResult.builder().success(true)).code(0)).data(source)).msg("\u64cd\u4f5c\u6210\u529f")).build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return ((ApiResult)((ApiResult)((ApiResult)ApiResult.builder().success(false)).data(source)).msg("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage())).build();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return ((ApiResult)((ApiResult)((ApiResult)ApiResult.builder().success(false)).data(source)).msg("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage())).build();
        }
    }

    @Override
    @Transactional
    public ApiResult updateInvLotInfo(List<InvLotCommonSaveVO> source) {
        log.info("\u5171\u901a\u65b9\u6cd523\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)String.join((CharSequence)",", source.stream().map(InvLotCommonSaveVO::toString).collect(Collectors.toList())));
        Map<Integer, List<InvLotRespVO>> map = this.checkIn(source);
        List errMsgList = Collections.synchronizedList(new ArrayList());
        map.keySet().stream().forEach(key -> {
            List list = (List)map.get(key);
            if (CollectionUtils.isEmpty((Collection)list)) {
                InvLotCommonSaveVO invLotCommonSaveVO = (InvLotCommonSaveVO)source.get((int)key);
                errMsgList.add(String.format("[\u5546\u54c1\uff1a%s\u3001VARI_ID:%s\u3001\u6279\u6b21\u53f7:%s\u3001\u516c\u53f8:%s]", invLotCommonSaveVO.getItemId(), invLotCommonSaveVO.getVariId(), invLotCommonSaveVO.getLotNo(), invLotCommonSaveVO.getOuId()));
            }
        });
        if (!CollectionUtils.isEmpty(errMsgList)) {
            throw new BusinessException("\u7ef4\u62a4\u6279\u6b21" + errMsgList.stream().collect(Collectors.joining(",")) + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u3002");
        }
        ArrayList<InvLot> invLotList = new ArrayList<InvLot>();
        for (InvLotCommonSaveVO invLotCommonSaveVO : source) {
            InvLot invLot = InvLotConvert.INSTANCE.comSaveVoToEn(invLotCommonSaveVO);
            invLotList.add(invLot);
        }
        this.invLotDomainService.createBatch(invLotList);
        return ((ApiResult)((ApiResult)((ApiResult)((ApiResult)ApiResult.builder().success(true)).code(0)).data(source)).msg("\u64cd\u4f5c\u6210\u529f")).build();
    }

    private List<String> checkStoreExpireDaysAndSetLockReason(List<InvLot> source) {
        List itemLists = source.stream().map(InvLot::getItemId).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam partParam = new ItmItemRpcDtoParam();
        partParam.setItemIds(itemLists);
        List<ItmItemRpcDTO> itemVOList = this.itmOutService.findItemRpcDtoByParam(partParam);
        long storeExpireDaysSetting = 0L;
        String warnMsg = "[\u5546\u54c1:%s\u3001VARI_ID:%s\u3001\u6279\u6b21\u53f7:%s\u3001\u516c\u53f8:%s]";
        ArrayList<String> warnMsgList = new ArrayList<String>();
        long finalStoreExpireDaysSetting = storeExpireDaysSetting;
        source.forEach(i -> {
            ItmItemRpcDTO itmItemVO;
            if (!CollectionUtils.isEmpty((Collection)itemVOList) && (itmItemVO = itemVOList.stream().filter(item -> item.getId().equals(i.getItemId())).findAny().get()) != null) {
                i.setItemCode(itmItemVO.getItemCode());
            }
            if ("LOCK".equals(i.getQcStatus())) {
                i.setLotStatus("1");
            } else if (i.getManuDate() != null && i.getExpireDate() != null) {
                long between = ChronoUnit.DAYS.between(i.getManuDate().toLocalDate(), i.getExpireDate().toLocalDate());
                i.setLotStatus("0");
                if (Math.abs(between - (i.getExpireDays() == null ? 0L : i.getExpireDays().longValue())) > finalStoreExpireDaysSetting) {
                    i.setLotStatus("1");
                    i.setLockReason(UdcEnum.INV_LOT_LOCK_REASON_EXP.getValueCode());
                    warnMsgList.add(String.format(warnMsg, i.getItemId(), i.getVariId(), i.getLotNo(), i.getOuId()));
                    log.info("\u5171\u901a\u65b9\u6cd522(\u51fa\u73b0\u9501\u5b9a\u72b6\u6001\u6570\u636e)\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)i.toString());
                }
            }
            if (i.getExpireDate() != null) {
                Long expireDays = i.getExpireDate().toLocalDate().toEpochDay() - LocalDate.now().toEpochDay();
                i.setUntilExpireDays(expireDays < 0L ? 0 : expireDays.intValue());
                Long days = LocalDate.now().toEpochDay() - i.getManuDate().toLocalDate().toEpochDay();
                double fress = days.doubleValue() / (null == i.getExpireDays() ? 9999.0 : i.getExpireDays().doubleValue());
                if (fress < 0.3333333333333333) {
                    i.setFressType(UdcEnum.COM_FRESS_TYPE_1.getValueCode());
                } else if (fress >= 0.3333333333333333 && fress < 0.5) {
                    i.setFressType(UdcEnum.COM_FRESS_TYPE_2.getValueCode());
                } else if (fress >= 0.5 && fress < 0.6666666666666666) {
                    i.setFressType(UdcEnum.COM_FRESS_TYPE_3.getValueCode());
                } else if (fress >= 0.6666666666666666 && fress < 1.0) {
                    i.setFressType(UdcEnum.COM_FRESS_TYPE_4.getValueCode());
                } else {
                    i.setFressType(UdcEnum.COM_FRESS_TYPE_5.getValueCode());
                }
                i.setDeleteFlag(0);
            }
        });
        return warnMsgList;
    }

    private Map<Integer, List<InvLotRespVO>> checkIn(List<InvLotCommonSaveVO> lotVOList) {
        List<InvLotCommon21InVO> invLotCommon21InVOS = Collections.synchronizedList(new ArrayList());
        lotVOList.stream().forEach(i -> {
            if (i.getManuDate() != null && i.getExpireDate() != null && i.getManuDate().isAfter(i.getExpireDate())) {
                throw new BusinessException("\u5931\u6548\u65e5\u671f\u8bbe\u7f6e\u4e0d\u80fd\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            InvLotCommon21InVO inVO = new InvLotCommon21InVO();
            inVO.setItemId(i.getItemId());
            inVO.setItemCode(i.getItemCode());
            inVO.setVariId(i.getVariId());
            inVO.setLotNo(i.getLotNo());
            inVO.setOuId(i.getOuId());
            invLotCommon21InVOS.add(inVO);
        });
        return this.getInvLotVOList(invLotCommon21InVOS);
    }

    public InvLotCommonServiceImpl(InvLotService invLotService, InvLotDomainService invLotDomainService, SystemService systemService, ItmOutService itmOutService) {
        this.invLotService = invLotService;
        this.invLotDomainService = invLotDomainService;
        this.systemService = systemService;
        this.itmOutService = itmOutService;
    }
}

