/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.scene.InvSceneConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.scene.InvSceneConfigQueryVO;
import com.elitesland.yst.production.inv.application.facade.vo.scene.param.InvSceneConfigQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.scene.param.InvSceneConfigSaveParam;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvSceneConfigBizService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaSettingService;
import com.elitesland.yst.production.inv.domain.convert.scene.InvSceneConfigConvert;
import com.elitesland.yst.production.inv.domain.convert.scene.InvSceneConfigDtlConvert;
import com.elitesland.yst.production.inv.domain.entity.scene.InvSceneConfigDO;
import com.elitesland.yst.production.inv.domain.entity.scene.InvSceneConfigDtlDO;
import com.elitesland.yst.production.inv.domain.service.InvIocDomainService;
import com.elitesland.yst.production.inv.domain.service.InvSceneConfigDomainService;
import com.elitesland.yst.production.inv.domain.service.InvSceneConfigDtlDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvIocDTO;
import com.elitesland.yst.production.inv.infr.dto.InvSceneConfigDTO;
import com.elitesland.yst.production.inv.infr.dto.InvSceneConfigDtlDTO;
import com.elitesland.yst.production.inv.infr.repo.scene.InvSceneConfigDtlRepo;
import com.elitesland.yst.production.inv.infr.repo.scene.InvSceneConfigRepo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="invSceneConfigBizService")
@Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
public class InvSceneConfigBizServiceImpl
implements InvSceneConfigBizService {
    private static final Logger log = LoggerFactory.getLogger(InvSceneConfigBizServiceImpl.class);
    private final InvSceneConfigDomainService invSceneConfigService;
    private final InvSceneConfigDtlDomainService invSceneConfigDtlDomainService;
    private final InvIocDomainService invIocDomainService;
    private final RedissonClient redissonClient;
    private final InvSceneConfigRepo invSceneConfigRepo;
    private final InvSceneConfigDtlRepo invSceneConfigDtlRepo;
    private final SystemService systemService;
    private final InvWhAreaSettingService invWhAreaSettingService;

    @Override
    @SysCodeProc
    public PagingVO<InvSceneConfigPageVO> searchPage(InvSceneConfigQueryParam param) {
        PagingVO<InvSceneConfigPageVO> invSceneConfigPageVOPagingVO = this.invSceneConfigService.searchPage(param);
        if (CollectionUtil.isNotEmpty((Collection)invSceneConfigPageVOPagingVO.getRecords())) {
            this.convertPage(invSceneConfigPageVOPagingVO.getRecords());
        }
        return invSceneConfigPageVOPagingVO;
    }

    @Override
    public Long saveOrUpdate(InvSceneConfigSaveParam param) {
        InvSceneConfigDO dbSceneConfig = this.validateParam(param);
        return this.persistence(param, dbSceneConfig);
    }

    private Long persistence(InvSceneConfigSaveParam param, InvSceneConfigDO dbSceneConfig) {
        if (dbSceneConfig == null) {
            return this.saveConfigAndDtl(param);
        }
        this.removeCache(dbSceneConfig.getSceneCode());
        return this.updateConfigAndDtl(param);
    }

    private Long updateConfigAndDtl(InvSceneConfigSaveParam param) {
        InvSceneConfigDO invSceneConfigDO = InvSceneConfigConvert.INSTANCE.param2DO(param);
        List<InvSceneConfigDtlDO> invSceneConfigDtlDOS = InvSceneConfigDtlConvert.INSTANCE.param2DOList(param.getInvSceneConfigDtlList());
        invSceneConfigDtlDOS.stream().forEach(dtl -> dtl.setMasId(invSceneConfigDO.getId()));
        this.invSceneConfigService.updateDynamically(invSceneConfigDO);
        this.invSceneConfigDtlDomainService.deleteByCondition(this.getQueryBeanByMasId(invSceneConfigDO.getId()));
        this.invSceneConfigDtlDomainService.saveAll(invSceneConfigDtlDOS);
        return invSceneConfigDO.getId();
    }

    private Long saveConfigAndDtl(InvSceneConfigSaveParam param) {
        InvSceneConfigDO invSceneConfigDO = InvSceneConfigConvert.INSTANCE.param2DO(param);
        List<InvSceneConfigDtlDO> invSceneConfigDtlDOS = InvSceneConfigDtlConvert.INSTANCE.param2DOList(param.getInvSceneConfigDtlList());
        this.invSceneConfigRepo.save(invSceneConfigDO);
        invSceneConfigDtlDOS.forEach(dtl -> dtl.setMasId(invSceneConfigDO.getId()));
        this.invSceneConfigDtlRepo.saveAll(invSceneConfigDtlDOS);
        return invSceneConfigDO.getId();
    }

    private InvSceneConfigDO validateParam(InvSceneConfigSaveParam param) {
        long count;
        Optional<InvSceneConfigDO> invSceneConfigDOOptional;
        InvSceneConfigDO dbSceneConfig = null;
        if (CollectionUtil.isEmpty(param.getInvSceneConfigDtlList())) {
            throw new BusinessException("\u5e93\u5b58\u573a\u666f\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        param.setLine();
        if (param.getId() != null && (invSceneConfigDOOptional = this.invSceneConfigService.findById(param.getId())).isPresent()) {
            dbSceneConfig = invSceneConfigDOOptional.get();
        }
        if (dbSceneConfig == null) {
            this.validateParamBySave(param);
        } else {
            this.validateParamByUpdate(param);
        }
        List<InvSceneConfigQueryVO> sceneCode = this.invSceneConfigService.findSceneConfiBySceneCode(param.getSceneCode());
        if (!CollectionUtils.isEmpty(sceneCode) && (count = sceneCode.stream().filter(i -> !i.getId().equals(param.getId())).count()) > 0L) {
            throw new BusinessException("\u5e93\u5b58\u573a\u666f\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d");
        }
        return dbSceneConfig;
    }

    private void validateParamByUpdate(InvSceneConfigSaveParam param) {
        param.validateHeadByUpdate(param);
        param.validateBodyBySave(param.getInvSceneConfigDtlList());
    }

    private void validateParamBySave(InvSceneConfigSaveParam param) {
        param.validateHeadBySave(param);
        param.validateBodyBySave(param.getInvSceneConfigDtlList());
    }

    @Override
    public void del(Long id) {
        Optional<InvSceneConfigDO> invSceneConfigDOOptional = this.invSceneConfigService.findById(id);
        if (invSceneConfigDOOptional.isPresent()) {
            InvSceneConfigDO dbSceneConfig = invSceneConfigDOOptional.get();
            this.invSceneConfigDtlDomainService.deleteByCondition(this.getQueryBeanByMasId(id));
            this.invSceneConfigService.deleteById(id);
            this.removeCache(dbSceneConfig.getSceneCode());
        }
    }

    private InvSceneConfigDtlDO getQueryBeanByMasId(Long id) {
        InvSceneConfigDtlDO whereBean = new InvSceneConfigDtlDO();
        whereBean.setMasId(id);
        return whereBean;
    }

    @Override
    @SysCodeProc
    public InvSceneConfigQueryVO detail(Long masId) {
        Optional dbConfig = this.invSceneConfigRepo.findById(masId);
        if (!dbConfig.isPresent()) {
            return null;
        }
        InvSceneConfigQueryVO queryVO = InvSceneConfigConvert.INSTANCE.do2VO((InvSceneConfigDO)dbConfig.get());
        Example example = Example.of((Object)this.getQueryBeanByMasId(masId));
        List<InvSceneConfigDtlDO> all = this.invSceneConfigDtlDomainService.findAll(example);
        List<InvSceneConfigQueryVO.InvSceneConfigDtl> invSceneConfigDtls = InvSceneConfigDtlConvert.INSTANCE.do2VOList(all);
        queryVO.setInvSceneConfigDtlList(invSceneConfigDtls);
        this.convertDtls(invSceneConfigDtls);
        return queryVO;
    }

    private void removeCache(String sceneCode) {
        RBucket bucket = this.redissonClient.getBucket("YST_INV_SCENE_CONFIG_KEY_" + sceneCode);
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    @Override
    public InvSceneConfigDTO getBySceneCode(String sceneCode) {
        RBucket bucket = this.redissonClient.getBucket("YST_INV_SCENE_CONFIG_KEY_" + sceneCode);
        if (bucket.isExists()) {
            return (InvSceneConfigDTO)bucket.get();
        }
        InvSceneConfigDTO dbConfig = this.invSceneConfigService.findBySceneCode(sceneCode);
        if (dbConfig != null) {
            Example dtlExample = Example.of((Object)this.getQueryBeanByMasId(dbConfig.getId()));
            List<InvSceneConfigDtlDO> all = this.invSceneConfigDtlDomainService.findAll(dtlExample);
            List<InvSceneConfigDtlDTO> invSceneConfigDtls = InvSceneConfigDtlConvert.INSTANCE.do2DTOList(all);
            dbConfig.setInvSceneConfigDtlList(invSceneConfigDtls);
            bucket.set((Object)dbConfig);
            return dbConfig;
        }
        return null;
    }

    private void convertDtls(List<InvSceneConfigQueryVO.InvSceneConfigDtl> invSceneConfigDtls) {
        List<InvIocDTO> invIocNameList = this.invIocDomainService.findByCodeBatch(invSceneConfigDtls.stream().map(InvSceneConfigQueryVO.InvSceneConfigDtl::getIoCode).collect(Collectors.toList()));
        List<String> deter2s = invSceneConfigDtls.stream().map(InvSceneConfigQueryVO.InvSceneConfigDtl::getDeter2).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<InvWhAreaSettingRespVO> whAreaSettingRespVOS = this.invWhAreaSettingService.findByDeter2Types(deter2s);
        Map<Object, Object> ioCodeMap = new HashMap();
        Map<Object, Object> ioTypeMap = new HashMap();
        Map<Object, Object> deter2TypeMap = new HashMap();
        if (CollectionUtils.isNotEmpty(invIocNameList)) {
            ioTypeMap = invIocNameList.stream().collect(Collectors.toMap(InvIocDTO::getIoType, InvIocDTO::getIoTypeName, (key1, key2) -> key2));
            ioCodeMap = invIocNameList.stream().collect(Collectors.toMap(InvIocDTO::getIoCode, InvIocDTO::getIoName, (key1, key2) -> key2));
        }
        if (!CollectionUtils.isEmpty(whAreaSettingRespVOS)) {
            deter2TypeMap = whAreaSettingRespVOS.stream().collect(Collectors.toMap(InvWhAreaSettingRespVO::getDeter2Type, InvWhAreaSettingRespVO::getDeter2TypeName, (key1, key2) -> key2));
        }
        for (InvSceneConfigQueryVO.InvSceneConfigDtl configDtl : invSceneConfigDtls) {
            if (StringUtils.isNotBlank((CharSequence)configDtl.getIoCode())) {
                configDtl.setIoName((String)ioCodeMap.get(configDtl.getIoCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)configDtl.getIoType())) {
                configDtl.setIoTypeName((String)ioTypeMap.get(configDtl.getIoType()));
            }
            if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{configDtl.getDeter2()})) continue;
            configDtl.setDeter2Name((String)deter2TypeMap.get(configDtl.getDeter2()));
        }
    }

    private void convertPage(List<InvSceneConfigPageVO> invSceneConfigDtls) {
        List<InvIocDTO> invIocNameList = this.invIocDomainService.findByCodeBatch(invSceneConfigDtls.stream().map(InvSceneConfigPageVO::getIoCode).collect(Collectors.toList()));
        Map<Object, Object> ioCodeMap = new HashMap();
        Map<Object, Object> ioTypeMap = new HashMap();
        if (CollectionUtils.isNotEmpty(invIocNameList)) {
            ioTypeMap = invIocNameList.stream().collect(Collectors.toMap(InvIocDTO::getIoType, i -> i.getIoTypeName() == null ? "" : i.getIoTypeName(), (key1, key2) -> key2));
            ioCodeMap = invIocNameList.stream().collect(Collectors.toMap(InvIocDTO::getIoCode, i -> i.getIoName() == null ? "" : i.getIoName(), (key1, key2) -> key2));
        }
        for (InvSceneConfigPageVO configDtl : invSceneConfigDtls) {
            if (StringUtils.isNotBlank((CharSequence)configDtl.getIoCode())) {
                configDtl.setIoName((String)ioCodeMap.get(configDtl.getIoCode()));
            }
            if (!StringUtils.isNotBlank((CharSequence)configDtl.getIoType())) continue;
            configDtl.setIoTypeName((String)ioTypeMap.get(configDtl.getIoType()));
        }
    }

    public InvSceneConfigBizServiceImpl(InvSceneConfigDomainService invSceneConfigService, InvSceneConfigDtlDomainService invSceneConfigDtlDomainService, InvIocDomainService invIocDomainService, RedissonClient redissonClient, InvSceneConfigRepo invSceneConfigRepo, InvSceneConfigDtlRepo invSceneConfigDtlRepo, SystemService systemService, InvWhAreaSettingService invWhAreaSettingService) {
        this.invSceneConfigService = invSceneConfigService;
        this.invSceneConfigDtlDomainService = invSceneConfigDtlDomainService;
        this.invIocDomainService = invIocDomainService;
        this.redissonClient = redissonClient;
        this.invSceneConfigRepo = invSceneConfigRepo;
        this.invSceneConfigDtlRepo = invSceneConfigDtlRepo;
        this.systemService = systemService;
        this.invWhAreaSettingService = invWhAreaSettingService;
    }
}

